/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.types.predicate.impl;

import java.util.Objects;
import org.apache.lucene.analysis.Analyzer;
import org.hibernate.search.backend.lucene.scope.model.impl.LuceneCompatibilityChecker;
import org.hibernate.search.backend.lucene.search.impl.LuceneSearchContext;
import org.hibernate.search.backend.lucene.search.predicate.impl.LuceneSearchPredicateBuilder;
import org.hibernate.search.backend.lucene.types.codec.impl.LuceneTextFieldCodec;
import org.hibernate.search.backend.lucene.types.predicate.impl.AbstractLuceneStandardFieldPredicateBuilderFactory;
import org.hibernate.search.backend.lucene.types.predicate.impl.LuceneFieldPredicateBuilderFactory;
import org.hibernate.search.backend.lucene.types.predicate.impl.LuceneSimpleQueryStringPredicateBuilderFieldState;
import org.hibernate.search.backend.lucene.types.predicate.impl.LuceneTextMatchPredicateBuilder;
import org.hibernate.search.backend.lucene.types.predicate.impl.LuceneTextPhrasePredicateBuilder;
import org.hibernate.search.backend.lucene.types.predicate.impl.LuceneTextRangePredicateBuilder;
import org.hibernate.search.backend.lucene.types.predicate.impl.LuceneTextWildcardPredicateBuilder;
import org.hibernate.search.engine.backend.types.converter.ToDocumentFieldValueConverter;
import org.hibernate.search.engine.search.predicate.spi.PhrasePredicateBuilder;
import org.hibernate.search.engine.search.predicate.spi.WildcardPredicateBuilder;

public final class LuceneTextFieldPredicateBuilderFactory<F>
extends AbstractLuceneStandardFieldPredicateBuilderFactory<F, LuceneTextFieldCodec<F>> {
    private final Analyzer analyzerOrNormalizer;
    private final Analyzer analyzer;
    private final Analyzer normalizer;

    public LuceneTextFieldPredicateBuilderFactory(boolean searchable, ToDocumentFieldValueConverter<?, ? extends F> converter, ToDocumentFieldValueConverter<F, ? extends F> rawConverter, LuceneTextFieldCodec<F> codec, Analyzer analyzerOrNormalizer, Analyzer analyzer, Analyzer normalizer) {
        super(searchable, converter, rawConverter, codec);
        this.analyzerOrNormalizer = analyzerOrNormalizer;
        this.analyzer = analyzer;
        this.normalizer = normalizer;
    }

    public LuceneTextMatchPredicateBuilder<?> createMatchPredicateBuilder(LuceneSearchContext searchContext, String absoluteFieldPath, LuceneCompatibilityChecker converterChecker, LuceneCompatibilityChecker analyzerChecker) {
        this.checkSearchable(absoluteFieldPath);
        return new LuceneTextMatchPredicateBuilder(searchContext, absoluteFieldPath, this.converter, this.rawConverter, converterChecker, (LuceneTextFieldCodec)this.codec, this.analyzerOrNormalizer, analyzerChecker);
    }

    public LuceneTextRangePredicateBuilder<?> createRangePredicateBuilder(LuceneSearchContext searchContext, String absoluteFieldPath, LuceneCompatibilityChecker converterChecker) {
        this.checkSearchable(absoluteFieldPath);
        return new LuceneTextRangePredicateBuilder(searchContext, absoluteFieldPath, this.converter, this.rawConverter, converterChecker, (LuceneTextFieldCodec)this.codec);
    }

    @Override
    public PhrasePredicateBuilder<LuceneSearchPredicateBuilder> createPhrasePredicateBuilder(LuceneSearchContext searchContext, String absoluteFieldPath, LuceneCompatibilityChecker analyzerChecker) {
        this.checkSearchable(absoluteFieldPath);
        return new LuceneTextPhrasePredicateBuilder(searchContext, absoluteFieldPath, (LuceneTextFieldCodec)this.codec, this.analyzerOrNormalizer, analyzerChecker);
    }

    @Override
    public WildcardPredicateBuilder<LuceneSearchPredicateBuilder> createWildcardPredicateBuilder(String absoluteFieldPath) {
        this.checkSearchable(absoluteFieldPath);
        return new LuceneTextWildcardPredicateBuilder(absoluteFieldPath);
    }

    @Override
    public LuceneSimpleQueryStringPredicateBuilderFieldState createSimpleQueryStringFieldContext(String absoluteFieldPath) {
        this.checkSearchable(absoluteFieldPath);
        return new LuceneSimpleQueryStringPredicateBuilderFieldState(this.analyzerOrNormalizer);
    }

    @Override
    public boolean hasCompatibleAnalyzer(LuceneFieldPredicateBuilderFactory other) {
        if (!(other instanceof LuceneTextFieldPredicateBuilderFactory)) {
            return false;
        }
        LuceneTextFieldPredicateBuilderFactory castedOther = (LuceneTextFieldPredicateBuilderFactory)other;
        return Objects.equals(this.analyzer, castedOther.analyzer) && Objects.equals(this.normalizer, castedOther.normalizer);
    }
}

