/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.types.sort.impl;

import org.apache.lucene.search.FieldComparatorSource;
import org.apache.lucene.search.SortField;
import org.apache.lucene.util.BytesRef;
import org.hibernate.search.backend.lucene.scope.model.impl.LuceneCompatibilityChecker;
import org.hibernate.search.backend.lucene.search.impl.LuceneSearchContext;
import org.hibernate.search.backend.lucene.search.sort.impl.LuceneSearchSortCollector;
import org.hibernate.search.backend.lucene.types.codec.impl.LuceneTextFieldCodec;
import org.hibernate.search.backend.lucene.types.sort.impl.AbstractLuceneStandardFieldSortBuilder;
import org.hibernate.search.backend.lucene.types.sort.impl.SortMissingValue;
import org.hibernate.search.backend.lucene.types.sort.missing.impl.LuceneMissingValueComparatorSource;
import org.hibernate.search.engine.backend.types.converter.ToDocumentFieldValueConverter;
import org.hibernate.search.engine.search.dsl.sort.SortOrder;

public class LuceneTextFieldSortBuilder<F>
extends AbstractLuceneStandardFieldSortBuilder<F, String, LuceneTextFieldCodec<F>> {
    LuceneTextFieldSortBuilder(LuceneSearchContext searchContext, String absoluteFieldPath, ToDocumentFieldValueConverter<?, ? extends F> converter, ToDocumentFieldValueConverter<F, ? extends F> rawConverter, LuceneCompatibilityChecker converterChecker, LuceneTextFieldCodec<F> codec) {
        super(searchContext, absoluteFieldPath, converter, rawConverter, converterChecker, codec, SortField.STRING_FIRST, SortField.STRING_LAST);
    }

    @Override
    protected Object encodeMissingAs(F converted) {
        return ((LuceneTextFieldCodec)this.codec).normalize(this.absoluteFieldPath, (String)((LuceneTextFieldCodec)this.codec).encode(converted));
    }

    @Override
    public void buildAndContribute(LuceneSearchSortCollector collector) {
        collector.collectSortField(this.useMissingValue() ? this.customType() : this.stringType());
    }

    private boolean useMissingValue() {
        return this.missingValue != null && !SortMissingValue.MISSING_FIRST.equals(this.missingValue) && !SortMissingValue.MISSING_LAST.equals(this.missingValue);
    }

    private SortField stringType() {
        SortField sortField = new SortField(this.absoluteFieldPath, SortField.Type.STRING, this.order == SortOrder.DESC);
        this.setEffectiveMissingValue(sortField, this.missingValue, this.order);
        return sortField;
    }

    public SortField customType() {
        return new SortField(this.absoluteFieldPath, (FieldComparatorSource)new LuceneMissingValueComparatorSource((BytesRef)this.missingValue), this.order == SortOrder.DESC);
    }
}

