/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.types.sort.missing.impl;

import java.io.IOException;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.SortedDocValues;
import org.apache.lucene.search.FieldComparator;
import org.apache.lucene.search.FieldComparatorSource;
import org.apache.lucene.util.BytesRef;
import org.hibernate.search.backend.lucene.types.sort.missing.impl.LuceneReplaceMissingSortedDocValues;

public class LuceneMissingValueComparatorSource
extends FieldComparatorSource {
    private final BytesRef missingValue;

    public LuceneMissingValueComparatorSource(BytesRef missingValue) {
        this.missingValue = missingValue;
    }

    public FieldComparator<?> newComparator(String fieldname, int numHits, int sortPos, boolean reversed) {
        return new FieldComparator.TermOrdValComparator(numHits, fieldname, reversed){

            protected SortedDocValues getSortedDocValues(LeafReaderContext context, String field) throws IOException {
                return new LuceneReplaceMissingSortedDocValues(super.getSortedDocValues(context, field), LuceneMissingValueComparatorSource.this.missingValue);
            }
        };
    }
}

