/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.work.execution.impl;

import java.util.concurrent.CompletableFuture;
import org.hibernate.search.backend.lucene.orchestration.impl.LuceneWriteWorkOrchestrator;
import org.hibernate.search.backend.lucene.work.impl.LuceneWorkFactory;
import org.hibernate.search.engine.backend.work.execution.DocumentCommitStrategy;
import org.hibernate.search.engine.backend.work.execution.DocumentRefreshStrategy;
import org.hibernate.search.engine.backend.work.execution.spi.IndexWorkExecutor;
import org.hibernate.search.engine.mapper.session.context.spi.DetachedSessionContextImplementor;

public class LuceneIndexWorkExecutor
implements IndexWorkExecutor {
    private final LuceneWorkFactory factory;
    private final LuceneWriteWorkOrchestrator orchestrator;
    private final String indexName;
    private final DetachedSessionContextImplementor sessionContext;

    public LuceneIndexWorkExecutor(LuceneWorkFactory factory, LuceneWriteWorkOrchestrator orchestrator, String indexName, DetachedSessionContextImplementor sessionContext) {
        this.factory = factory;
        this.orchestrator = orchestrator;
        this.indexName = indexName;
        this.sessionContext = sessionContext;
    }

    public CompletableFuture<?> optimize() {
        return this.orchestrator.submit(this.factory.optimize(this.indexName), DocumentCommitStrategy.FORCE, DocumentRefreshStrategy.NONE);
    }

    public CompletableFuture<?> purge() {
        return this.orchestrator.submit(this.factory.deleteAll(this.indexName, this.sessionContext.getTenantIdentifier()), DocumentCommitStrategy.FORCE, DocumentRefreshStrategy.NONE);
    }

    public CompletableFuture<?> flush() {
        return this.orchestrator.submit(this.factory.flush(this.indexName), DocumentCommitStrategy.FORCE, DocumentRefreshStrategy.NONE);
    }
}

