/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.work.execution.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import org.hibernate.search.backend.lucene.document.impl.LuceneIndexEntry;
import org.hibernate.search.backend.lucene.document.impl.LuceneRootDocumentBuilder;
import org.hibernate.search.backend.lucene.multitenancy.impl.MultiTenancyStrategy;
import org.hibernate.search.backend.lucene.orchestration.impl.LuceneWriteWorkOrchestrator;
import org.hibernate.search.backend.lucene.work.impl.LuceneWorkFactory;
import org.hibernate.search.backend.lucene.work.impl.LuceneWriteWork;
import org.hibernate.search.engine.backend.work.execution.DocumentCommitStrategy;
import org.hibernate.search.engine.backend.work.execution.DocumentRefreshStrategy;
import org.hibernate.search.engine.backend.work.execution.spi.DocumentContributor;
import org.hibernate.search.engine.backend.work.execution.spi.DocumentReferenceProvider;
import org.hibernate.search.engine.backend.work.execution.spi.IndexWorkPlan;
import org.hibernate.search.engine.mapper.session.context.spi.SessionContextImplementor;

public class LuceneIndexWorkPlan
implements IndexWorkPlan<LuceneRootDocumentBuilder> {
    private final LuceneWorkFactory factory;
    private final MultiTenancyStrategy multiTenancyStrategy;
    private final LuceneWriteWorkOrchestrator orchestrator;
    private final String indexName;
    private final String tenantId;
    private final DocumentCommitStrategy commitStrategy;
    private final DocumentRefreshStrategy refreshStrategy;
    private final List<LuceneWriteWork<?>> works = new ArrayList();

    public LuceneIndexWorkPlan(LuceneWorkFactory factory, MultiTenancyStrategy multiTenancyStrategy, LuceneWriteWorkOrchestrator orchestrator, String indexName, SessionContextImplementor sessionContext, DocumentCommitStrategy commitStrategy, DocumentRefreshStrategy refreshStrategy) {
        this.factory = factory;
        this.multiTenancyStrategy = multiTenancyStrategy;
        this.orchestrator = orchestrator;
        this.indexName = indexName;
        this.tenantId = sessionContext.getTenantIdentifier();
        this.commitStrategy = commitStrategy;
        this.refreshStrategy = refreshStrategy;
    }

    public void add(DocumentReferenceProvider referenceProvider, DocumentContributor<LuceneRootDocumentBuilder> documentContributor) {
        String id = referenceProvider.getIdentifier();
        String routingKey = referenceProvider.getRoutingKey();
        LuceneRootDocumentBuilder builder = new LuceneRootDocumentBuilder();
        documentContributor.contribute((Object)builder);
        LuceneIndexEntry indexEntry = builder.build(this.indexName, this.multiTenancyStrategy, this.tenantId, id);
        this.collect(this.factory.add(this.indexName, this.tenantId, id, routingKey, indexEntry));
    }

    public void update(DocumentReferenceProvider referenceProvider, DocumentContributor<LuceneRootDocumentBuilder> documentContributor) {
        String id = referenceProvider.getIdentifier();
        String routingKey = referenceProvider.getRoutingKey();
        LuceneRootDocumentBuilder builder = new LuceneRootDocumentBuilder();
        documentContributor.contribute((Object)builder);
        LuceneIndexEntry indexEntry = builder.build(this.indexName, this.multiTenancyStrategy, this.tenantId, id);
        this.collect(this.factory.update(this.indexName, this.tenantId, id, routingKey, indexEntry));
    }

    public void delete(DocumentReferenceProvider referenceProvider) {
        String id = referenceProvider.getIdentifier();
        String routingKey = referenceProvider.getRoutingKey();
        this.collect(this.factory.delete(this.indexName, this.tenantId, id, routingKey));
    }

    public void prepare() {
    }

    public CompletableFuture<?> execute() {
        try {
            CompletableFuture<?> completableFuture = this.orchestrator.submit(this.works, this.commitStrategy, this.refreshStrategy);
            return completableFuture;
        }
        finally {
            this.works.clear();
        }
    }

    private void collect(LuceneWriteWork<?> work) {
        this.works.add(work);
    }
}

