/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.work.impl;

import java.util.Set;
import org.apache.lucene.search.Explanation;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Sort;
import org.hibernate.search.backend.lucene.document.impl.LuceneIndexEntry;
import org.hibernate.search.backend.lucene.multitenancy.impl.MultiTenancyStrategy;
import org.hibernate.search.backend.lucene.search.extraction.impl.LuceneCollectorProvider;
import org.hibernate.search.backend.lucene.search.query.impl.LuceneLoadableSearchResult;
import org.hibernate.search.backend.lucene.search.query.impl.LuceneSearchResultExtractor;
import org.hibernate.search.backend.lucene.work.impl.LuceneAddEntryWork;
import org.hibernate.search.backend.lucene.work.impl.LuceneExplainWork;
import org.hibernate.search.backend.lucene.work.impl.LuceneFlushWork;
import org.hibernate.search.backend.lucene.work.impl.LuceneOptimizeWork;
import org.hibernate.search.backend.lucene.work.impl.LuceneReadWork;
import org.hibernate.search.backend.lucene.work.impl.LuceneSearchWork;
import org.hibernate.search.backend.lucene.work.impl.LuceneWorkFactory;
import org.hibernate.search.backend.lucene.work.impl.LuceneWriteWork;

public class LuceneWorkFactoryImpl
implements LuceneWorkFactory {
    private final MultiTenancyStrategy multiTenancyStrategy;

    public LuceneWorkFactoryImpl(MultiTenancyStrategy multiTenancyStrategy) {
        this.multiTenancyStrategy = multiTenancyStrategy;
    }

    @Override
    public LuceneWriteWork<?> add(String indexName, String tenantId, String id, String routingKey, LuceneIndexEntry indexEntry) {
        return new LuceneAddEntryWork(indexName, tenantId, id, indexEntry);
    }

    @Override
    public LuceneWriteWork<?> update(String indexName, String tenantId, String id, String routingKey, LuceneIndexEntry indexEntry) {
        return this.multiTenancyStrategy.createUpdateEntryLuceneWork(indexName, tenantId, id, indexEntry);
    }

    @Override
    public LuceneWriteWork<?> delete(String indexName, String tenantId, String id, String routingKey) {
        return this.multiTenancyStrategy.createDeleteEntryLuceneWork(indexName, tenantId, id);
    }

    @Override
    public LuceneWriteWork<?> deleteAll(String indexName, String tenantId) {
        return this.multiTenancyStrategy.createDeleteAllEntriesLuceneWork(indexName, tenantId);
    }

    @Override
    public LuceneWriteWork<?> flush(String indexName) {
        return new LuceneFlushWork(indexName);
    }

    @Override
    public LuceneWriteWork<?> optimize(String indexName) {
        return new LuceneOptimizeWork(indexName);
    }

    @Override
    public <H> LuceneReadWork<LuceneLoadableSearchResult<H>> search(Set<String> indexNames, Query luceneQuery, Sort luceneSort, Integer offset, Integer limit, LuceneCollectorProvider luceneCollectorProvider, LuceneSearchResultExtractor<H> searchResultExtractor) {
        return new LuceneSearchWork<H>(indexNames, luceneQuery, luceneSort, offset, limit, luceneCollectorProvider, searchResultExtractor);
    }

    @Override
    public LuceneReadWork<Explanation> explain(Set<String> indexNames, Query luceneQuery, String explainedDocumentIndexName, String explainedDocumentId, Query explainedDocumentQuery) {
        return new LuceneExplainWork(indexNames, luceneQuery, explainedDocumentIndexName, explainedDocumentId, explainedDocumentQuery);
    }
}

