/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.document.model.dsl.impl;

import java.lang.invoke.MethodHandles;
import java.util.List;
import org.hibernate.search.backend.lucene.document.impl.LuceneIndexFieldReference;
import org.hibernate.search.backend.lucene.document.model.dsl.impl.AbstractLuceneIndexSchemaObjectNodeBuilder;
import org.hibernate.search.backend.lucene.document.model.impl.AbstractLuceneIndexSchemaFieldNode;
import org.hibernate.search.backend.lucene.document.model.impl.LuceneIndexSchemaNodeCollector;
import org.hibernate.search.backend.lucene.document.model.impl.LuceneIndexSchemaNodeContributor;
import org.hibernate.search.backend.lucene.document.model.impl.LuceneIndexSchemaObjectNode;
import org.hibernate.search.backend.lucene.document.model.impl.LuceneIndexSchemaValueFieldNode;
import org.hibernate.search.backend.lucene.logging.impl.Log;
import org.hibernate.search.backend.lucene.types.impl.LuceneIndexValueFieldType;
import org.hibernate.search.engine.backend.common.spi.FieldPaths;
import org.hibernate.search.engine.backend.document.IndexFieldReference;
import org.hibernate.search.engine.backend.document.model.dsl.IndexSchemaFieldOptionsStep;
import org.hibernate.search.engine.backend.document.model.dsl.spi.IndexSchemaBuildContext;
import org.hibernate.search.engine.backend.document.model.spi.IndexFieldInclusion;
import org.hibernate.search.engine.reporting.spi.EventContexts;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;
import org.hibernate.search.util.common.reporting.EventContext;

class LuceneIndexSchemaValueFieldNodeBuilder<F>
implements IndexSchemaFieldOptionsStep<LuceneIndexSchemaValueFieldNodeBuilder<F>, IndexFieldReference<F>>,
LuceneIndexSchemaNodeContributor,
IndexSchemaBuildContext {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    private final AbstractLuceneIndexSchemaObjectNodeBuilder parent;
    private final String relativeFieldName;
    private final String absoluteFieldPath;
    private final IndexFieldInclusion inclusion;
    private final LuceneIndexValueFieldType<F> type;
    private boolean multiValued = false;
    private LuceneIndexFieldReference<F> reference;

    LuceneIndexSchemaValueFieldNodeBuilder(AbstractLuceneIndexSchemaObjectNodeBuilder parent, String relativeFieldName, IndexFieldInclusion inclusion, LuceneIndexValueFieldType<F> type) {
        this.parent = parent;
        this.relativeFieldName = relativeFieldName;
        this.absoluteFieldPath = FieldPaths.compose((String)parent.getAbsolutePath(), (String)relativeFieldName);
        this.inclusion = inclusion;
        this.type = type;
    }

    public EventContext eventContext() {
        return this.parent.getRootNodeBuilder().getIndexEventContext().append(EventContexts.fromIndexFieldAbsolutePath((String)this.absoluteFieldPath));
    }

    public LuceneIndexSchemaValueFieldNodeBuilder<F> multiValued() {
        this.multiValued = true;
        return this;
    }

    public IndexFieldReference<F> toReference() {
        if (this.reference != null) {
            throw log.cannotCreateReferenceMultipleTimes(this.eventContext());
        }
        this.reference = new LuceneIndexFieldReference();
        return this.reference;
    }

    @Override
    public void contribute(LuceneIndexSchemaNodeCollector collector, LuceneIndexSchemaObjectNode parentNode, List<AbstractLuceneIndexSchemaFieldNode> staticChildrenForParent) {
        if (this.reference == null) {
            throw log.incompleteFieldDefinition(this.eventContext());
        }
        LuceneIndexSchemaValueFieldNode<F> fieldNode = new LuceneIndexSchemaValueFieldNode<F>(parentNode, this.relativeFieldName, this.inclusion, this.multiValued, this.type);
        staticChildrenForParent.add(fieldNode);
        collector.collectFieldNode(fieldNode.absolutePath(), fieldNode);
        this.reference.setSchemaNode(fieldNode);
    }
}

