/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.logging.impl;

import java.io.IOException;
import java.io.Serializable;
import java.nio.file.Path;
import java.time.Duration;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import org.apache.lucene.search.Query;
import org.apache.lucene.store.Directory;
import org.apache.lucene.util.Version;
import org.hibernate.search.backend.lucene.document.model.impl.LuceneIndexSchemaObjectFieldNode;
import org.hibernate.search.backend.lucene.document.model.impl.LuceneIndexSchemaValueFieldNode;
import org.hibernate.search.backend.lucene.index.LuceneIndexManager;
import org.hibernate.search.backend.lucene.logging.impl.Log;
import org.hibernate.search.engine.backend.scope.spi.IndexScopeBuilder;
import org.hibernate.search.engine.backend.types.converter.spi.ToDocumentIdentifierValueConverter;
import org.hibernate.search.engine.logging.spi.AggregationKeyFormatter;
import org.hibernate.search.engine.search.aggregation.AggregationKey;
import org.hibernate.search.engine.search.aggregation.SearchAggregation;
import org.hibernate.search.engine.search.predicate.SearchPredicate;
import org.hibernate.search.engine.search.projection.SearchProjection;
import org.hibernate.search.engine.search.sort.SearchSort;
import org.hibernate.search.util.common.SearchException;
import org.hibernate.search.util.common.SearchTimeoutException;
import org.hibernate.search.util.common.logging.impl.ClassFormatter;
import org.hibernate.search.util.common.logging.impl.DurationInSecondsAndFractionsFormatter;
import org.hibernate.search.util.common.logging.impl.EventContextFormatter;
import org.hibernate.search.util.common.reporting.EventContext;
import org.jboss.logging.BasicLogger;
import org.jboss.logging.DelegatingBasicLogger;
import org.jboss.logging.Logger;

public class Log_$logger
extends DelegatingBasicLogger
implements Log,
BasicLogger,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final String FQCN = Log_$logger.class.getName();
    private static final Locale LOCALE = Locale.ROOT;

    public Log_$logger(Logger log) {
        super(log);
    }

    protected Locale getLoggingLocale() {
        return LOCALE;
    }

    @Override
    public final void indexDirectoryNotFoundCreatingNewOne(Path absolutePath) {
        this.log.logf(FQCN, Logger.Level.INFO, null, this.indexDirectoryNotFoundCreatingNewOne$str(), (Object)absolutePath);
    }

    protected String indexDirectoryNotFoundCreatingNewOne$str() {
        return "HSEARCH000041: Index directory not found, creating: '%1$s'";
    }

    @Override
    public final void indexWriterReset(EventContext context) {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.indexWriterReset$str(), (Object)new EventContextFormatter(context));
    }

    protected String indexWriterReset$str() {
        return "HSEARCH000052: Going to reset the index writer and force release of the IndexWriter lock. %1$s";
    }

    @Override
    public final void unableToCloseIndexReader(EventContext context, Exception e) {
        this.log.logf(FQCN, Logger.Level.WARN, (Throwable)e, this.unableToCloseIndexReader$str(), (Object)new EventContextFormatter(context));
    }

    protected String unableToCloseIndexReader$str() {
        return "HSEARCH000055: Unable to close the index reader. %1$s";
    }

    @Override
    public final void recommendConfiguringLuceneVersion(String key, Version latest, EventContext context) {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.recommendConfiguringLuceneVersion$str(), (Object)key, (Object)latest, (Object)new EventContextFormatter(context));
    }

    protected String recommendConfiguringLuceneVersion$str() {
        return "HSEARCH000075: Configuration setting '%1$s' was not specified: using LATEST (currently '%2$s'). %3$s";
    }

    protected String unableToLoadResource$str() {
        return "HSEARCH000114: Could not load resource: '%1$s'";
    }

    @Override
    public final SearchException unableToLoadResource(String fileName) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.unableToLoadResource$str(), fileName));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    private static void _copyStackTraceMinusOne(Throwable e) {
        StackTraceElement[] st = e.getStackTrace();
        e.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
    }

    protected String indexMergeOperation$str() {
        return "HSEARCH000118: Index Merge operation on index '%1$s'";
    }

    @Override
    public final String indexMergeOperation(String indexName) {
        return String.format(this.getLoggingLocale(), this.indexMergeOperation$str(), indexName);
    }

    @Override
    public final void lockingFailureDuringInitialization(String directoryDescription, EventContext context) {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.lockingFailureDuringInitialization$str(), (Object)directoryDescription);
    }

    protected String lockingFailureDuringInitialization$str() {
        return "HSEARCH000225: An index locking error occurred during initialization of Directory '%s'. This might indicate a concurrent initialization; If you experience errors on this index you might need to remove the lock, or rebuild the index.";
    }

    @Override
    public final void logInfoStreamMessage(String componentName, String message) {
        this.log.logf(FQCN, Logger.Level.TRACE, null, this.logInfoStreamMessage$str(), (Object)componentName, (Object)message);
    }

    protected String logInfoStreamMessage$str() {
        return "HSEARCH000226: %s: %s";
    }

    protected String illegalLuceneVersionFormat$str() {
        return "HSEARCH000228: Value '%1$ss' is not in a valid format to express a Lucene version: %2$s";
    }

    @Override
    public final SearchException illegalLuceneVersionFormat(String property, String luceneErrorMessage, Exception e) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.illegalLuceneVersionFormat$str(), property, luceneErrorMessage), (Throwable)e);
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    @Override
    public final void executingLuceneQuery(Query luceneQuery) {
        this.log.logf(FQCN, Logger.Level.DEBUG, null, this.executingLuceneQuery$str(), (Object)luceneQuery);
    }

    protected String executingLuceneQuery$str() {
        return "HSEARCH000274: Executing Lucene query '%s'";
    }

    protected String failureOnMultiReaderRefresh$str() {
        return "HSEARCH000284: An exception occurred while opening multiple indexes.";
    }

    @Override
    public final SearchException failureOnMultiReaderRefresh(EventContext context, Exception e) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.failureOnMultiReaderRefresh$str(), new Object[0]), (Throwable)e, context);
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String unableToApplyAnalysisConfiguration$str() {
        return "HSEARCH000329: Error while applying analysis configuration: %1$s";
    }

    @Override
    public final SearchException unableToApplyAnalysisConfiguration(String errorMessage, Exception e) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.unableToApplyAnalysisConfiguration$str(), errorMessage), (Throwable)e);
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String analyzerDefinitionNamingConflict$str() {
        return "HSEARCH000330: Multiple analyzer definitions with the same name: '%1$s'. The analyzer names must be unique.";
    }

    @Override
    public final SearchException analyzerDefinitionNamingConflict(String analyzerDefinitionName) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.analyzerDefinitionNamingConflict$str(), analyzerDefinitionName));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String analysisComponentParameterConflict$str() {
        return "HSEARCH000337: Multiple parameters with the same name: '%1$s'. Can't assign both value '%2$s' and '%3$s'";
    }

    @Override
    public final SearchException analysisComponentParameterConflict(String name, String value1, String value2) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.analysisComponentParameterConflict$str(), name, value1, value2));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String normalizerDefinitionNamingConflict$str() {
        return "HSEARCH000341: Multiple normalizer definitions with the same name: '%1$s'. The normalizer names must be unique.";
    }

    @Override
    public final SearchException normalizerDefinitionNamingConflict(String normalizerDefinitionName) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.normalizerDefinitionNamingConflict$str(), normalizerDefinitionName));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String cannotApplyAnalyzerAndNormalizer$str() {
        return "HSEARCH000342: Cannot apply both an analyzer and a normalizer. Analyzer: '%1$s', normalizer: '%2$s'.";
    }

    @Override
    public final SearchException cannotApplyAnalyzerAndNormalizer(String analyzerName, String normalizerName, EventContext context) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.cannotApplyAnalyzerAndNormalizer$str(), analyzerName, normalizerName), context);
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    @Override
    public final void normalizerProducedMultipleTokens(String normalizerName, int token) {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.normalizerProducedMultipleTokens$str(), (Object)normalizerName, (Object)token);
    }

    protected String normalizerProducedMultipleTokens$str() {
        return "HSEARCH000344: The normalizer for definition '%s' produced %d tokens. Normalizers should never produce more than one token. The tokens have been concatenated by Hibernate Search, but you should fix your normalizer definition.";
    }

    protected String cannotUseAnalyzerOnSortableField$str() {
        return "HSEARCH000345: Cannot apply an analyzer on a sortable field. Use a normalizer instead. Analyzer: '%1$s'. If an actual analyzer (with tokenization) is necessary, define two separate fields: one with an analyzer that is not sortable, and one with a normalizer that is sortable.";
    }

    @Override
    public final SearchException cannotUseAnalyzerOnSortableField(String analyzerName, EventContext context) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.cannotUseAnalyzerOnSortableField$str(), analyzerName), context);
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String unknownAnalyzer$str() {
        return "HSEARCH000353: Unknown analyzer: '%1$s'. Make sure you defined this analyzer.";
    }

    @Override
    public final SearchException unknownAnalyzer(String analyzerName, EventContext context) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.unknownAnalyzer$str(), analyzerName), context);
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String unknownFieldForSearch$str() {
        return "HSEARCH600000: Unknown field '%1$s'.";
    }

    @Override
    public final SearchException unknownFieldForSearch(String absoluteFieldPath, EventContext context) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.unknownFieldForSearch$str(), absoluteFieldPath), context);
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String pathIsNotWriteableDirectory$str() {
        return "HSEARCH600001: Path '%1$s' exists but does not point to a writable directory.";
    }

    @Override
    public final SearchException pathIsNotWriteableDirectory(Path rootDirectory) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.pathIsNotWriteableDirectory$str(), rootDirectory));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String luceneExtensionOnUnknownType$str() {
        return "HSEARCH600005: The Lucene extension can only be applied to objects derived from the Lucene backend. Was applied to '%1$s' instead.";
    }

    @Override
    public final SearchException luceneExtensionOnUnknownType(Object context) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.luceneExtensionOnUnknownType$str(), context));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String cannotMixLuceneSearchQueryWithOtherPredicates$str() {
        return "HSEARCH600010: A Lucene query cannot include search predicates built using a non-Lucene search scope. Given predicate was: '%1$s'";
    }

    @Override
    public final SearchException cannotMixLuceneSearchQueryWithOtherPredicates(SearchPredicate predicate) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.cannotMixLuceneSearchQueryWithOtherPredicates$str(), predicate));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String nonObjectFieldForNestedQuery$str() {
        return "HSEARCH600012: Field '%1$s' is not an object field.";
    }

    @Override
    public final SearchException nonObjectFieldForNestedQuery(String absoluteFieldPath, EventContext context) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.nonObjectFieldForNestedQuery$str(), absoluteFieldPath), context);
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String nonNestedFieldForNestedQuery$str() {
        return "HSEARCH600013: Object field '%1$s' is flattened: its structure was lost upon indexing and 'nested' features are not available.";
    }

    @Override
    public final SearchException nonNestedFieldForNestedQuery(String absoluteFieldPath, EventContext context) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.nonNestedFieldForNestedQuery$str(), absoluteFieldPath), context);
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String cannotMixLuceneSearchSortWithOtherSorts$str() {
        return "HSEARCH600014: A Lucene query cannot include search sorts built using a non-Lucene search scope. Given sort was: '%1$s'";
    }

    @Override
    public final SearchException cannotMixLuceneSearchSortWithOtherSorts(SearchSort sort) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.cannotMixLuceneSearchSortWithOtherSorts$str(), sort));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String unableToInitializeIndexDirectory$str() {
        return "HSEARCH600015: Unable to initialize index directory: %1$s";
    }

    @Override
    public final SearchException unableToInitializeIndexDirectory(String causeMessage, EventContext context, Exception cause) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.unableToInitializeIndexDirectory$str(), causeMessage), (Throwable)cause, context);
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String unableToIndexEntry$str() {
        return "HSEARCH600016: Unable to index entity of type '%2$s' with identifier '%3$s' and tenant identifier '%1$s'.";
    }

    @Override
    public final SearchException unableToIndexEntry(String tenantId, String entityTypeName, Object entityIdentifier, EventContext context, Exception e) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.unableToIndexEntry$str(), tenantId, entityTypeName, entityIdentifier), (Throwable)e, context);
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String unableToDeleteEntryFromIndex$str() {
        return "HSEARCH600017: Unable to delete entity of type '%2$s' with identifier '%3$s' and tenant identifier '%1$s'.";
    }

    @Override
    public final SearchException unableToDeleteEntryFromIndex(String tenantId, String entityTypeName, Object entityIdentifier, EventContext context, Exception e) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.unableToDeleteEntryFromIndex$str(), tenantId, entityTypeName, entityIdentifier), (Throwable)e, context);
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String unableToCommitIndex$str() {
        return "HSEARCH600019: Unable to commit.";
    }

    @Override
    public final SearchException unableToCommitIndex(EventContext context, Exception e) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.unableToCommitIndex$str(), new Object[0]), (Throwable)e, context);
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String cannotMixLuceneScopeWithOtherType$str() {
        return "HSEARCH600024: A multi-index scope cannot include both a Lucene index and another type of index. Base scope was: '%1$s', Lucene index was: '%2$s'";
    }

    @Override
    public final SearchException cannotMixLuceneScopeWithOtherType(IndexScopeBuilder baseScope, LuceneIndexManager luceneIndex, EventContext context) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.cannotMixLuceneScopeWithOtherType$str(), baseScope, luceneIndex), context);
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String cannotMixLuceneScopeWithOtherBackend$str() {
        return "HSEARCH600025: A multi-index scope cannot span multiple Lucene backends. Base scope was: '%1$s', index from another backend was: '%2$s'";
    }

    @Override
    public final SearchException cannotMixLuceneScopeWithOtherBackend(IndexScopeBuilder baseScope, LuceneIndexManager indexFromOtherBackend, EventContext context) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.cannotMixLuceneScopeWithOtherBackend$str(), baseScope, indexFromOtherBackend), context);
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String ioExceptionOnQueryExecution$str() {
        return "HSEARCH600027: An IOException happened while executing the query '%1$s'.";
    }

    @Override
    public final SearchException ioExceptionOnQueryExecution(Query luceneQuery, EventContext context, IOException e) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.ioExceptionOnQueryExecution$str(), luceneQuery), (Throwable)e, context);
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String multiTenancyRequiredButNotSupportedByBackend$str() {
        return "HSEARCH600029: Index '%1$s' requires multi-tenancy but the backend does not support it in its current configuration.";
    }

    @Override
    public final SearchException multiTenancyRequiredButNotSupportedByBackend(String indexName, EventContext context) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.multiTenancyRequiredButNotSupportedByBackend$str(), indexName), context);
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String invalidMultiTenancyStrategyName$str() {
        return "HSEARCH600030: Invalid multi-tenancy strategy name: '%1$s'. Valid names are: %2$s.";
    }

    @Override
    public final SearchException invalidMultiTenancyStrategyName(String invalidRepresentation, List<String> validRepresentations) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.invalidMultiTenancyStrategyName$str(), invalidRepresentation, validRepresentations));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String tenantIdProvidedButMultiTenancyDisabled$str() {
        return "HSEARCH600031: Tenant identifier '%1$s' is provided, but multi-tenancy is disabled for this backend.";
    }

    @Override
    public final SearchException tenantIdProvidedButMultiTenancyDisabled(String tenantId, EventContext context) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.tenantIdProvidedButMultiTenancyDisabled$str(), tenantId), context);
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String multiTenancyEnabledButNoTenantIdProvided$str() {
        return "HSEARCH600032: Backend has multi-tenancy enabled, but no tenant identifier is provided.";
    }

    @Override
    public final SearchException multiTenancyEnabledButNoTenantIdProvided(EventContext context) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.multiTenancyEnabledButNoTenantIdProvided$str(), new Object[0]), context);
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String backendUnwrappingWithUnknownType$str() {
        return "HSEARCH600033: Attempt to unwrap a Lucene backend to '%1$s', but this backend can only be unwrapped to '%2$s'.";
    }

    @Override
    public final SearchException backendUnwrappingWithUnknownType(Class<?> requestedClass, Class<?> actualClass, EventContext context) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.backendUnwrappingWithUnknownType$str(), new ClassFormatter(requestedClass), new ClassFormatter(actualClass)), context);
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String indexSchemaNodeNameConflict$str() {
        return "HSEARCH600034: The index schema node '%1$s' was added twice. Multiple bridges may be trying to access the same index field,  or two indexed-embeddeds may have prefixes that lead to conflicting field names, or you may have declared multiple conflicting mappings. In any case, there is something wrong with your mapping and you should fix it.";
    }

    @Override
    public final SearchException indexSchemaNodeNameConflict(String relativeFieldName, EventContext context) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.indexSchemaNodeNameConflict$str(), relativeFieldName), context);
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String invalidFieldForDocumentElement$str() {
        return "HSEARCH600039: Invalid field reference for this document element: this document element has path '%1$s', but the referenced field has a parent with path '%2$s'.";
    }

    @Override
    public final SearchException invalidFieldForDocumentElement(String expectedPath, String actualPath) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.invalidFieldForDocumentElement$str(), expectedPath, actualPath));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String minimumShouldMatchMinimumOutOfBounds$str() {
        return "HSEARCH600044: Computed minimum for minimumShouldMatch constraint is out of bounds: expected a number between '1' and '%1$s', got '%2$s'.";
    }

    @Override
    public final SearchException minimumShouldMatchMinimumOutOfBounds(int totalShouldClauseNumber, int minimum) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.minimumShouldMatchMinimumOutOfBounds$str(), totalShouldClauseNumber, minimum));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String minimumShouldMatchConflictingConstraints$str() {
        return "HSEARCH600045: Multiple conflicting minimumShouldMatch constraints for ceiling '%1$s'";
    }

    @Override
    public final SearchException minimumShouldMatchConflictingConstraints(int ignoreConstraintCeiling) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.minimumShouldMatchConflictingConstraints$str(), ignoreConstraintCeiling));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String unsupportedProjectionForNativeField$str() {
        return "HSEARCH600048: This native field does not support projection.";
    }

    @Override
    public final SearchException unsupportedProjectionForNativeField(EventContext context) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.unsupportedProjectionForNativeField$str(), new Object[0]), context);
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String invalidFieldPath$str() {
        return "HSEARCH600049: Invalid field path; expected path '%1$s', got '%2$s'.";
    }

    @Override
    public final SearchException invalidFieldPath(String expectedPath, String actualPath) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.invalidFieldPath$str(), expectedPath, actualPath));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String cannotConvertDslParameter$str() {
        return "HSEARCH600050: Unable to convert DSL parameter: %1$s";
    }

    @Override
    public final SearchException cannotConvertDslParameter(String errorMessage, Exception cause, EventContext context) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.cannotConvertDslParameter$str(), errorMessage), (Throwable)cause, context);
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String indexManagerUnwrappingWithUnknownType$str() {
        return "HSEARCH600051: Attempt to unwrap a Lucene index manager to '%1$s', but this index manager can only be unwrapped to '%2$s'.";
    }

    @Override
    public final SearchException indexManagerUnwrappingWithUnknownType(Class<?> requestedClass, Class<?> actualClass, EventContext context) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.indexManagerUnwrappingWithUnknownType$str(), new ClassFormatter(requestedClass), new ClassFormatter(actualClass)), context);
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String unableToCreateAnalyzer$str() {
        return "HSEARCH600052: Unable to create analyzer for name '%1$s'.";
    }

    @Override
    public final SearchException unableToCreateAnalyzer(String name, Exception e) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.unableToCreateAnalyzer$str(), name), (Throwable)e);
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String unableToCreateNormalizer$str() {
        return "HSEARCH600053: Unable to create normalizer for name '%1$s'.";
    }

    @Override
    public final SearchException unableToCreateNormalizer(String name, Exception e) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.unableToCreateNormalizer$str(), name), (Throwable)e);
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String unknownNormalizer$str() {
        return "HSEARCH600054: Unknown normalizer: '%1$s'. Make sure you defined this normalizer.";
    }

    @Override
    public final SearchException unknownNormalizer(String normalizerName, EventContext context) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.unknownNormalizer$str(), normalizerName), context);
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String cannotMixLuceneSearchQueryWithOtherProjections$str() {
        return "HSEARCH600055: A Lucene query cannot include search projections built using a non-Lucene search scope. Given projection was: '%1$s'";
    }

    @Override
    public final SearchException cannotMixLuceneSearchQueryWithOtherProjections(SearchProjection<?> projection) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.cannotMixLuceneSearchQueryWithOtherProjections$str(), projection));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String inconsistentConfigurationForFieldForSearch$str() {
        return "HSEARCH600058: Inconsistent configuration for field '%1$s' in a search query across multiple indexes: %2$s";
    }

    @Override
    public final SearchException inconsistentConfigurationForFieldForSearch(String absoluteFieldPath, String causeMessage, EventContext context, SearchException cause) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.inconsistentConfigurationForFieldForSearch$str(), absoluteFieldPath, causeMessage), (Throwable)cause, context);
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String failedToShutdownBackend$str() {
        return "HSEARCH600061: Failed to shut down the Lucene index manager.";
    }

    @Override
    public final SearchException failedToShutdownBackend(Exception cause, EventContext context) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.failedToShutdownBackend$str(), new Object[0]), (Throwable)cause, context);
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String cannotGuessFieldType$str() {
        return "HSEARCH600062: Cannot guess field type for input type: '%1$s'.";
    }

    @Override
    public final SearchException cannotGuessFieldType(Class<?> inputType, EventContext context) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.cannotGuessFieldType$str(), new ClassFormatter(inputType)), context);
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String documentIdNotCollected$str() {
        return "HSEARCH600064: Unexpected index: documentId '%1$s' was not collected.";
    }

    @Override
    public final SearchException documentIdNotCollected(Integer documentId) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.documentIdNotCollected$str(), documentId));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String unableToDeleteAllEntriesFromIndex$str() {
        return "HSEARCH600067: Unable to delete all entries matching query '%1$s'.";
    }

    @Override
    public final SearchException unableToDeleteAllEntriesFromIndex(Query query, EventContext context, Exception e) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.unableToDeleteAllEntriesFromIndex$str(), query), (Throwable)e, context);
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String inconsistentConfigurationForIdentifierForSearch$str() {
        return "HSEARCH600068: Inconsistent configuration for the identifier in a search query across multiple indexes: converter differs: '%1$s' vs. '%2$s'.";
    }

    @Override
    public final SearchException inconsistentConfigurationForIdentifierForSearch(ToDocumentIdentifierValueConverter<?> component1, ToDocumentIdentifierValueConverter<?> component2, EventContext context) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.inconsistentConfigurationForIdentifierForSearch$str(), component1, component2), context);
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String ioExceptionOnExplain$str() {
        return "HSEARCH600069: An IOException occurred while generating an Explanation.";
    }

    @Override
    public final SearchException ioExceptionOnExplain(IOException e) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.ioExceptionOnExplain$str(), new Object[0]), (Throwable)e);
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String fullTextFeaturesNotSupportedByFieldType$str() {
        return "HSEARCH600070: Full-text features (analysis, fuzziness) are not supported for fields of this type.";
    }

    @Override
    public final SearchException fullTextFeaturesNotSupportedByFieldType(EventContext context) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.fullTextFeaturesNotSupportedByFieldType$str(), new Object[0]), context);
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String incompleteFieldDefinition$str() {
        return "HSEARCH600071: Incomplete field definition. You must call toReference() to complete the field definition.";
    }

    @Override
    public final SearchException incompleteFieldDefinition(EventContext context) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.incompleteFieldDefinition$str(), new Object[0]), context);
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String cannotCreateReferenceMultipleTimes$str() {
        return "HSEARCH600072: Multiple calls to toReference() for the same field definition. You must call toReference() exactly once.";
    }

    @Override
    public final SearchException cannotCreateReferenceMultipleTimes(EventContext context) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.cannotCreateReferenceMultipleTimes$str(), new Object[0]), context);
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String cannotUseIndexNullAsAndAnalyzer$str() {
        return "HSEARCH600073: Index-null-as option is not supported on analyzed field. Trying to define the analyzer: '%1$s' together with index null as: '%2$s'.";
    }

    @Override
    public final SearchException cannotUseIndexNullAsAndAnalyzer(String analyzerName, String indexNullAs, EventContext context) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.cannotUseIndexNullAsAndAnalyzer$str(), analyzerName, indexNullAs), context);
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String multipleValuesForSingleValuedField$str() {
        return "HSEARCH600074: Multiple values were added to single-valued field '%1$s'. Declare the field as multi-valued in order to allow this.";
    }

    @Override
    public final SearchException multipleValuesForSingleValuedField(String absoluteFieldPath) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.multipleValuesForSingleValuedField$str(), absoluteFieldPath));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String explainRequiresTypeName$str() {
        return "HSEARCH600075: explain(Object id) cannot be used when the query targets multiple types. Use explain(String typeName, Object id) and pass one of %1$s as the type name.";
    }

    @Override
    public final SearchException explainRequiresTypeName(Set<String> targetedTypeNames) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.explainRequiresTypeName$str(), targetedTypeNames));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String explainRequiresTypeTargetedByQuery$str() {
        return "HSEARCH600076: The given mapped type name '%2$s' is not among the mapped types targeted by this query: %1$s.";
    }

    @Override
    public final SearchException explainRequiresTypeTargetedByQuery(Set<String> targetedTypeNames, String typeName) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.explainRequiresTypeTargetedByQuery$str(), targetedTypeNames, typeName));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String explainUnknownDocument$str() {
        return "HSEARCH600077: Document with id '%2$s' does not exist for the mapped type '%1$s' and thus its match cannot be explained.";
    }

    @Override
    public final SearchException explainUnknownDocument(String typeName, String id) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.explainUnknownDocument$str(), typeName, id));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String unableToMergeSegments$str() {
        return "HSEARCH600078: Unable to merge index segments.";
    }

    @Override
    public final SearchException unableToMergeSegments(EventContext context, Exception e) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.unableToMergeSegments$str(), new Object[0]), (Throwable)e, context);
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String unableToCloseIndexWriterAfterFailures$str() {
        return "HSEARCH600079: Unable to close the index writer after write failures.";
    }

    @Override
    public final SearchException unableToCloseIndexWriterAfterFailures(EventContext context, Exception e) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.unableToCloseIndexWriterAfterFailures$str(), new Object[0]), (Throwable)e, context);
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String nullDecimalScale$str() {
        return "HSEARCH600080: Impossible to detect a decimal scale to use for this field. If the value is bridged, set '.asBigDecimal().decimalScale( int )' in the bind, else verify your mapping.";
    }

    @Override
    public final SearchException nullDecimalScale(EventContext eventContext) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.nullDecimalScale$str(), new Object[0]), eventContext);
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String scaledNumberTooLarge$str() {
        return "HSEARCH600081: The value '%1$s' cannot be indexed because its absolute value is too large.";
    }

    @Override
    public final SearchException scaledNumberTooLarge(Number value) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.scaledNumberTooLarge$str(), value));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String invalidDecimalScale$str() {
        return "HSEARCH600082: Positive decimal scale ['%1$s'] is not allowed for BigInteger fields, since a BigInteger value cannot have any decimal digits.";
    }

    @Override
    public final SearchException invalidDecimalScale(Integer decimalScale, EventContext eventContext) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.invalidDecimalScale$str(), decimalScale), eventContext);
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String predicateDefinedOnDifferentIndexes$str() {
        return "HSEARCH600084: The predicate '%1$s' is defined on a scope targeting different indexes. Predicate is targeting: '%2$s'. Current scope is targeting: '%3$s'.";
    }

    @Override
    public final SearchException predicateDefinedOnDifferentIndexes(SearchPredicate predicate, Set<String> predicateIndexes, Set<String> scopeIndexes) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.predicateDefinedOnDifferentIndexes$str(), predicate, predicateIndexes, scopeIndexes));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String sortDefinedOnDifferentIndexes$str() {
        return "HSEARCH600085: The sort '%1$s' is defined on a scope targeting different indexes. Sort is targeting: '%2$s'. Current scope is targeting: '%3$s'.";
    }

    @Override
    public final SearchException sortDefinedOnDifferentIndexes(SearchSort predicate, Set<String> predicateIndexes, Set<String> scopeIndexes) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.sortDefinedOnDifferentIndexes$str(), predicate, predicateIndexes, scopeIndexes));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String projectionDefinedOnDifferentIndexes$str() {
        return "HSEARCH600086: The projection '%1$s' is defined on a scope targeting different indexes. Projection is targeting: '%2$s'. Current scope is targeting: '%3$s'.";
    }

    @Override
    public final SearchException projectionDefinedOnDifferentIndexes(SearchProjection<?> predicate, Set<String> predicateIndexes, Set<String> scopeIndexes) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.projectionDefinedOnDifferentIndexes$str(), predicate, predicateIndexes, scopeIndexes));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String invalidFileSystemAccessStrategyName$str() {
        return "HSEARCH600087: Invalid filesystem access strategy name: '%1$s'. Valid names are: %2$s.";
    }

    @Override
    public final SearchException invalidFileSystemAccessStrategyName(String invalidRepresentation, List<String> validRepresentations) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.invalidFileSystemAccessStrategyName$str(), invalidRepresentation, validRepresentations));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String invalidLockingStrategyName$str() {
        return "HSEARCH600088: Invalid locking strategy name: '%1$s'. Valid names are: %2$s.";
    }

    @Override
    public final SearchException invalidLockingStrategyName(String invalidRepresentation, List<String> validRepresentations) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.invalidLockingStrategyName$str(), invalidRepresentation, validRepresentations));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String missingShardIdentifiersAfterShardingStrategyInitialization$str() {
        return "HSEARCH600089: The sharding strategy '%1$s' is not implemented properly: it must call either context.setShardIdentifiers() or context.setShardingDisabled() in its initialize() method, but it did not.";
    }

    @Override
    public final SearchException missingShardIdentifiersAfterShardingStrategyInitialization(Object strategy) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.missingShardIdentifiersAfterShardingStrategyInitialization$str(), strategy));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String missingPropertyValueForShardingStrategy$str() {
        return "HSEARCH600090: Missing value for property '%2$s'. The sharding strategy '%1$s' requires this property to be set.";
    }

    @Override
    public final SearchException missingPropertyValueForShardingStrategy(String strategyName, String propertyKey) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.missingPropertyValueForShardingStrategy$str(), strategyName, propertyKey));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String invalidRoutingKeyForExplicitShardingStrategy$str() {
        return "HSEARCH600091: Invalid routing key: '%1$s'. Valid keys are: %2$s.";
    }

    @Override
    public final SearchException invalidRoutingKeyForExplicitShardingStrategy(String invalidKey, Collection<String> validKeys) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.invalidRoutingKeyForExplicitShardingStrategy$str(), invalidKey, validKeys));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String cannotUseAnalyzerOnAggregableField$str() {
        return "HSEARCH600094: Cannot apply an analyzer on an aggregable field. Use a normalizer instead. Analyzer: '%1$s'. If an actual analyzer (with tokenization) is necessary, define two separate fields: one with an analyzer that is not aggregable, and one with a normalizer that is aggregable.";
    }

    @Override
    public final SearchException cannotUseAnalyzerOnAggregableField(String analyzerName, EventContext context) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.cannotUseAnalyzerOnAggregableField$str(), analyzerName), context);
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String cannotMixLuceneSearchQueryWithOtherAggregations$str() {
        return "HSEARCH600098: An Lucene query cannot include search aggregations built using a non-Lucene search scope. Given aggregation was: '%1$s'";
    }

    @Override
    public final SearchException cannotMixLuceneSearchQueryWithOtherAggregations(SearchAggregation<?> aggregation) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.cannotMixLuceneSearchQueryWithOtherAggregations$str(), aggregation));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String aggregationDefinedOnDifferentIndexes$str() {
        return "HSEARCH600099: The aggregation '%1$s' is defined on a scope targeting different indexes. Aggregation is targeting: '%2$s'. Current scope is targeting: '%3$s'.";
    }

    @Override
    public final SearchException aggregationDefinedOnDifferentIndexes(SearchAggregation<?> aggregation, Set<String> aggregationIndexes, Set<String> scopeIndexes) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.aggregationDefinedOnDifferentIndexes$str(), aggregation, aggregationIndexes, scopeIndexes));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String duplicateAggregationKey$str() {
        return "HSEARCH600102: Multiple aggregations with the same key: '%1$s'";
    }

    @Override
    public final SearchException duplicateAggregationKey(AggregationKey key) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.duplicateAggregationKey$str(), new AggregationKeyFormatter(key)));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String searchAnalyzerWithoutAnalyzer$str() {
        return "HSEARCH600104: Cannot apply a search analyzer if an analyzer has not been defined on the same field. Search analyzer: '%1$s'.";
    }

    @Override
    public final SearchException searchAnalyzerWithoutAnalyzer(String searchAnalyzer, EventContext context) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.searchAnalyzerWithoutAnalyzer$str(), searchAnalyzer), context);
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String conflictingObjectFieldModel$str() {
        return "HSEARCH600105: Multiple conflicting models for object field '%1$s': '%2$s' vs. '%3$s'.";
    }

    @Override
    public final SearchException conflictingObjectFieldModel(String absoluteFieldPath, LuceneIndexSchemaObjectFieldNode index1Model, LuceneIndexSchemaObjectFieldNode index2Model, EventContext context) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.conflictingObjectFieldModel$str(), absoluteFieldPath, index1Model, index2Model), context);
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String conflictingFieldModel$str() {
        return "HSEARCH600106: Multiple conflicting models for field '%1$s': '%2$s' vs. '%3$s'.";
    }

    @Override
    public final SearchException conflictingFieldModel(String absoluteFieldPath, LuceneIndexSchemaObjectFieldNode objectNode, LuceneIndexSchemaValueFieldNode fieldNode, EventContext context) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.conflictingFieldModel$str(), absoluteFieldPath, objectNode, fieldNode), context);
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String timedOut$str() {
        return "HSEARCH600107: Search query exceeded the timeout of %1$s: '%2$s'.";
    }

    @Override
    public final SearchTimeoutException timedOut(Duration timeout, String queryDescription) {
        SearchTimeoutException result = new SearchTimeoutException(String.format(this.getLoggingLocale(), this.timedOut$str(), new DurationInSecondsAndFractionsFormatter(timeout), queryDescription));
        Log_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String invalidIOStrategyName$str() {
        return "HSEARCH600108: Invalid I/O strategy name: '%1$s'. Valid names are: %2$s.";
    }

    @Override
    public final SearchException invalidIOStrategyName(String invalidRepresentation, List<String> validRepresentations) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.invalidIOStrategyName$str(), invalidRepresentation, validRepresentations));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String missingIndex$str() {
        return "HSEARCH600109: Index does not exist for directory '%1$s'";
    }

    @Override
    public final SearchException missingIndex(Directory directory, EventContext context) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.missingIndex$str(), directory), context);
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String unableToValidateIndexDirectory$str() {
        return "HSEARCH600110: Unable to validate index directory: %1$s";
    }

    @Override
    public final SearchException unableToValidateIndexDirectory(String causeMessage, EventContext context, Exception cause) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.unableToValidateIndexDirectory$str(), causeMessage), (Throwable)cause, context);
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String unableToDropIndexDirectory$str() {
        return "HSEARCH600111: Unable to drop index directory: %1$s";
    }

    @Override
    public final SearchException unableToDropIndexDirectory(String causeMessage, EventContext context, Exception cause) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.unableToDropIndexDirectory$str(), causeMessage), (Throwable)cause, context);
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String conflictingNestedDocumentPathHierarchy$str() {
        return "HSEARCH600112: Multiple index conflicting models on nested document paths targeting '%1$s'. '%2$s' vs. '%3$s'.";
    }

    @Override
    public final SearchException conflictingNestedDocumentPathHierarchy(String absoluteFieldPath, List<String> nestedDocumentPathHierarchy1, List<String> nestedDocumentPathHierarchy2, EventContext context) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.conflictingNestedDocumentPathHierarchy$str(), absoluteFieldPath, nestedDocumentPathHierarchy1, nestedDocumentPathHierarchy2), context);
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String simpleQueryStringSpanningMultipleNestedPaths$str() {
        return "HSEARCH600113: Simple query string targets fields [%1$s, %3$s] spanning multiple nested paths: %2$s, %4$s.";
    }

    @Override
    public final SearchException simpleQueryStringSpanningMultipleNestedPaths(String fieldPath1, String nestedPath1, String fieldPath2, String nestedPath2) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.simpleQueryStringSpanningMultipleNestedPaths$str(), fieldPath1, nestedPath1, fieldPath2, nestedPath2));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String cannotComputeMedianAcrossNested$str() {
        return "HSEARCH600114: Cannot compute the median across nested documents.";
    }

    @Override
    public final SearchException cannotComputeMedianAcrossNested(EventContext context) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.cannotComputeMedianAcrossNested$str(), new Object[0]), context);
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String cannotComputeSumOrAvgOrMedianForStringField$str() {
        return "HSEARCH600115: Cannot compute the sum, average or median of a text field. Only min and max are supported.";
    }

    @Override
    public final SearchException cannotComputeSumOrAvgOrMedianForStringField(EventContext context) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.cannotComputeSumOrAvgOrMedianForStringField$str(), new Object[0]), context);
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String cannotComputeSumForTemporalField$str() {
        return "HSEARCH600116: Cannot compute the sum of a temporal field. Only min, max, avg and median are supported.";
    }

    @Override
    public final SearchException cannotComputeSumForTemporalField(EventContext context) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.cannotComputeSumForTemporalField$str(), new Object[0]), context);
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String cannotComputeSumForDistanceSort$str() {
        return "HSEARCH600117: Cannot compute the sum for a distance sort. Only min, max, avg and median are supported.";
    }

    @Override
    public final SearchException cannotComputeSumForDistanceSort(EventContext context) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.cannotComputeSumForDistanceSort$str(), new Object[0]), context);
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String uncommittedOperationsBecauseOfFailure$str() {
        return "HSEARCH600118: A failure occurred during a low-level write operation and the index writer had to be reset. Some write operations may have been lost as a result. Failure: %1$s";
    }

    @Override
    public final SearchException uncommittedOperationsBecauseOfFailure(String causeMessage, EventContext context, Throwable cause) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.uncommittedOperationsBecauseOfFailure$str(), causeMessage), cause, context);
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String cannotFilterSortOnRootDocumentField$str() {
        return "HSEARCH600120: Field '%1$s' is not contained in a nested object. Sort filters are only available if the field to sort on is contained in a nested object.";
    }

    @Override
    public final SearchException cannotFilterSortOnRootDocumentField(String absoluteFieldPath, EventContext context) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.cannotFilterSortOnRootDocumentField$str(), absoluteFieldPath), context);
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String invalidNestedObjectPathForPredicate$str() {
        return "HSEARCH600121: Predicate targets unexpected fields %2$s. Only fields that are contained in the nested object with path '%1$s' are allowed here.";
    }

    @Override
    public final SearchException invalidNestedObjectPathForPredicate(String nestedObjectPath, List<String> fieldPaths) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.invalidNestedObjectPathForPredicate$str(), nestedObjectPath, fieldPaths));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String cannotFilterAggregationOnRootDocumentField$str() {
        return "HSEARCH600122: Field '%1$s' is not contained in a nested object. Aggregation filters are only available if the field to aggregate on is contained in a nested object.";
    }

    @Override
    public final SearchException cannotFilterAggregationOnRootDocumentField(String absoluteFieldPath, EventContext context) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.cannotFilterAggregationOnRootDocumentField$str(), absoluteFieldPath), context);
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String illegalIndexWriterSetting$str() {
        return "HSEARCH600123: IndexWriter setting '%1$s' cannot be set to '%2$s': %3$s";
    }

    @Override
    public final SearchException illegalIndexWriterSetting(String settingName, Object settingValue, String message, Exception e) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.illegalIndexWriterSetting$str(), settingName, settingValue, message), (Throwable)e);
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String illegalMergePolicySetting$str() {
        return "HSEARCH600124: Merge policy setting '%1$s' cannot be set to '%2$s': %3$s";
    }

    @Override
    public final SearchException illegalMergePolicySetting(String settingName, Object settingValue, String message, Exception e) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.illegalMergePolicySetting$str(), settingName, settingValue, message), (Throwable)e);
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String indexSchemaFieldTemplateNameConflict$str() {
        return "HSEARCH600125: The index field template '%1$s' was added twice. Multiple bridges may be trying to access the same index field template,  or two indexed-embeddeds may have prefixes that lead to conflicting field names, or you may have declared multiple conflicting mappings. In any case, there is something wrong with your mapping and you should fix it.";
    }

    @Override
    public final SearchException indexSchemaFieldTemplateNameConflict(String name, EventContext context) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.indexSchemaFieldTemplateNameConflict$str(), name), context);
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String invalidFieldValueType$str() {
        return "HSEARCH600126: Invalid value type. This field's values are of type '%1$s', which is not assignable from '%2$s'.";
    }

    @Override
    public final SearchException invalidFieldValueType(Class<?> fieldValueType, Class<?> invalidValueType, EventContext context) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.invalidFieldValueType$str(), new ClassFormatter(fieldValueType), new ClassFormatter(invalidValueType)), context);
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String unknownFieldForIndexing$str() {
        return "HSEARCH600127: Unknown field '%1$s'.";
    }

    @Override
    public final SearchException unknownFieldForIndexing(String absoluteFieldPath, EventContext context) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.unknownFieldForIndexing$str(), absoluteFieldPath), context);
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String invalidIndexElementTypeRootIsNotObjectField$str() {
        return "HSEARCH600128: Invalid type: the index root is not an object field.";
    }

    @Override
    public final SearchException invalidIndexElementTypeRootIsNotObjectField() {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.invalidIndexElementTypeRootIsNotObjectField$str(), new Object[0]));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String invalidIndexElementTypeValueFieldIsNotObjectField$str() {
        return "HSEARCH600129: Invalid type: '%1$s' is a value field, not an object field.";
    }

    @Override
    public final SearchException invalidIndexElementTypeValueFieldIsNotObjectField(String absolutePath) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.invalidIndexElementTypeValueFieldIsNotObjectField$str(), absolutePath));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String invalidIndexElementTypeObjectFieldIsNotValueField$str() {
        return "HSEARCH600130: Invalid type: '%1$s' is an object field, not a value field.";
    }

    @Override
    public final SearchException invalidIndexElementTypeObjectFieldIsNotValueField(String absolutePath) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.invalidIndexElementTypeObjectFieldIsNotValueField$str(), absolutePath));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String invalidSingleValuedProjectionOnMultiValuedField$str() {
        return "HSEARCH600131: Projection on field '%1$s' cannot be single-valued, because this field is multi-valued. Make sure to call '.multi()' when you create the projection.";
    }

    @Override
    public final SearchException invalidSingleValuedProjectionOnMultiValuedField(String absolutePath, EventContext context) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.invalidSingleValuedProjectionOnMultiValuedField$str(), absolutePath), context);
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String cannotUseQueryElementForField$str() {
        return "HSEARCH600132: Cannot use '%2$s' on field '%1$s'. Make sure the field is marked as searchable/sortable/projectable/aggregable (whichever is relevant). If it already is, then '%2$s' is not available for fields of this type.";
    }

    @Override
    public final SearchException cannotUseQueryElementForField(String absoluteFieldPath, String queryElementName, EventContext context) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.cannotUseQueryElementForField$str(), absoluteFieldPath, queryElementName), context);
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String inconsistentSupportForQueryElement$str() {
        return "HSEARCH600133: Inconsistent support for '%1$s': %2$s";
    }

    @Override
    public final SearchException inconsistentSupportForQueryElement(String queryElementName, String causeMessage, SearchException cause) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.inconsistentSupportForQueryElement$str(), queryElementName, causeMessage), (Throwable)cause);
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String differentFieldAttribute$str() {
        return "HSEARCH600134: Field attribute '%1$s' differs: '%2$s' vs. '%3$s'.";
    }

    @Override
    public final SearchException differentFieldAttribute(String attributeName, Object component1, Object component2) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.differentFieldAttribute$str(), attributeName, component1, component2));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String differentImplementationClassForQueryElement$str() {
        return "HSEARCH600135: Implementation class differs: '%1$s' vs. '%2$s'.";
    }

    @Override
    public final SearchException differentImplementationClassForQueryElement(Class<?> class1, Class<?> class2) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.differentImplementationClassForQueryElement$str(), new ClassFormatter(class1), new ClassFormatter(class2)));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String differentFieldCodecForQueryElement$str() {
        return "HSEARCH600136: Field codec differs: '%1$s' vs. '%2$s'.";
    }

    @Override
    public final SearchException differentFieldCodecForQueryElement(Object codec1, Object codec2) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.differentFieldCodecForQueryElement$str(), codec1, codec2));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String partialSupportForQueryElement$str() {
        return "HSEARCH600137: '%1$s' can be used in some of the targeted indexes, but not all of them. Make sure the field is marked as searchable/sortable/projectable/aggregable (whichever is relevant) in all indexes, and that the field has the same type in all indexes.";
    }

    @Override
    public final SearchException partialSupportForQueryElement(String queryElementName) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.partialSupportForQueryElement$str(), queryElementName));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    @Override
    public final void deprecatedFileSystemAccessStrategy(String accessStrategyName, EventContext eventContext) {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.deprecatedFileSystemAccessStrategy$str(), (Object)accessStrategyName, (Object)new EventContextFormatter(eventContext));
    }

    protected String deprecatedFileSystemAccessStrategy$str() {
        return "HSEARCH600138: Using deprecated filesystem access strategy '%1$s', which will be removed in a future version of Lucene. %2$s";
    }
}

