/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.scope.model.impl;

import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.hibernate.search.backend.lucene.document.model.impl.AbstractLuceneIndexSchemaFieldNode;
import org.hibernate.search.backend.lucene.document.model.impl.LuceneIndexModel;
import org.hibernate.search.backend.lucene.document.model.impl.LuceneIndexSchemaObjectFieldNode;
import org.hibernate.search.backend.lucene.document.model.impl.LuceneIndexSchemaValueFieldNode;
import org.hibernate.search.backend.lucene.logging.impl.Log;
import org.hibernate.search.backend.lucene.scope.model.impl.LuceneScopeIndexManagerContext;
import org.hibernate.search.backend.lucene.search.impl.LuceneMultiIndexSearchValueFieldContext;
import org.hibernate.search.backend.lucene.search.impl.LuceneSearchIndexContext;
import org.hibernate.search.backend.lucene.search.impl.LuceneSearchIndexesContext;
import org.hibernate.search.backend.lucene.search.impl.LuceneSearchValueFieldContext;
import org.hibernate.search.backend.lucene.types.predicate.impl.LuceneObjectPredicateBuilderFactory;
import org.hibernate.search.backend.lucene.types.predicate.impl.LuceneObjectPredicateBuilderFactoryImpl;
import org.hibernate.search.engine.backend.document.model.spi.IndexFieldFilter;
import org.hibernate.search.engine.backend.types.ObjectStructure;
import org.hibernate.search.engine.backend.types.converter.spi.StringToDocumentIdentifierValueConverter;
import org.hibernate.search.engine.backend.types.converter.spi.ToDocumentIdentifierValueConverter;
import org.hibernate.search.engine.reporting.spi.EventContexts;
import org.hibernate.search.engine.search.common.ValueConvert;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;
import org.hibernate.search.util.common.reporting.EventContext;

public class LuceneScopeSearchIndexesContext
implements LuceneSearchIndexesContext {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    private static final StringToDocumentIdentifierValueConverter RAW_ID_CONVERTER = new StringToDocumentIdentifierValueConverter();
    private final Map<String, LuceneScopeIndexManagerContext> mappedTypeNameToIndex = new LinkedHashMap<String, LuceneScopeIndexManagerContext>();
    private final Set<String> indexNames = new LinkedHashSet<String>();

    public LuceneScopeSearchIndexesContext(Set<? extends LuceneScopeIndexManagerContext> indexManagerContexts) {
        for (LuceneScopeIndexManagerContext luceneScopeIndexManagerContext : indexManagerContexts) {
            this.mappedTypeNameToIndex.put(luceneScopeIndexManagerContext.model().mappedTypeName(), luceneScopeIndexManagerContext);
            this.indexNames.add(luceneScopeIndexManagerContext.model().hibernateSearchName());
        }
    }

    public Collection<LuceneScopeIndexManagerContext> elements() {
        return this.mappedTypeNameToIndex.values();
    }

    @Override
    public Map<String, ? extends LuceneSearchIndexContext> mappedTypeNameToIndex() {
        return this.mappedTypeNameToIndex;
    }

    @Override
    public Set<String> indexNames() {
        return this.indexNames;
    }

    @Override
    public ToDocumentIdentifierValueConverter<?> idDslConverter(ValueConvert valueConvert) {
        if (ValueConvert.NO.equals((Object)valueConvert)) {
            return RAW_ID_CONVERTER;
        }
        ToDocumentIdentifierValueConverter<?> converter = null;
        for (LuceneScopeIndexManagerContext index : this.elements()) {
            ToDocumentIdentifierValueConverter<?> converterForIndex = index.model().idDslConverter();
            if (converter == null) {
                converter = converterForIndex;
                continue;
            }
            if (converter.isCompatibleWith(converterForIndex)) continue;
            throw log.inconsistentConfigurationForIdentifierForSearch(converter, converterForIndex, this.indexesEventContext());
        }
        return converter;
    }

    @Override
    public LuceneObjectPredicateBuilderFactory objectPredicateBuilderFactory(String absoluteFieldPath) {
        LuceneObjectPredicateBuilderFactoryImpl result = null;
        LuceneIndexSchemaObjectFieldNode objectNode = null;
        String objectNodeIndexName = null;
        LuceneIndexSchemaValueFieldNode<?> fieldNode = null;
        String fieldNodeIndexName = null;
        for (LuceneScopeIndexManagerContext index : this.elements()) {
            LuceneIndexModel indexModel = index.model();
            String indexName = indexModel.hibernateSearchName();
            LuceneIndexSchemaValueFieldNode<?> currentFieldNode = indexModel.getFieldNode(absoluteFieldPath, IndexFieldFilter.INCLUDED_ONLY);
            if (currentFieldNode != null) {
                fieldNode = currentFieldNode;
                fieldNodeIndexName = indexName;
                if (objectNode == null) continue;
                throw log.conflictingFieldModel(absoluteFieldPath, objectNode, fieldNode, EventContexts.fromIndexNames((String[])new String[]{objectNodeIndexName, indexName}));
            }
            LuceneIndexSchemaObjectFieldNode currentObjectNode = indexModel.getObjectFieldNode(absoluteFieldPath, IndexFieldFilter.INCLUDED_ONLY);
            if (currentObjectNode == null) continue;
            if (fieldNode != null) {
                throw log.conflictingFieldModel(absoluteFieldPath, currentObjectNode, fieldNode, EventContexts.fromIndexNames((String[])new String[]{fieldNodeIndexName, indexName}));
            }
            LuceneObjectPredicateBuilderFactoryImpl predicateBuilderFactory = new LuceneObjectPredicateBuilderFactoryImpl(currentObjectNode);
            if (result == null) {
                result = predicateBuilderFactory;
                objectNode = currentObjectNode;
                objectNodeIndexName = indexName;
                continue;
            }
            if (result.isCompatibleWith(predicateBuilderFactory)) continue;
            throw log.conflictingObjectFieldModel(absoluteFieldPath, objectNode, currentObjectNode, EventContexts.fromIndexNames((String[])new String[]{objectNodeIndexName, indexName}));
        }
        return result;
    }

    @Override
    public LuceneSearchValueFieldContext<?> field(String absoluteFieldPath) {
        LuceneSearchValueFieldContext<Object> resultOrNull = null;
        if (this.elements().size() == 1) {
            resultOrNull = this.elements().iterator().next().model().getFieldNode(absoluteFieldPath, IndexFieldFilter.INCLUDED_ONLY);
        } else {
            ArrayList fieldForEachIndex = new ArrayList();
            for (LuceneScopeIndexManagerContext index : this.elements()) {
                LuceneIndexModel indexModel = index.model();
                LuceneIndexSchemaValueFieldNode<?> fieldForCurrentIndex = indexModel.getFieldNode(absoluteFieldPath, IndexFieldFilter.INCLUDED_ONLY);
                if (fieldForCurrentIndex == null) continue;
                fieldForEachIndex.add(fieldForCurrentIndex);
            }
            if (!fieldForEachIndex.isEmpty()) {
                resultOrNull = new LuceneMultiIndexSearchValueFieldContext(this.indexNames, absoluteFieldPath, fieldForEachIndex);
            }
        }
        if (resultOrNull == null) {
            throw log.unknownFieldForSearch(absoluteFieldPath, this.indexesEventContext());
        }
        return resultOrNull;
    }

    @Override
    public void checkNestedField(String absoluteFieldPath) {
        AbstractLuceneIndexSchemaFieldNode schemaNode;
        LuceneIndexModel indexModel;
        boolean found = false;
        for (LuceneScopeIndexManagerContext index : this.elements()) {
            indexModel = index.model();
            schemaNode = indexModel.getObjectFieldNode(absoluteFieldPath, IndexFieldFilter.INCLUDED_ONLY);
            if (schemaNode == null) continue;
            found = true;
            if (ObjectStructure.NESTED.equals((Object)schemaNode.structure())) continue;
            throw log.nonNestedFieldForNestedQuery(absoluteFieldPath, indexModel.getEventContext());
        }
        if (!found) {
            for (LuceneScopeIndexManagerContext index : this.elements()) {
                indexModel = index.model();
                schemaNode = indexModel.getFieldNode(absoluteFieldPath, IndexFieldFilter.INCLUDED_ONLY);
                if (schemaNode == null) continue;
                throw log.nonObjectFieldForNestedQuery(absoluteFieldPath, indexModel.getEventContext());
            }
            throw log.unknownFieldForSearch(absoluteFieldPath, this.indexesEventContext());
        }
    }

    @Override
    public List<String> nestedPathHierarchyForObject(String absoluteFieldPath) {
        Optional nestedDocumentPath = this.elements().stream().map(index -> index.model().getObjectFieldNode(absoluteFieldPath, IndexFieldFilter.INCLUDED_ONLY)).filter(Objects::nonNull).map(node -> Optional.ofNullable(node.nestedPathHierarchy())).reduce((nestedDocumentPath1, nestedDocumentPath2) -> {
            if (Objects.equals(nestedDocumentPath1, nestedDocumentPath2)) {
                return nestedDocumentPath1;
            }
            throw log.conflictingNestedDocumentPathHierarchy(absoluteFieldPath, nestedDocumentPath1.orElse(null), nestedDocumentPath2.orElse(null), this.indexesEventContext());
        }).orElse(Optional.empty());
        return nestedDocumentPath.orElse(Collections.emptyList());
    }

    private EventContext indexesEventContext() {
        return EventContexts.fromIndexNames(this.indexNames);
    }
}

