/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.search.impl;

import java.lang.invoke.MethodHandles;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiPredicate;
import java.util.function.Function;
import org.apache.lucene.analysis.Analyzer;
import org.hibernate.search.backend.lucene.logging.impl.Log;
import org.hibernate.search.backend.lucene.search.impl.LuceneSearchContext;
import org.hibernate.search.backend.lucene.search.impl.LuceneSearchFieldQueryElementFactory;
import org.hibernate.search.backend.lucene.search.impl.LuceneSearchValueFieldContext;
import org.hibernate.search.backend.lucene.search.impl.LuceneSearchValueFieldTypeContext;
import org.hibernate.search.backend.lucene.search.impl.SearchQueryElementTypeKey;
import org.hibernate.search.engine.backend.types.converter.spi.DslConverter;
import org.hibernate.search.engine.backend.types.converter.spi.ProjectionConverter;
import org.hibernate.search.engine.reporting.spi.EventContexts;
import org.hibernate.search.util.common.SearchException;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;
import org.hibernate.search.util.common.reporting.EventContext;

public class LuceneMultiIndexSearchValueFieldContext<F>
implements LuceneSearchValueFieldContext<F>,
LuceneSearchValueFieldTypeContext<F> {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    private final Set<String> indexNames;
    private final String absolutePath;
    private final List<LuceneSearchValueFieldContext<F>> fieldForEachIndex;

    public LuceneMultiIndexSearchValueFieldContext(Set<String> indexNames, String absolutePath, List<LuceneSearchValueFieldContext<F>> fieldForEachIndex) {
        this.indexNames = indexNames;
        this.absolutePath = absolutePath;
        this.fieldForEachIndex = fieldForEachIndex;
    }

    @Override
    public String absolutePath() {
        return this.absolutePath;
    }

    @Override
    public String nestedDocumentPath() {
        return this.getFromFieldIfCompatible(LuceneSearchValueFieldContext::nestedDocumentPath, Object::equals, "nestedDocumentPath");
    }

    @Override
    public List<String> nestedPathHierarchy() {
        return this.getFromFieldIfCompatible(LuceneSearchValueFieldContext::nestedPathHierarchy, Object::equals, "nestedPathHierarchy");
    }

    @Override
    public boolean multiValuedInRoot() {
        for (LuceneSearchValueFieldContext<F> field : this.fieldForEachIndex) {
            if (!field.multiValuedInRoot()) continue;
            return true;
        }
        return false;
    }

    @Override
    public LuceneSearchValueFieldTypeContext<F> type() {
        return this;
    }

    public EventContext eventContext() {
        return this.indexesEventContext().append(EventContexts.fromIndexFieldAbsolutePath((String)this.absolutePath));
    }

    private EventContext indexesEventContext() {
        return EventContexts.fromIndexNames(this.indexNames);
    }

    @Override
    public <T> T queryElement(SearchQueryElementTypeKey<T> key, LuceneSearchContext searchContext) {
        LuceneSearchFieldQueryElementFactory<T, F> factory = this.type().queryElementFactory(key);
        if (factory == null) {
            throw log.cannotUseQueryElementForField(this.absolutePath(), key.toString(), this.eventContext());
        }
        return factory.create(searchContext, this);
    }

    @Override
    public DslConverter<?, F> dslConverter() {
        return this.getFromTypeIfCompatible(LuceneSearchValueFieldTypeContext::dslConverter, DslConverter::isCompatibleWith, "dslConverter");
    }

    @Override
    public DslConverter<F, F> rawDslConverter() {
        return this.getFromTypeIfCompatible(LuceneSearchValueFieldTypeContext::rawDslConverter, DslConverter::isCompatibleWith, "rawDslConverter");
    }

    @Override
    public ProjectionConverter<F, ?> projectionConverter() {
        return this.getFromTypeIfCompatible(LuceneSearchValueFieldTypeContext::projectionConverter, ProjectionConverter::isCompatibleWith, "projectionConverter");
    }

    @Override
    public ProjectionConverter<F, F> rawProjectionConverter() {
        return this.getFromTypeIfCompatible(LuceneSearchValueFieldTypeContext::rawProjectionConverter, ProjectionConverter::isCompatibleWith, "rawProjectionConverter");
    }

    @Override
    public Optional<String> searchAnalyzerName() {
        return this.getFromTypeIfCompatible(LuceneSearchValueFieldTypeContext::searchAnalyzerName, Object::equals, "searchAnalyzer");
    }

    @Override
    public Analyzer searchAnalyzerOrNormalizer() {
        return this.getFromTypeIfCompatible(LuceneSearchValueFieldTypeContext::searchAnalyzerOrNormalizer, Object::equals, "searchAnalyzerOrNormalizer");
    }

    @Override
    public <T> LuceneSearchFieldQueryElementFactory<T, F> queryElementFactory(SearchQueryElementTypeKey<T> key) {
        LuceneSearchFieldQueryElementFactory<T, F> factory = null;
        for (LuceneSearchValueFieldContext<F> fieldContext : this.fieldForEachIndex) {
            LuceneSearchValueFieldTypeContext<F> fieldType = fieldContext.type();
            LuceneSearchFieldQueryElementFactory<T, F> factoryForFieldContext = fieldType.queryElementFactory(key);
            if (factory == null) {
                factory = factoryForFieldContext;
                continue;
            }
            this.checkFactoryCompatibility(key, factory, factoryForFieldContext);
        }
        return factory;
    }

    private <T> T getFromFieldIfCompatible(Function<LuceneSearchValueFieldContext<F>, T> getter, BiPredicate<T, T> compatiblityChecker, String attributeName) {
        T attribute = null;
        for (LuceneSearchValueFieldContext<F> fieldContext : this.fieldForEachIndex) {
            T attributeForFieldContext = getter.apply(fieldContext);
            if (attribute == null) {
                attribute = attributeForFieldContext;
                continue;
            }
            this.checkAttributeCompatibility(compatiblityChecker, attributeName, attribute, attributeForFieldContext);
        }
        return attribute;
    }

    private <T> T getFromTypeIfCompatible(Function<LuceneSearchValueFieldTypeContext<F>, T> getter, BiPredicate<T, T> compatiblityChecker, String attributeName) {
        T attribute = null;
        for (LuceneSearchValueFieldContext<F> fieldContext : this.fieldForEachIndex) {
            LuceneSearchValueFieldTypeContext<F> fieldType = fieldContext.type();
            T attributeForFieldContext = getter.apply(fieldType);
            if (attribute == null) {
                attribute = attributeForFieldContext;
                continue;
            }
            this.checkAttributeCompatibility(compatiblityChecker, attributeName, attribute, attributeForFieldContext);
        }
        return attribute;
    }

    private <T> void checkFactoryCompatibility(SearchQueryElementTypeKey<T> key, LuceneSearchFieldQueryElementFactory<T, F> factory1, LuceneSearchFieldQueryElementFactory<T, F> factory2) {
        if (factory1 == null && factory2 == null) {
            return;
        }
        try {
            try {
                if (factory1 == null || factory2 == null) {
                    throw log.partialSupportForQueryElement(key.toString());
                }
                factory1.checkCompatibleWith(factory2);
            }
            catch (SearchException e) {
                throw log.inconsistentSupportForQueryElement(key.toString(), e.getMessage(), e);
            }
        }
        catch (SearchException e) {
            throw log.inconsistentConfigurationForFieldForSearch(this.absolutePath, e.getMessage(), this.indexesEventContext(), e);
        }
    }

    private <T> void checkAttributeCompatibility(BiPredicate<T, T> compatiblityChecker, String attributeName, T attribute1, T attribute2) {
        try {
            if (!compatiblityChecker.test(attribute1, attribute2)) {
                throw log.differentFieldAttribute(attributeName, attribute1, attribute2);
            }
        }
        catch (SearchException e) {
            throw log.inconsistentConfigurationForFieldForSearch(this.absolutePath, e.getMessage(), this.indexesEventContext(), e);
        }
    }
}

