/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.search.query.impl;

import java.time.Duration;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.lucene.search.TopDocs;
import org.hibernate.search.backend.lucene.search.projection.impl.LuceneSearchProjection;
import org.hibernate.search.backend.lucene.search.projection.impl.SearchProjectionTransformContext;
import org.hibernate.search.backend.lucene.search.query.LuceneSearchResult;
import org.hibernate.search.backend.lucene.search.query.impl.LuceneSearchResultImpl;
import org.hibernate.search.backend.lucene.search.timeout.impl.LuceneTimeoutManager;
import org.hibernate.search.engine.backend.types.converter.runtime.FromDocumentFieldValueConvertContext;
import org.hibernate.search.engine.search.aggregation.AggregationKey;
import org.hibernate.search.engine.search.loading.spi.LoadingResult;
import org.hibernate.search.engine.search.loading.spi.ProjectionHitMapper;
import org.hibernate.search.engine.search.query.SearchResultTotal;
import org.hibernate.search.engine.search.timeout.spi.TimeoutManager;

public class LuceneLoadableSearchResult<H> {
    private final FromDocumentFieldValueConvertContext convertContext;
    private final LuceneSearchProjection<?, H> rootProjection;
    private final SearchResultTotal resultTotal;
    private final TopDocs topDocs;
    private List<Object> extractedData;
    private final Map<AggregationKey<?>, ?> extractedAggregations;
    private final ProjectionHitMapper<?, ?> projectionHitMapper;
    private final Duration took;
    private final Boolean timedOut;
    private final LuceneTimeoutManager timeoutManager;

    LuceneLoadableSearchResult(FromDocumentFieldValueConvertContext convertContext, LuceneSearchProjection<?, H> rootProjection, SearchResultTotal resultTotal, TopDocs topDocs, List<Object> extractedData, Map<AggregationKey<?>, ?> extractedAggregations, ProjectionHitMapper<?, ?> projectionHitMapper, Duration took, boolean timedOut, LuceneTimeoutManager timeoutManager) {
        this.convertContext = convertContext;
        this.rootProjection = rootProjection;
        this.resultTotal = resultTotal;
        this.topDocs = topDocs;
        this.extractedData = extractedData;
        this.extractedAggregations = extractedAggregations;
        this.projectionHitMapper = projectionHitMapper;
        this.took = took;
        this.timedOut = timedOut;
        this.timeoutManager = timeoutManager;
    }

    LuceneSearchResult<H> loadBlocking() {
        int readIndex;
        SearchProjectionTransformContext transformContext = new SearchProjectionTransformContext(this.convertContext);
        LoadingResult loadingResult = this.projectionHitMapper.loadBlocking((TimeoutManager)this.timeoutManager);
        int writeIndex = 0;
        for (readIndex = 0; readIndex < this.extractedData.size(); ++readIndex) {
            transformContext.reset();
            H transformed = LuceneSearchProjection.transformUnsafe(this.rootProjection, loadingResult, this.extractedData.get(readIndex), transformContext);
            if (transformContext.hasFailedLoad()) continue;
            this.extractedData.set(writeIndex, transformed);
            ++writeIndex;
        }
        if (writeIndex < readIndex) {
            this.extractedData.subList(writeIndex, readIndex).clear();
        }
        List<Object> loadedHits = Collections.unmodifiableList(this.extractedData);
        this.extractedData = null;
        return new LuceneSearchResultImpl<Object>(this.resultTotal, loadedHits, this.extractedAggregations, this.took, this.timedOut, this.topDocs);
    }
}

