/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.search.sort.impl;

import org.apache.lucene.search.Sort;
import org.apache.lucene.search.SortField;
import org.hibernate.search.backend.lucene.search.impl.LuceneSearchContext;
import org.hibernate.search.backend.lucene.search.impl.LuceneSearchIndexesContext;
import org.hibernate.search.backend.lucene.search.sort.impl.LuceneCompositeSort;
import org.hibernate.search.backend.lucene.search.sort.impl.LuceneIndexOrderSort;
import org.hibernate.search.backend.lucene.search.sort.impl.LuceneScoreSort;
import org.hibernate.search.backend.lucene.search.sort.impl.LuceneSearchSort;
import org.hibernate.search.backend.lucene.search.sort.impl.LuceneSearchSortBuilderFactory;
import org.hibernate.search.backend.lucene.search.sort.impl.LuceneSearchSortCollector;
import org.hibernate.search.backend.lucene.search.sort.impl.LuceneUserProvidedLuceneSortFieldSort;
import org.hibernate.search.backend.lucene.search.sort.impl.LuceneUserProvidedLuceneSortSort;
import org.hibernate.search.backend.lucene.search.sort.impl.SortTypeKeys;
import org.hibernate.search.engine.search.sort.SearchSort;
import org.hibernate.search.engine.search.sort.spi.CompositeSortBuilder;
import org.hibernate.search.engine.search.sort.spi.DistanceSortBuilder;
import org.hibernate.search.engine.search.sort.spi.FieldSortBuilder;
import org.hibernate.search.engine.search.sort.spi.ScoreSortBuilder;

public class LuceneSearchSortBuilderFactoryImpl
implements LuceneSearchSortBuilderFactory {
    private final LuceneSearchContext searchContext;
    private final LuceneSearchIndexesContext indexes;

    public LuceneSearchSortBuilderFactoryImpl(LuceneSearchContext searchContext) {
        this.searchContext = searchContext;
        this.indexes = searchContext.indexes();
    }

    public void contribute(LuceneSearchSortCollector collector, SearchSort sort) {
        LuceneSearchSort luceneSort = LuceneSearchSort.from(this.searchContext, sort);
        luceneSort.toSortFields(collector);
    }

    public ScoreSortBuilder score() {
        return new LuceneScoreSort.Builder(this.searchContext);
    }

    public FieldSortBuilder field(String absoluteFieldPath) {
        return this.indexes.field(absoluteFieldPath).queryElement(SortTypeKeys.FIELD, this.searchContext);
    }

    public DistanceSortBuilder distance(String absoluteFieldPath) {
        return this.indexes.field(absoluteFieldPath).queryElement(SortTypeKeys.DISTANCE, this.searchContext);
    }

    public SearchSort indexOrder() {
        return new LuceneIndexOrderSort(this.searchContext);
    }

    public CompositeSortBuilder composite() {
        return new LuceneCompositeSort.Builder(this.searchContext);
    }

    @Override
    public LuceneSearchSort fromLuceneSortField(SortField luceneSortField) {
        return new LuceneUserProvidedLuceneSortFieldSort(this.searchContext, luceneSortField);
    }

    @Override
    public LuceneSearchSort fromLuceneSort(Sort luceneSort) {
        return new LuceneUserProvidedLuceneSortSort(this.searchContext, luceneSort);
    }
}

