/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.search.timeout.impl;

import java.lang.invoke.MethodHandles;
import java.time.Duration;
import java.util.concurrent.TimeUnit;
import org.apache.lucene.search.Query;
import org.apache.lucene.util.Counter;
import org.hibernate.search.backend.lucene.logging.impl.Log;
import org.hibernate.search.backend.lucene.search.timeout.impl.LuceneCounterAdapter;
import org.hibernate.search.engine.common.timing.spi.TimingSource;
import org.hibernate.search.engine.search.timeout.spi.TimeoutManager;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;

public final class LuceneTimeoutManager
extends TimeoutManager {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    private final Long timeoutValue;
    private final TimeUnit timeoutUnit;
    private final Query query;

    public static LuceneTimeoutManager noTimeout(TimingSource timingSource, Query query) {
        return new LuceneTimeoutManager(timingSource, query, null, null, TimeoutManager.Type.NONE);
    }

    public static LuceneTimeoutManager softTimeout(TimingSource timingSource, Query query, long timeout, TimeUnit timeUnit) {
        return new LuceneTimeoutManager(timingSource, query, timeout, timeUnit, TimeoutManager.Type.LIMIT);
    }

    public static LuceneTimeoutManager hardTimeout(TimingSource timingSource, Query query, long timeout, TimeUnit timeUnit) {
        return new LuceneTimeoutManager(timingSource, query, timeout, timeUnit, TimeoutManager.Type.EXCEPTION);
    }

    private LuceneTimeoutManager(TimingSource timingSource, Query query, Long timeoutValue, TimeUnit timeoutUnit, TimeoutManager.Type type) {
        super(timingSource, timeoutUnit == null ? null : Long.valueOf(timeoutUnit.toMillis(timeoutValue)), type);
        this.timeoutValue = timeoutValue;
        this.timeoutUnit = timeoutUnit;
        this.query = query;
    }

    public Counter createCounter() {
        return new LuceneCounterAdapter(this.timingSource);
    }

    protected void onTimedOut() {
        if (this.hasHardTimeout()) {
            throw log.timedOut(Duration.ofNanos(this.timeoutUnit.toNanos(this.timeoutValue)), this.query.toString());
        }
    }
}

