/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.types.aggregation.impl;

import java.io.IOException;
import java.util.Comparator;
import java.util.Set;
import java.util.TreeSet;
import org.apache.lucene.facet.FacetResult;
import org.apache.lucene.facet.FacetsCollector;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.SortedSetDocValues;
import org.hibernate.search.backend.lucene.lowlevel.docvalues.impl.JoiningTextMultiValuesSource;
import org.hibernate.search.backend.lucene.lowlevel.facet.impl.TextMultiValueFacetCounts;
import org.hibernate.search.backend.lucene.lowlevel.join.impl.NestedDocsProvider;
import org.hibernate.search.backend.lucene.search.impl.AbstractLuceneSearchFieldQueryElementFactory;
import org.hibernate.search.backend.lucene.search.impl.LuceneSearchContext;
import org.hibernate.search.backend.lucene.search.impl.LuceneSearchValueFieldContext;
import org.hibernate.search.backend.lucene.types.aggregation.impl.AbstractLuceneFacetsBasedTermsAggregation;
import org.hibernate.search.engine.backend.types.converter.spi.ProjectionConverter;
import org.hibernate.search.engine.search.common.ValueConvert;
import org.hibernate.search.util.common.reporting.spi.EventContextProvider;

public class LuceneTextTermsAggregation<K>
extends AbstractLuceneFacetsBasedTermsAggregation<String, String, K> {
    private static final Comparator<String> STRING_COMPARATOR = Comparator.naturalOrder();

    private LuceneTextTermsAggregation(Builder<K> builder) {
        super(builder);
    }

    @Override
    FacetResult getTopChildren(IndexReader reader, FacetsCollector facetsCollector, NestedDocsProvider nestedDocsProvider, int limit) throws IOException {
        JoiningTextMultiValuesSource valueSource = JoiningTextMultiValuesSource.fromField(this.absoluteFieldPath, nestedDocsProvider);
        TextMultiValueFacetCounts facetCounts = new TextMultiValueFacetCounts(reader, this.absoluteFieldPath, valueSource, facetsCollector);
        return facetCounts.getTopChildren(limit, this.absoluteFieldPath, new String[0]);
    }

    @Override
    Set<String> collectFirstTerms(IndexReader reader, boolean descending, int limit) throws IOException {
        TreeSet<String> collectedTerms = new TreeSet<String>(descending ? STRING_COMPARATOR.reversed() : STRING_COMPARATOR);
        for (LeafReaderContext leaf : reader.leaves()) {
            int i;
            LeafReader atomicReader = leaf.reader();
            SortedSetDocValues docValues = atomicReader.getSortedSetDocValues(this.absoluteFieldPath);
            if (docValues == null) continue;
            int valueCount = (int)docValues.getValueCount();
            if (descending) {
                int start;
                for (i = start = Math.max(0, valueCount - limit); i < valueCount; ++i) {
                    collectedTerms.add(docValues.lookupOrd((long)i).utf8ToString());
                }
                continue;
            }
            int end = Math.min(limit, valueCount);
            for (i = 0; i < end; ++i) {
                collectedTerms.add(docValues.lookupOrd((long)i).utf8ToString());
            }
        }
        return collectedTerms;
    }

    @Override
    Comparator<String> getAscendingTermComparator() {
        return STRING_COMPARATOR;
    }

    @Override
    String labelToTerm(String label) {
        return label;
    }

    @Override
    String termToFieldValue(String key) {
        return key;
    }

    public static class Builder<K>
    extends AbstractLuceneFacetsBasedTermsAggregation.AbstractBuilder<String, String, K> {
        private Builder(LuceneSearchContext searchContext, LuceneSearchValueFieldContext<String> field, ProjectionConverter<String, ? extends K> fromFieldValueConverter) {
            super(searchContext, field, fromFieldValueConverter);
        }

        @Override
        public LuceneTextTermsAggregation<K> build() {
            return new LuceneTextTermsAggregation(this);
        }
    }

    public static class TypeSelector
    extends AbstractLuceneFacetsBasedTermsAggregation.AbstractTypeSelector<String> {
        private TypeSelector(LuceneSearchContext searchContext, LuceneSearchValueFieldContext<String> field) {
            super(searchContext, field);
        }

        public <K> Builder<K> type(Class<K> expectedType, ValueConvert convert) {
            return new Builder(this.searchContext, this.field, this.field.type().projectionConverter(convert).withConvertedType(expectedType, (EventContextProvider)this.field));
        }
    }

    public static class Factory
    extends AbstractLuceneSearchFieldQueryElementFactory<AbstractLuceneFacetsBasedTermsAggregation.AbstractTypeSelector<?>, String> {
        @Override
        public TypeSelector create(LuceneSearchContext searchContext, LuceneSearchValueFieldContext<String> field) {
            return new TypeSelector(searchContext, field);
        }
    }
}

