/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.types.codec.impl;

import org.apache.lucene.document.StoredField;
import org.apache.lucene.index.IndexableField;
import org.hibernate.search.backend.lucene.document.impl.LuceneDocumentBuilder;
import org.hibernate.search.backend.lucene.types.codec.impl.AbstractLuceneNumericFieldCodec;
import org.hibernate.search.backend.lucene.types.codec.impl.DocValues;
import org.hibernate.search.backend.lucene.types.codec.impl.Indexing;
import org.hibernate.search.backend.lucene.types.codec.impl.Storage;
import org.hibernate.search.backend.lucene.types.lowlevel.impl.LuceneIntegerDomain;
import org.hibernate.search.backend.lucene.types.lowlevel.impl.LuceneNumericDomain;

public final class LuceneBooleanFieldCodec
extends AbstractLuceneNumericFieldCodec<Boolean, Integer> {
    public LuceneBooleanFieldCodec(Indexing indexing, DocValues docValues, Storage storage, Boolean indexNullAsValue) {
        super(indexing, docValues, storage, indexNullAsValue);
    }

    @Override
    void addStoredToDocument(LuceneDocumentBuilder documentBuilder, String absoluteFieldPath, Boolean value, Integer encodedValue) {
        documentBuilder.addField((IndexableField)new StoredField(absoluteFieldPath, encodedValue.intValue()));
    }

    @Override
    public Boolean decode(IndexableField field) {
        Integer intValue = (Integer)field.numericValue();
        return intValue > 0;
    }

    @Override
    public Integer encode(Boolean value) {
        return value != false ? 1 : 0;
    }

    @Override
    public Boolean decode(Integer encoded) {
        return encoded > 0;
    }

    @Override
    public LuceneNumericDomain<Integer> getDomain() {
        return LuceneIntegerDomain.get();
    }
}

