/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.types.codec.impl;

import org.apache.lucene.document.DoublePoint;
import org.apache.lucene.document.LatLonDocValuesField;
import org.apache.lucene.document.LatLonPoint;
import org.apache.lucene.document.StoredField;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.util.BytesRef;
import org.hibernate.search.backend.lucene.document.impl.LuceneDocumentBuilder;
import org.hibernate.search.backend.lucene.types.codec.impl.DocValues;
import org.hibernate.search.backend.lucene.types.codec.impl.Indexing;
import org.hibernate.search.backend.lucene.types.codec.impl.LuceneFieldCodec;
import org.hibernate.search.backend.lucene.types.codec.impl.Storage;
import org.hibernate.search.engine.spatial.GeoPoint;

public final class LuceneGeoPointFieldCodec
implements LuceneFieldCodec<GeoPoint> {
    private final Indexing indexing;
    private final DocValues docValues;
    private final Storage storage;
    private final GeoPoint indexNullAsValue;

    public LuceneGeoPointFieldCodec(Indexing indexing, DocValues docValues, Storage storage, GeoPoint indexNullAsValue) {
        this.indexing = indexing;
        this.docValues = docValues;
        this.storage = storage;
        this.indexNullAsValue = indexNullAsValue;
    }

    @Override
    public void addToDocument(LuceneDocumentBuilder documentBuilder, String absoluteFieldPath, GeoPoint value) {
        if (value == null && this.indexNullAsValue != null) {
            value = this.indexNullAsValue;
        }
        if (value == null) {
            return;
        }
        if (Indexing.ENABLED == this.indexing) {
            documentBuilder.addField((IndexableField)new LatLonPoint(absoluteFieldPath, value.latitude(), value.longitude()));
        }
        if (DocValues.ENABLED == this.docValues) {
            documentBuilder.addField((IndexableField)new LatLonDocValuesField(absoluteFieldPath, value.latitude(), value.longitude()));
        } else {
            documentBuilder.addFieldName(absoluteFieldPath);
        }
        if (Storage.ENABLED == this.storage) {
            documentBuilder.addField((IndexableField)new StoredField(absoluteFieldPath, LuceneGeoPointFieldCodec.toStoredBytes(value)));
        }
    }

    @Override
    public GeoPoint decode(IndexableField field) {
        return LuceneGeoPointFieldCodec.fromStoredBytes(field.binaryValue());
    }

    @Override
    public boolean isCompatibleWith(LuceneFieldCodec<?> obj) {
        if (this == obj) {
            return true;
        }
        return LuceneGeoPointFieldCodec.class == obj.getClass();
    }

    private static BytesRef toStoredBytes(GeoPoint geoPoint) {
        byte[] bytes = new byte[16];
        DoublePoint.encodeDimension((double)geoPoint.latitude(), (byte[])bytes, (int)0);
        DoublePoint.encodeDimension((double)geoPoint.longitude(), (byte[])bytes, (int)8);
        return new BytesRef(bytes);
    }

    private static GeoPoint fromStoredBytes(BytesRef bytesRef) {
        double latitude = DoublePoint.decodeDimension((byte[])bytesRef.bytes, (int)bytesRef.offset);
        double longitude = DoublePoint.decodeDimension((byte[])bytesRef.bytes, (int)(bytesRef.offset + 8));
        return GeoPoint.of((double)latitude, (double)longitude);
    }
}

