/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.types.predicate.impl;

import org.apache.lucene.index.Term;
import org.apache.lucene.search.DocValuesFieldExistsQuery;
import org.apache.lucene.search.NormsFieldExistsQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.hibernate.search.backend.lucene.lowlevel.common.impl.MetadataFields;
import org.hibernate.search.backend.lucene.search.impl.AbstractLuceneSearchFieldQueryElementFactory;
import org.hibernate.search.backend.lucene.search.impl.LuceneSearchContext;
import org.hibernate.search.backend.lucene.search.impl.LuceneSearchValueFieldContext;
import org.hibernate.search.backend.lucene.search.predicate.impl.AbstractLuceneLeafSingleFieldPredicate;
import org.hibernate.search.engine.search.predicate.SearchPredicate;
import org.hibernate.search.engine.search.predicate.spi.ExistsPredicateBuilder;

public class LuceneExistsPredicate
extends AbstractLuceneLeafSingleFieldPredicate {
    private LuceneExistsPredicate(AbstractBuilder<?> builder) {
        super(builder);
    }

    private static class DefaultBuilder<F>
    extends AbstractBuilder<F>
    implements ExistsPredicateBuilder {
        private DefaultBuilder(LuceneSearchContext searchContext, LuceneSearchValueFieldContext<F> field) {
            super(searchContext, field);
        }

        @Override
        protected Query buildQuery() {
            return new TermQuery(new Term(MetadataFields.fieldNamesFieldName(), this.absoluteFieldPath));
        }
    }

    public static class DefaultFactory<F>
    extends AbstractLuceneSearchFieldQueryElementFactory<ExistsPredicateBuilder, F> {
        @Override
        public DefaultBuilder<F> create(LuceneSearchContext searchContext, LuceneSearchValueFieldContext<F> field) {
            return new DefaultBuilder(searchContext, field);
        }
    }

    private static class DocValuesBasedBuilder<F>
    extends AbstractBuilder<F>
    implements ExistsPredicateBuilder {
        private DocValuesBasedBuilder(LuceneSearchContext searchContext, LuceneSearchValueFieldContext<F> field) {
            super(searchContext, field);
        }

        @Override
        protected Query buildQuery() {
            return new DocValuesFieldExistsQuery(this.absoluteFieldPath);
        }
    }

    public static class DocValuesBasedFactory<F>
    extends AbstractLuceneSearchFieldQueryElementFactory<ExistsPredicateBuilder, F> {
        @Override
        public DocValuesBasedBuilder<F> create(LuceneSearchContext searchContext, LuceneSearchValueFieldContext<F> field) {
            return new DocValuesBasedBuilder(searchContext, field);
        }
    }

    private static class NormsBasedBuilder
    extends AbstractBuilder<String>
    implements ExistsPredicateBuilder {
        private NormsBasedBuilder(LuceneSearchContext searchContext, LuceneSearchValueFieldContext<String> field) {
            super(searchContext, field);
        }

        @Override
        protected Query buildQuery() {
            return new NormsFieldExistsQuery(this.absoluteFieldPath);
        }
    }

    public static class NormsBasedFactory
    extends AbstractLuceneSearchFieldQueryElementFactory<ExistsPredicateBuilder, String> {
        @Override
        public NormsBasedBuilder create(LuceneSearchContext searchContext, LuceneSearchValueFieldContext<String> field) {
            return new NormsBasedBuilder(searchContext, field);
        }
    }

    private static class AbstractBuilder<F>
    extends AbstractLuceneLeafSingleFieldPredicate.AbstractBuilder<F>
    implements ExistsPredicateBuilder {
        private AbstractBuilder(LuceneSearchContext searchContext, LuceneSearchValueFieldContext<F> field) {
            super(searchContext, field);
            this.constantScore();
        }

        public SearchPredicate build() {
            return new LuceneExistsPredicate(this);
        }

        @Override
        protected Query buildQuery() {
            return new NormsFieldExistsQuery(this.absoluteFieldPath);
        }
    }
}

