/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.types.predicate.impl;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.hibernate.search.backend.lucene.document.model.impl.AbstractLuceneIndexSchemaFieldNode;
import org.hibernate.search.backend.lucene.document.model.impl.LuceneIndexSchemaObjectFieldNode;
import org.hibernate.search.backend.lucene.search.impl.LuceneSearchContext;
import org.hibernate.search.backend.lucene.search.impl.LuceneSearchValueFieldContext;
import org.hibernate.search.backend.lucene.search.predicate.impl.PredicateTypeKeys;
import org.hibernate.search.backend.lucene.types.predicate.impl.LuceneObjectExistsPredicate;
import org.hibernate.search.backend.lucene.types.predicate.impl.LuceneObjectPredicateBuilderFactory;
import org.hibernate.search.engine.search.predicate.spi.ExistsPredicateBuilder;
import org.hibernate.search.util.common.SearchException;

public class LuceneObjectPredicateBuilderFactoryImpl
implements LuceneObjectPredicateBuilderFactory {
    private final String absoluteFieldPath;
    private final List<String> nestedPathHierarchy;
    private final Map<String, LuceneSearchValueFieldContext<?>> leafFields = new HashMap();

    public LuceneObjectPredicateBuilderFactoryImpl(LuceneIndexSchemaObjectFieldNode objectNode) {
        this.absoluteFieldPath = objectNode.absolutePath();
        this.nestedPathHierarchy = objectNode.nestedPathHierarchy();
        this.addLeafFields(objectNode);
    }

    @Override
    public boolean isCompatibleWith(LuceneObjectPredicateBuilderFactory other) {
        if (!this.getClass().equals(other.getClass())) {
            return false;
        }
        LuceneObjectPredicateBuilderFactoryImpl casted = (LuceneObjectPredicateBuilderFactoryImpl)other;
        Set<String> leafFieldPaths = this.leafFields.keySet();
        if (!leafFieldPaths.equals(casted.leafFields.keySet())) {
            return false;
        }
        Iterator<String> iterator = leafFieldPaths.iterator();
        if (iterator.hasNext()) {
            String leafFieldPath = iterator.next();
            try {
                this.leafFields.get(leafFieldPath).type().queryElementFactory(PredicateTypeKeys.EXISTS).checkCompatibleWith(casted.leafFields.get(leafFieldPath).type().queryElementFactory(PredicateTypeKeys.EXISTS));
                return true;
            }
            catch (SearchException e) {
                return false;
            }
        }
        return true;
    }

    @Override
    public ExistsPredicateBuilder createExistsPredicateBuilder(LuceneSearchContext searchContext) {
        LuceneObjectExistsPredicate.Builder builder = new LuceneObjectExistsPredicate.Builder(searchContext, this.absoluteFieldPath, this.nestedPathHierarchy);
        for (Map.Entry<String, LuceneSearchValueFieldContext<?>> entry : this.leafFields.entrySet()) {
            ExistsPredicateBuilder existsPredicateBuilder = entry.getValue().queryElement(PredicateTypeKeys.EXISTS, searchContext);
            builder.addChild(existsPredicateBuilder.build());
        }
        return builder;
    }

    private void addLeafFields(LuceneIndexSchemaObjectFieldNode objectNode) {
        for (AbstractLuceneIndexSchemaFieldNode abstractLuceneIndexSchemaFieldNode : objectNode.staticChildren()) {
            if (abstractLuceneIndexSchemaFieldNode.isObjectField() && !abstractLuceneIndexSchemaFieldNode.toObjectField().type().nested()) {
                this.addLeafFields(abstractLuceneIndexSchemaFieldNode.toObjectField());
                continue;
            }
            if (!abstractLuceneIndexSchemaFieldNode.isValueField()) continue;
            this.leafFields.put(abstractLuceneIndexSchemaFieldNode.absolutePath(), (LuceneSearchValueFieldContext)((Object)abstractLuceneIndexSchemaFieldNode));
        }
    }
}

