/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.document.model.dsl.impl;

import java.util.List;
import org.hibernate.search.backend.lucene.document.model.dsl.impl.AbstractLuceneIndexSchemaObjectNodeBuilder;
import org.hibernate.search.backend.lucene.document.model.impl.AbstractLuceneIndexSchemaFieldNode;
import org.hibernate.search.backend.lucene.document.model.impl.AbstractLuceneIndexSchemaFieldTemplate;
import org.hibernate.search.backend.lucene.document.model.impl.LuceneIndexSchemaNodeCollector;
import org.hibernate.search.backend.lucene.document.model.impl.LuceneIndexSchemaNodeContributor;
import org.hibernate.search.backend.lucene.document.model.impl.LuceneIndexSchemaObjectNode;
import org.hibernate.search.engine.backend.common.spi.FieldPaths;
import org.hibernate.search.engine.backend.document.model.dsl.IndexSchemaFieldTemplateOptionsStep;
import org.hibernate.search.engine.backend.document.model.dsl.spi.IndexSchemaBuildContext;
import org.hibernate.search.engine.backend.document.model.spi.IndexFieldInclusion;
import org.hibernate.search.engine.reporting.spi.EventContexts;
import org.hibernate.search.util.common.pattern.spi.SimpleGlobPattern;
import org.hibernate.search.util.common.reporting.EventContext;

abstract class AbstractLuceneIndexSchemaFieldTemplateBuilder<S extends AbstractLuceneIndexSchemaFieldTemplateBuilder<S, T>, T extends AbstractLuceneIndexSchemaFieldTemplate<?>>
implements IndexSchemaFieldTemplateOptionsStep<S>,
LuceneIndexSchemaNodeContributor,
IndexSchemaBuildContext {
    private final AbstractLuceneIndexSchemaObjectNodeBuilder parent;
    protected final String absolutePath;
    protected final IndexFieldInclusion inclusion;
    private final String prefix;
    private SimpleGlobPattern relativePathGlob;
    private boolean multiValued = false;

    AbstractLuceneIndexSchemaFieldTemplateBuilder(AbstractLuceneIndexSchemaObjectNodeBuilder parent, String templateName, IndexFieldInclusion inclusion, String prefix) {
        this.parent = parent;
        this.absolutePath = FieldPaths.compose((String)parent.getAbsolutePath(), (String)templateName);
        this.inclusion = inclusion;
        this.prefix = prefix;
    }

    public EventContext eventContext() {
        return this.parent.getRootNodeBuilder().getIndexEventContext().append(EventContexts.fromIndexFieldAbsolutePath((String)this.parent.getAbsolutePath())).append(EventContexts.fromFieldTemplateAbsolutePath((String)this.absolutePath));
    }

    public S matchingPathGlob(String pathGlob) {
        this.relativePathGlob = SimpleGlobPattern.compile((String)pathGlob);
        return this.thisAsS();
    }

    public S multiValued() {
        this.multiValued = true;
        return this.thisAsS();
    }

    @Override
    public void contribute(LuceneIndexSchemaNodeCollector collector, LuceneIndexSchemaObjectNode parentNode, List<AbstractLuceneIndexSchemaFieldNode> staticChildrenForParent) {
        SimpleGlobPattern absolutePathGlob = FieldPaths.absolutize((String)this.parent.getAbsolutePath(), (String)this.prefix, (SimpleGlobPattern)(this.relativePathGlob != null ? this.relativePathGlob : SimpleGlobPattern.compile((String)"*")));
        this.doContribute(collector, parentNode, absolutePathGlob, this.multiValued);
    }

    protected abstract S thisAsS();

    protected abstract void doContribute(LuceneIndexSchemaNodeCollector var1, LuceneIndexSchemaObjectNode var2, SimpleGlobPattern var3, boolean var4);
}

