/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.document.model.impl;

import java.lang.invoke.MethodHandles;
import java.util.List;
import org.hibernate.search.backend.lucene.document.model.impl.AbstractLuceneIndexSchemaFieldNode;
import org.hibernate.search.backend.lucene.document.model.impl.LuceneIndexSchemaObjectFieldNode;
import org.hibernate.search.backend.lucene.document.model.impl.LuceneIndexSchemaObjectNode;
import org.hibernate.search.backend.lucene.logging.impl.Log;
import org.hibernate.search.backend.lucene.search.impl.LuceneSearchContext;
import org.hibernate.search.backend.lucene.search.impl.LuceneSearchFieldQueryElementFactory;
import org.hibernate.search.backend.lucene.search.impl.LuceneSearchValueFieldContext;
import org.hibernate.search.backend.lucene.search.impl.SearchQueryElementTypeKey;
import org.hibernate.search.backend.lucene.types.impl.LuceneIndexValueFieldType;
import org.hibernate.search.engine.backend.document.model.spi.IndexFieldInclusion;
import org.hibernate.search.engine.backend.metamodel.IndexValueFieldDescriptor;
import org.hibernate.search.engine.reporting.spi.EventContexts;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;
import org.hibernate.search.util.common.reporting.EventContext;

public class LuceneIndexSchemaValueFieldNode<F>
extends AbstractLuceneIndexSchemaFieldNode
implements IndexValueFieldDescriptor,
LuceneSearchValueFieldContext<F> {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    private final List<String> nestedPathHierarchy;
    private final LuceneIndexValueFieldType<F> type;

    public LuceneIndexSchemaValueFieldNode(LuceneIndexSchemaObjectNode parent, String relativeName, IndexFieldInclusion inclusion, boolean multiValued, LuceneIndexValueFieldType<F> type) {
        super(parent, relativeName, inclusion, multiValued);
        this.nestedPathHierarchy = parent.nestedPathHierarchy();
        this.type = type;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[absolutePath=" + this.absolutePath + ", type=" + this.type + "]";
    }

    public boolean isObjectField() {
        return false;
    }

    public boolean isValueField() {
        return true;
    }

    @Override
    public LuceneIndexSchemaObjectFieldNode toObjectField() {
        throw log.invalidIndexElementTypeValueFieldIsNotObjectField(this.absolutePath);
    }

    @Override
    public LuceneIndexSchemaValueFieldNode<F> toValueField() {
        return this;
    }

    @Override
    public String nestedDocumentPath() {
        return this.nestedPathHierarchy.isEmpty() ? null : this.nestedPathHierarchy.get(this.nestedPathHierarchy.size() - 1);
    }

    @Override
    public List<String> nestedPathHierarchy() {
        return this.nestedPathHierarchy;
    }

    @Override
    public LuceneIndexValueFieldType<F> type() {
        return this.type;
    }

    public EventContext eventContext() {
        return EventContexts.fromIndexFieldAbsolutePath((String)this.absolutePath);
    }

    @Override
    public <T> T queryElement(SearchQueryElementTypeKey<T> key, LuceneSearchContext searchContext) {
        LuceneSearchFieldQueryElementFactory factory = this.type().queryElementFactory(key);
        if (factory == null) {
            throw log.cannotUseQueryElementForField(this.absolutePath(), key.toString(), this.eventContext());
        }
        return factory.create(searchContext, this);
    }

    public <T> LuceneIndexSchemaValueFieldNode<? super T> withValueType(Class<T> expectedSubType, EventContext eventContext) {
        if (!this.type.valueClass().isAssignableFrom(expectedSubType)) {
            throw log.invalidFieldValueType(this.type.valueClass(), expectedSubType, eventContext.append(EventContexts.fromIndexFieldAbsolutePath((String)this.absolutePath)));
        }
        return this;
    }
}

