/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.types.predicate.impl;

import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermRangeQuery;
import org.apache.lucene.util.BytesRef;
import org.hibernate.search.backend.lucene.search.impl.AbstractLuceneCodecAwareSearchFieldQueryElementFactory;
import org.hibernate.search.backend.lucene.search.impl.LuceneSearchContext;
import org.hibernate.search.backend.lucene.search.impl.LuceneSearchValueFieldContext;
import org.hibernate.search.backend.lucene.search.predicate.impl.AbstractLuceneLeafSingleFieldPredicate;
import org.hibernate.search.backend.lucene.types.codec.impl.LuceneStandardFieldCodec;
import org.hibernate.search.engine.search.common.ValueConvert;
import org.hibernate.search.engine.search.predicate.SearchPredicate;
import org.hibernate.search.engine.search.predicate.spi.RangePredicateBuilder;
import org.hibernate.search.util.common.data.Range;
import org.hibernate.search.util.common.data.RangeBoundInclusion;

public class LuceneTextRangePredicate
extends AbstractLuceneLeafSingleFieldPredicate {
    private LuceneTextRangePredicate(Builder builder) {
        super(builder);
    }

    private static class Builder<F>
    extends AbstractLuceneLeafSingleFieldPredicate.AbstractBuilder<F>
    implements RangePredicateBuilder {
        private final LuceneStandardFieldCodec<F, String> codec;
        private Range<String> range;

        private Builder(LuceneStandardFieldCodec<F, String> codec, LuceneSearchContext searchContext, LuceneSearchValueFieldContext<F> field) {
            super(searchContext, field);
            this.codec = codec;
        }

        public void range(Range<?> range, ValueConvert convertLowerBound, ValueConvert convertUpperBound) {
            this.range = this.convertAndEncode(this.codec, range, convertLowerBound, convertUpperBound);
        }

        public SearchPredicate build() {
            return new LuceneTextRangePredicate(this);
        }

        @Override
        protected Query buildQuery() {
            return new TermRangeQuery(this.absoluteFieldPath, this.normalize(this.range.lowerBoundValue().orElse(null)), this.normalize(this.range.upperBoundValue().orElse(null)), RangeBoundInclusion.INCLUDED.equals((Object)this.range.lowerBoundInclusion()) || !this.range.lowerBoundValue().isPresent(), RangeBoundInclusion.INCLUDED.equals((Object)this.range.upperBoundInclusion()) || !this.range.upperBoundValue().isPresent());
        }

        private BytesRef normalize(String value) {
            if (value == null) {
                return null;
            }
            Analyzer searchAnalyzerOrNormalizer = this.field.type().searchAnalyzerOrNormalizer();
            return searchAnalyzerOrNormalizer.normalize(this.absoluteFieldPath, value);
        }
    }

    public static class Factory<F>
    extends AbstractLuceneCodecAwareSearchFieldQueryElementFactory<RangePredicateBuilder, F, LuceneStandardFieldCodec<F, String>> {
        public Factory(LuceneStandardFieldCodec<F, String> codec) {
            super(codec);
        }

        @Override
        public Builder<F> create(LuceneSearchContext searchContext, LuceneSearchValueFieldContext<F> field) {
            return new Builder((LuceneStandardFieldCodec)this.codec, searchContext, field);
        }
    }
}

