/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.types.sort.comparatorsource.impl;

import java.io.IOException;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.NumericDocValues;
import org.apache.lucene.search.FieldComparator;
import org.apache.lucene.search.Query;
import org.hibernate.search.backend.lucene.lowlevel.docvalues.impl.GeoPointDistanceMultiValuesToSingleValuesSource;
import org.hibernate.search.backend.lucene.lowlevel.docvalues.impl.MultiValueMode;
import org.hibernate.search.backend.lucene.types.sort.comparatorsource.impl.LuceneFieldComparatorSource;
import org.hibernate.search.engine.spatial.GeoPoint;

public class LuceneGeoPointDistanceComparatorSource
extends LuceneFieldComparatorSource {
    private static final double MISSING_VALUE_IMPLICIT_DISTANCE_VALUE = Double.POSITIVE_INFINITY;
    private final GeoPoint center;
    private final MultiValueMode mode;

    public LuceneGeoPointDistanceComparatorSource(String nestedDocumentPath, GeoPoint center, MultiValueMode mode, Query filter) {
        super(nestedDocumentPath, filter);
        this.center = center;
        this.mode = mode;
    }

    public FieldComparator<?> newComparator(String fieldname, int numHits, int sortPos, boolean reversed) {
        final GeoPointDistanceMultiValuesToSingleValuesSource source = new GeoPointDistanceMultiValuesToSingleValuesSource(fieldname, this.mode, this.nestedDocsProvider, this.center);
        return new FieldComparator.DoubleComparator(numHits, fieldname, Double.POSITIVE_INFINITY){

            protected NumericDocValues getNumericDocValues(LeafReaderContext context, String field) throws IOException {
                return source.getValues(context, null).getRawDoubleValues();
            }
        };
    }
}

