/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.types.sort.impl;

import java.lang.invoke.MethodHandles;
import java.time.temporal.TemporalAccessor;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.search.SortField;
import org.apache.lucene.util.BytesRef;
import org.hibernate.search.backend.lucene.logging.impl.Log;
import org.hibernate.search.backend.lucene.search.impl.AbstractLuceneCodecAwareSearchFieldQueryElementFactory;
import org.hibernate.search.backend.lucene.search.impl.LuceneSearchContext;
import org.hibernate.search.backend.lucene.search.impl.LuceneSearchValueFieldContext;
import org.hibernate.search.backend.lucene.types.codec.impl.AbstractLuceneNumericFieldCodec;
import org.hibernate.search.backend.lucene.types.codec.impl.LuceneStandardFieldCodec;
import org.hibernate.search.backend.lucene.types.sort.comparatorsource.impl.LuceneFieldComparatorSource;
import org.hibernate.search.backend.lucene.types.sort.comparatorsource.impl.LuceneNumericFieldComparatorSource;
import org.hibernate.search.backend.lucene.types.sort.comparatorsource.impl.LuceneTextFieldComparatorSource;
import org.hibernate.search.backend.lucene.types.sort.impl.AbstractLuceneDocumentValueSort;
import org.hibernate.search.backend.lucene.types.sort.impl.SortMissingValue;
import org.hibernate.search.engine.backend.types.converter.spi.DslConverter;
import org.hibernate.search.engine.search.common.SortMode;
import org.hibernate.search.engine.search.common.ValueConvert;
import org.hibernate.search.engine.search.sort.SearchSort;
import org.hibernate.search.engine.search.sort.dsl.SortOrder;
import org.hibernate.search.engine.search.sort.spi.FieldSortBuilder;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;

public class LuceneStandardFieldSort
extends AbstractLuceneDocumentValueSort {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());

    private LuceneStandardFieldSort(AbstractBuilder builder) {
        super(builder);
    }

    private static class TemporalFieldBuilder<F extends TemporalAccessor, E extends Number>
    extends NumericFieldBuilder<F, E> {
        private TemporalFieldBuilder(AbstractLuceneNumericFieldCodec<F, E> codec, LuceneSearchContext searchContext, LuceneSearchValueFieldContext<F> field) {
            super(codec, searchContext, field);
        }

        @Override
        public void mode(SortMode mode) {
            switch (mode) {
                case MIN: 
                case MAX: 
                case AVG: 
                case MEDIAN: {
                    super.mode(mode);
                    break;
                }
                case SUM: {
                    throw log.cannotComputeSumForTemporalField(this.getEventContext());
                }
            }
        }
    }

    public static class TemporalFieldFactory<F extends TemporalAccessor, E extends Number>
    extends AbstractFactory<F, E, AbstractLuceneNumericFieldCodec<F, E>> {
        public TemporalFieldFactory(AbstractLuceneNumericFieldCodec<F, E> codec) {
            super(codec);
        }

        @Override
        public FieldSortBuilder create(LuceneSearchContext searchContext, LuceneSearchValueFieldContext<F> field) {
            return new TemporalFieldBuilder((AbstractLuceneNumericFieldCodec)this.codec, searchContext, field);
        }
    }

    private static class TextFieldBuilder<F>
    extends AbstractBuilder<F, String, LuceneStandardFieldCodec<F, String>> {
        private TextFieldBuilder(LuceneStandardFieldCodec<F, String> codec, LuceneSearchContext searchContext, LuceneSearchValueFieldContext<F> field) {
            super(searchContext, field, codec, SortField.STRING_FIRST, SortField.STRING_LAST);
        }

        @Override
        protected Object encodeMissingAs(F converted) {
            return this.normalize((String)this.codec.encode(converted));
        }

        @Override
        public void mode(SortMode mode) {
            switch (mode) {
                case MIN: 
                case MAX: {
                    super.mode(mode);
                    break;
                }
                default: {
                    throw log.cannotComputeSumOrAvgOrMedianForStringField(this.getEventContext());
                }
            }
        }

        @Override
        protected LuceneFieldComparatorSource toFieldComparatorSource() {
            return new LuceneTextFieldComparatorSource(this.nestedDocumentPath, this.missingValue, this.getMultiValueMode(), this.getNestedFilter());
        }

        private BytesRef normalize(String value) {
            if (value == null) {
                return null;
            }
            Analyzer searchAnalyzerOrNormalizer = this.field.type().searchAnalyzerOrNormalizer();
            return searchAnalyzerOrNormalizer.normalize(this.absoluteFieldPath, value);
        }
    }

    public static class TextFieldFactory<F>
    extends AbstractFactory<F, String, LuceneStandardFieldCodec<F, String>> {
        public TextFieldFactory(LuceneStandardFieldCodec<F, String> codec) {
            super(codec);
        }

        @Override
        public FieldSortBuilder create(LuceneSearchContext searchContext, LuceneSearchValueFieldContext<F> field) {
            return new TextFieldBuilder((LuceneStandardFieldCodec)this.codec, searchContext, field);
        }
    }

    private static class NumericFieldBuilder<F, E extends Number>
    extends AbstractBuilder<F, E, AbstractLuceneNumericFieldCodec<F, E>> {
        private NumericFieldBuilder(AbstractLuceneNumericFieldCodec<F, E> codec, LuceneSearchContext searchContext, LuceneSearchValueFieldContext<F> field) {
            super(searchContext, field, codec, codec.getDomain().getMinValue(), codec.getDomain().getMaxValue());
        }

        @Override
        protected LuceneFieldComparatorSource toFieldComparatorSource() {
            return new LuceneNumericFieldComparatorSource<Number>(this.nestedDocumentPath, ((AbstractLuceneNumericFieldCodec)this.codec).getDomain(), (Number)this.getEffectiveMissingValue(), this.getMultiValueMode(), this.getNestedFilter());
        }
    }

    public static class NumericFieldFactory<F, E extends Number>
    extends AbstractFactory<F, E, AbstractLuceneNumericFieldCodec<F, E>> {
        public NumericFieldFactory(AbstractLuceneNumericFieldCodec<F, E> codec) {
            super(codec);
        }

        @Override
        public FieldSortBuilder create(LuceneSearchContext searchContext, LuceneSearchValueFieldContext<F> field) {
            return new NumericFieldBuilder((AbstractLuceneNumericFieldCodec)this.codec, searchContext, field);
        }
    }

    static abstract class AbstractBuilder<F, E, C extends LuceneStandardFieldCodec<F, E>>
    extends AbstractLuceneDocumentValueSort.AbstractBuilder
    implements FieldSortBuilder {
        protected final LuceneSearchValueFieldContext<F> field;
        protected final C codec;
        private final Object sortMissingValueFirstPlaceholder;
        private final Object sortMissingValueLastPlaceholder;
        protected Object missingValue = SortMissingValue.MISSING_LAST;

        protected AbstractBuilder(LuceneSearchContext searchContext, LuceneSearchValueFieldContext<F> field, C codec, Object sortMissingValueFirstPlaceholder, Object sortMissingValueLastPlaceholder) {
            super(searchContext, field);
            this.field = field;
            this.codec = codec;
            this.sortMissingValueFirstPlaceholder = sortMissingValueFirstPlaceholder;
            this.sortMissingValueLastPlaceholder = sortMissingValueLastPlaceholder;
        }

        public void missingFirst() {
            this.missingValue = SortMissingValue.MISSING_FIRST;
        }

        public void missingLast() {
            this.missingValue = SortMissingValue.MISSING_LAST;
        }

        public void missingAs(Object value, ValueConvert convert) {
            DslConverter<?, F> dslToIndexConverter = this.field.type().dslConverter(convert);
            try {
                Object converted = dslToIndexConverter.convertUnknown(value, this.searchContext.toDocumentFieldValueConvertContext());
                this.missingValue = this.encodeMissingAs(converted);
            }
            catch (RuntimeException e) {
                throw log.cannotConvertDslParameter(e.getMessage(), e, this.getEventContext());
            }
        }

        public SearchSort build() {
            return new LuceneStandardFieldSort(this);
        }

        protected Object encodeMissingAs(F converted) {
            return this.codec.encode(converted);
        }

        protected final Object getEffectiveMissingValue() {
            Object effectiveMissingValue = this.missingValue == SortMissingValue.MISSING_FIRST ? (this.order == SortOrder.DESC ? this.sortMissingValueLastPlaceholder : this.sortMissingValueFirstPlaceholder) : (this.missingValue == SortMissingValue.MISSING_LAST ? (this.order == SortOrder.DESC ? this.sortMissingValueFirstPlaceholder : this.sortMissingValueLastPlaceholder) : this.missingValue);
            return effectiveMissingValue;
        }
    }

    static abstract class AbstractFactory<F, E, C extends LuceneStandardFieldCodec<F, E>>
    extends AbstractLuceneCodecAwareSearchFieldQueryElementFactory<FieldSortBuilder, F, C> {
        protected AbstractFactory(C codec) {
            super(codec);
        }
    }
}

