/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.work.impl;

import java.io.IOException;
import java.lang.invoke.MethodHandles;
import org.apache.lucene.search.IndexSearcher;
import org.hibernate.search.backend.lucene.logging.impl.Log;
import org.hibernate.search.backend.lucene.work.impl.LuceneSearcher;
import org.hibernate.search.backend.lucene.work.impl.ReadWork;
import org.hibernate.search.backend.lucene.work.impl.ReadWorkExecutionContext;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;

public class SearchWork<R>
implements ReadWork<R> {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    private final LuceneSearcher<R, ?> searcher;
    private final int offset;
    private final Integer limit;
    private final int totalHitCountThreshold;

    SearchWork(LuceneSearcher<R, ?> searcher, Integer offset, Integer limit, int totalHitCountThreshold) {
        this.offset = offset == null ? 0 : offset;
        this.limit = limit;
        this.searcher = searcher;
        this.totalHitCountThreshold = totalHitCountThreshold;
    }

    @Override
    public R execute(ReadWorkExecutionContext context) {
        try {
            IndexSearcher indexSearcher = context.createSearcher();
            return this.searcher.search(indexSearcher, context.getIndexReaderMetadataResolver(), this.offset, this.limit, this.totalHitCountThreshold);
        }
        catch (IOException e) {
            throw log.ioExceptionOnQueryExecution(this.searcher.getLuceneQueryForExceptions(), context.getEventContext(), e);
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this.getClass().getSimpleName()).append("[").append("searcher=").append(this.searcher).append(", offset=").append(this.offset).append(", limit=").append(this.limit).append(", totalHitCountThreshold=").append(this.totalHitCountThreshold).append("]");
        return sb.toString();
    }
}

