/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.document.impl;

import java.util.List;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.FieldType;
import org.apache.lucene.document.StringField;
import org.apache.lucene.index.DocValuesType;
import org.apache.lucene.index.IndexOptions;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.index.IndexableFieldType;
import org.apache.lucene.util.BytesRef;
import org.hibernate.search.backend.lucene.document.impl.AbstractLuceneNonFlattenedDocumentBuilder;
import org.hibernate.search.backend.lucene.document.model.impl.LuceneIndexSchemaObjectNode;
import org.hibernate.search.backend.lucene.multitenancy.impl.MultiTenancyStrategy;
import org.hibernate.search.backend.lucene.util.impl.LuceneFields;

class LuceneNestedObjectDocumentBuilder
extends AbstractLuceneNonFlattenedDocumentBuilder {
    private static final FieldType TYPE_STORED_BINARY = new FieldType();

    LuceneNestedObjectDocumentBuilder(LuceneIndexSchemaObjectNode schemaNode) {
        super(schemaNode);
    }

    @Override
    void contribute(String rootIndexName, MultiTenancyStrategy multiTenancyStrategy, String tenantId, String rootId, List<Document> nestedDocuments) {
        this.document.add((IndexableField)new StringField(LuceneFields.typeFieldName(), "child", Field.Store.YES));
        this.document.add((IndexableField)new StringField(LuceneFields.rootIndexFieldName(), rootIndexName, Field.Store.YES));
        this.document.add((IndexableField)new Field(LuceneFields.rootIdFieldName(), new BytesRef((CharSequence)rootId), (IndexableFieldType)TYPE_STORED_BINARY));
        this.document.add((IndexableField)new StringField(LuceneFields.nestedDocumentPathFieldName(), this.schemaNode.getAbsolutePath(), Field.Store.YES));
        super.contribute(rootIndexName, multiTenancyStrategy, tenantId, rootId, nestedDocuments);
        nestedDocuments.add(this.document);
    }

    static {
        TYPE_STORED_BINARY.setOmitNorms(true);
        TYPE_STORED_BINARY.setIndexOptions(IndexOptions.DOCS);
        TYPE_STORED_BINARY.setStored(true);
        TYPE_STORED_BINARY.setTokenized(false);
        TYPE_STORED_BINARY.setDocValuesType(DocValuesType.BINARY);
        TYPE_STORED_BINARY.freeze();
    }
}

