/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.document.model.impl;

import java.util.Map;
import org.apache.lucene.facet.FacetsConfig;
import org.hibernate.search.backend.lucene.analysis.impl.ScopedAnalyzer;
import org.hibernate.search.backend.lucene.document.model.impl.LuceneIndexSchemaFieldNode;
import org.hibernate.search.backend.lucene.document.model.impl.LuceneIndexSchemaObjectNode;
import org.hibernate.search.engine.backend.types.converter.spi.ToDocumentIdentifierValueConverter;
import org.hibernate.search.engine.reporting.spi.EventContexts;
import org.hibernate.search.util.common.impl.CollectionHelper;
import org.hibernate.search.util.common.reporting.EventContext;

public class LuceneIndexModel
implements AutoCloseable {
    private final String indexName;
    private final ToDocumentIdentifierValueConverter<?> idDslConverter;
    private final Map<String, LuceneIndexSchemaObjectNode> objectNodes;
    private final Map<String, LuceneIndexSchemaFieldNode<?>> fieldNodes;
    private final ScopedAnalyzer scopedAnalyzer;
    private final FacetsConfig facetsConfig;

    public LuceneIndexModel(String indexName, ToDocumentIdentifierValueConverter<?> idDslConverter, Map<String, LuceneIndexSchemaObjectNode> objectNodesBuilder, Map<String, LuceneIndexSchemaFieldNode<?>> fieldNodesBuilder, ScopedAnalyzer scopedAnalyzer, FacetsConfig facetsConfig) {
        this.indexName = indexName;
        this.idDslConverter = idDslConverter;
        this.fieldNodes = CollectionHelper.toImmutableMap(fieldNodesBuilder);
        this.objectNodes = CollectionHelper.toImmutableMap(objectNodesBuilder);
        this.scopedAnalyzer = scopedAnalyzer;
        this.facetsConfig = facetsConfig;
    }

    @Override
    public void close() {
        this.scopedAnalyzer.close();
    }

    public String getIndexName() {
        return this.indexName;
    }

    public EventContext getEventContext() {
        return EventContexts.fromIndexName((String)this.indexName);
    }

    public ToDocumentIdentifierValueConverter<?> getIdDslConverter() {
        return this.idDslConverter;
    }

    public LuceneIndexSchemaFieldNode<?> getFieldNode(String absoluteFieldPath) {
        return this.fieldNodes.get(absoluteFieldPath);
    }

    public LuceneIndexSchemaObjectNode getObjectNode(String absolutePath) {
        return this.objectNodes.get(absolutePath);
    }

    public ScopedAnalyzer getScopedAnalyzer() {
        return this.scopedAnalyzer;
    }

    public FacetsConfig getFacetsConfig() {
        return this.facetsConfig;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + "indexName=" + this.indexName + "]";
    }
}

