/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.index.impl;

import java.lang.invoke.MethodHandles;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import org.hibernate.search.backend.lucene.index.spi.ShardingStrategy;
import org.hibernate.search.backend.lucene.index.spi.ShardingStrategyInitializationContext;
import org.hibernate.search.backend.lucene.logging.impl.Log;
import org.hibernate.search.engine.cfg.spi.ConfigurationProperty;
import org.hibernate.search.engine.cfg.spi.OptionalConfigurationProperty;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;

public class ExplicitShardingStrategy
implements ShardingStrategy {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    public static final String NAME = "explicit";
    private static final OptionalConfigurationProperty<List<String>> SHARD_IDENTIFIERS = ConfigurationProperty.forKey((String)"shard_identifiers").asString().multivalued(Pattern.compile(",")).build();
    private Set<String> shardIdSet;

    @Override
    public void initialize(ShardingStrategyInitializationContext context) {
        List shardIdentifiers = (List)SHARD_IDENTIFIERS.getOrThrow(context.getConfigurationPropertySource(), key -> log.missingPropertyValueForShardingStrategy(NAME, (String)key));
        this.shardIdSet = new LinkedHashSet<String>(shardIdentifiers);
        context.setShardIdentifiers(this.shardIdSet);
    }

    @Override
    public String toShardIdentifier(String documentId, String routingKey) {
        this.checkShardIdentifier(routingKey);
        return routingKey;
    }

    @Override
    public Set<String> toShardIdentifiers(Set<String> routingKeys) {
        for (String routingKey : routingKeys) {
            this.checkShardIdentifier(routingKey);
        }
        return routingKeys;
    }

    private void checkShardIdentifier(String routingKey) {
        if (!this.shardIdSet.contains(routingKey)) {
            throw log.invalidRoutingKeyForExplicitShardingStrategy(routingKey, this.shardIdSet);
        }
    }
}

