/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.index.impl;

import java.util.Optional;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.facet.FacetsConfig;
import org.hibernate.search.backend.lucene.analysis.model.impl.LuceneAnalysisDefinitionRegistry;
import org.hibernate.search.backend.lucene.document.impl.LuceneIndexEntryFactory;
import org.hibernate.search.backend.lucene.document.impl.LuceneRootDocumentBuilder;
import org.hibernate.search.backend.lucene.document.model.impl.LuceneIndexModel;
import org.hibernate.search.backend.lucene.index.impl.Shard;
import org.hibernate.search.backend.lucene.lowlevel.directory.impl.DirectoryCreationContextImpl;
import org.hibernate.search.backend.lucene.lowlevel.directory.spi.DirectoryHolder;
import org.hibernate.search.backend.lucene.lowlevel.directory.spi.DirectoryProvider;
import org.hibernate.search.backend.lucene.lowlevel.index.impl.IndexAccessor;
import org.hibernate.search.backend.lucene.multitenancy.impl.MultiTenancyStrategy;
import org.hibernate.search.backend.lucene.orchestration.impl.LuceneBatchingWriteWorkOrchestrator;
import org.hibernate.search.backend.lucene.orchestration.impl.LuceneReadWorkOrchestrator;
import org.hibernate.search.backend.lucene.orchestration.impl.LuceneWriteWorkOrchestratorImplementor;
import org.hibernate.search.backend.lucene.orchestration.impl.LuceneWriteWorkProcessor;
import org.hibernate.search.backend.lucene.scope.model.impl.LuceneScopeModel;
import org.hibernate.search.backend.lucene.search.extraction.impl.LuceneDocumentStoredFieldVisitorBuilder;
import org.hibernate.search.backend.lucene.search.impl.LuceneSearchContext;
import org.hibernate.search.backend.lucene.search.projection.impl.LuceneSearchProjection;
import org.hibernate.search.backend.lucene.search.query.impl.LuceneSearchQueryBuilder;
import org.hibernate.search.backend.lucene.search.query.impl.SearchBackendContext;
import org.hibernate.search.backend.lucene.work.execution.impl.LuceneIndexIndexer;
import org.hibernate.search.backend.lucene.work.execution.impl.LuceneIndexIndexingPlan;
import org.hibernate.search.backend.lucene.work.execution.impl.LuceneIndexWorkspace;
import org.hibernate.search.backend.lucene.work.execution.impl.WorkExecutionBackendContext;
import org.hibernate.search.backend.lucene.work.execution.impl.WorkExecutionIndexManagerContext;
import org.hibernate.search.backend.lucene.work.impl.LuceneWorkFactory;
import org.hibernate.search.engine.backend.mapping.spi.BackendMappingContext;
import org.hibernate.search.engine.backend.session.spi.BackendSessionContext;
import org.hibernate.search.engine.backend.session.spi.DetachedBackendSessionContext;
import org.hibernate.search.engine.backend.work.execution.DocumentCommitStrategy;
import org.hibernate.search.engine.backend.work.execution.DocumentRefreshStrategy;
import org.hibernate.search.engine.backend.work.execution.spi.IndexIndexer;
import org.hibernate.search.engine.backend.work.execution.spi.IndexIndexingPlan;
import org.hibernate.search.engine.backend.work.execution.spi.IndexWorkspace;
import org.hibernate.search.engine.environment.thread.spi.ThreadPoolProvider;
import org.hibernate.search.engine.reporting.FailureHandler;
import org.hibernate.search.engine.reporting.spi.EventContexts;
import org.hibernate.search.engine.search.loading.context.spi.LoadingContextBuilder;
import org.hibernate.search.util.common.impl.SuppressingCloser;
import org.hibernate.search.util.common.reporting.EventContext;

public class IndexManagerBackendContext
implements WorkExecutionBackendContext,
SearchBackendContext {
    private final EventContext eventContext;
    private final DirectoryProvider directoryProvider;
    private final LuceneWorkFactory workFactory;
    private final MultiTenancyStrategy multiTenancyStrategy;
    private final LuceneAnalysisDefinitionRegistry analysisDefinitionRegistry;
    private final ThreadPoolProvider threadPoolProvider;
    private final FailureHandler failureHandler;
    private final LuceneReadWorkOrchestrator readOrchestrator;

    public IndexManagerBackendContext(EventContext eventContext, DirectoryProvider directoryProvider, LuceneWorkFactory workFactory, MultiTenancyStrategy multiTenancyStrategy, LuceneAnalysisDefinitionRegistry analysisDefinitionRegistry, ThreadPoolProvider threadPoolProvider, FailureHandler failureHandler, LuceneReadWorkOrchestrator readOrchestrator) {
        this.eventContext = eventContext;
        this.directoryProvider = directoryProvider;
        this.multiTenancyStrategy = multiTenancyStrategy;
        this.analysisDefinitionRegistry = analysisDefinitionRegistry;
        this.workFactory = workFactory;
        this.threadPoolProvider = threadPoolProvider;
        this.failureHandler = failureHandler;
        this.readOrchestrator = readOrchestrator;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this.eventContext + "]";
    }

    @Override
    public IndexIndexingPlan<LuceneRootDocumentBuilder> createIndexingPlan(WorkExecutionIndexManagerContext indexManagerContext, LuceneIndexEntryFactory indexEntryFactory, BackendSessionContext sessionContext, DocumentCommitStrategy commitStrategy, DocumentRefreshStrategy refreshStrategy) {
        this.multiTenancyStrategy.checkTenantId(sessionContext.getTenantIdentifier(), this.eventContext);
        return new LuceneIndexIndexingPlan(this.workFactory, indexManagerContext, indexEntryFactory, sessionContext, commitStrategy, refreshStrategy);
    }

    @Override
    public IndexIndexer<LuceneRootDocumentBuilder> createIndexer(WorkExecutionIndexManagerContext indexManagerContext, LuceneIndexEntryFactory indexEntryFactory, BackendSessionContext sessionContext, DocumentCommitStrategy commitStrategy) {
        this.multiTenancyStrategy.checkTenantId(sessionContext.getTenantIdentifier(), this.eventContext);
        return new LuceneIndexIndexer(this.workFactory, indexEntryFactory, indexManagerContext, sessionContext, commitStrategy);
    }

    @Override
    public IndexWorkspace createWorkspace(WorkExecutionIndexManagerContext indexManagerContext, DetachedBackendSessionContext sessionContext) {
        this.multiTenancyStrategy.checkTenantId(sessionContext.getTenantIdentifier(), this.eventContext);
        return new LuceneIndexWorkspace(this.workFactory, indexManagerContext, sessionContext);
    }

    @Override
    public LuceneSearchContext createSearchContext(BackendMappingContext mappingContext, LuceneScopeModel scopeModel) {
        return new LuceneSearchContext(mappingContext, this.analysisDefinitionRegistry, this.multiTenancyStrategy, scopeModel);
    }

    @Override
    public <H> LuceneSearchQueryBuilder<H> createSearchQueryBuilder(LuceneSearchContext searchContext, BackendSessionContext sessionContext, LoadingContextBuilder<?, ?> loadingContextBuilder, LuceneSearchProjection<?, H> rootProjection) {
        this.multiTenancyStrategy.checkTenantId(sessionContext.getTenantIdentifier(), this.eventContext);
        LuceneDocumentStoredFieldVisitorBuilder storedFieldFilterBuilder = new LuceneDocumentStoredFieldVisitorBuilder();
        rootProjection.contributeFields(storedFieldFilterBuilder);
        return new LuceneSearchQueryBuilder<H>(this.workFactory, this.readOrchestrator, searchContext, sessionContext, storedFieldFilterBuilder.build(), loadingContextBuilder, rootProjection);
    }

    EventContext getEventContext() {
        return this.eventContext;
    }

    LuceneIndexEntryFactory createLuceneIndexEntryFactory(String indexName, FacetsConfig facetsConfig) {
        return new LuceneIndexEntryFactory(this.multiTenancyStrategy, indexName, facetsConfig);
    }

    Shard createShard(LuceneIndexModel model, Optional<String> shardId) {
        LuceneWriteWorkOrchestratorImplementor writeOrchestrator = null;
        IndexAccessor indexAccessor = null;
        try {
            indexAccessor = this.createIndexAccessor(model.getIndexName(), shardId, (Analyzer)model.getScopedAnalyzer());
            writeOrchestrator = this.createWriteOrchestrator(indexAccessor);
            return new Shard(this.workFactory, indexAccessor, writeOrchestrator);
        }
        catch (RuntimeException e) {
            new SuppressingCloser((Throwable)e).push((AutoCloseable)indexAccessor);
            throw e;
        }
    }

    private IndexAccessor createIndexAccessor(String indexName, Optional<String> shardId, Analyzer analyzer) {
        DirectoryCreationContextImpl context = new DirectoryCreationContextImpl(shardId.isPresent() ? EventContexts.fromShardId((String)shardId.get()) : null, indexName, shardId);
        DirectoryHolder directoryHolder = this.directoryProvider.createDirectoryHolder(context);
        try {
            return new IndexAccessor(indexName, EventContexts.fromIndexNameAndShardId((String)indexName, shardId), directoryHolder, analyzer, this.threadPoolProvider.getThreadProvider(), this.failureHandler);
        }
        catch (RuntimeException e) {
            new SuppressingCloser((Throwable)e).push((AutoCloseable)directoryHolder);
            throw e;
        }
    }

    private LuceneWriteWorkOrchestratorImplementor createWriteOrchestrator(IndexAccessor indexAccessor) {
        EventContext indexEventContext = indexAccessor.getIndexEventContext();
        return new LuceneBatchingWriteWorkOrchestrator("Lucene write work orchestrator for " + indexEventContext.render(), new LuceneWriteWorkProcessor(indexAccessor.getIndexName(), indexEventContext, indexAccessor.getIndexWriterDelegator(), this.failureHandler), this.threadPoolProvider, this.failureHandler);
    }
}

