/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.index.impl;

import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import org.hibernate.search.backend.lucene.document.impl.LuceneIndexEntryFactory;
import org.hibernate.search.backend.lucene.document.impl.LuceneRootDocumentBuilder;
import org.hibernate.search.backend.lucene.document.model.impl.LuceneIndexModel;
import org.hibernate.search.backend.lucene.index.LuceneIndexManager;
import org.hibernate.search.backend.lucene.index.impl.IndexManagerBackendContext;
import org.hibernate.search.backend.lucene.index.impl.LuceneIndexScopeBuilder;
import org.hibernate.search.backend.lucene.index.impl.Shard;
import org.hibernate.search.backend.lucene.index.impl.ShardHolder;
import org.hibernate.search.backend.lucene.logging.impl.Log;
import org.hibernate.search.backend.lucene.lowlevel.reader.spi.IndexReaderHolder;
import org.hibernate.search.backend.lucene.scope.model.impl.LuceneScopeIndexManagerContext;
import org.hibernate.search.engine.backend.index.IndexManager;
import org.hibernate.search.engine.backend.index.spi.IndexManagerImplementor;
import org.hibernate.search.engine.backend.index.spi.IndexManagerStartContext;
import org.hibernate.search.engine.backend.mapping.spi.BackendMappingContext;
import org.hibernate.search.engine.backend.scope.spi.IndexScopeBuilder;
import org.hibernate.search.engine.backend.session.spi.BackendSessionContext;
import org.hibernate.search.engine.backend.session.spi.DetachedBackendSessionContext;
import org.hibernate.search.engine.backend.work.execution.DocumentCommitStrategy;
import org.hibernate.search.engine.backend.work.execution.DocumentRefreshStrategy;
import org.hibernate.search.engine.backend.work.execution.spi.IndexIndexer;
import org.hibernate.search.engine.backend.work.execution.spi.IndexIndexingPlan;
import org.hibernate.search.engine.backend.work.execution.spi.IndexWorkspace;
import org.hibernate.search.engine.reporting.spi.EventContexts;
import org.hibernate.search.util.common.impl.Closer;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;
import org.hibernate.search.util.common.reporting.EventContext;

public class LuceneIndexManagerImpl
implements IndexManagerImplementor<LuceneRootDocumentBuilder>,
LuceneIndexManager,
LuceneScopeIndexManagerContext {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    private final IndexManagerBackendContext backendContext;
    private final String indexName;
    private final LuceneIndexModel model;
    private final LuceneIndexEntryFactory indexEntryFactory;
    private final ShardHolder shardHolder;

    LuceneIndexManagerImpl(IndexManagerBackendContext backendContext, String indexName, LuceneIndexModel model, LuceneIndexEntryFactory indexEntryFactory) {
        this.backendContext = backendContext;
        this.indexName = indexName;
        this.model = model;
        this.indexEntryFactory = indexEntryFactory;
        this.shardHolder = new ShardHolder(backendContext, model);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + "name=" + this.indexName + "]";
    }

    public CompletableFuture<?> start(IndexManagerStartContext context) {
        return this.shardHolder.start(context);
    }

    public CompletableFuture<?> preStop() {
        return this.shardHolder.preStop();
    }

    public void stop() {
        try (Closer closer = new Closer();){
            closer.push(ShardHolder::stop, (Object)this.shardHolder);
            closer.push(LuceneIndexModel::close, (Object)this.model);
        }
        catch (IOException | RuntimeException e) {
            throw log.failedToShutdownBackend(e, this.getBackendAndIndexEventContext());
        }
    }

    public IndexIndexingPlan<LuceneRootDocumentBuilder> createIndexingPlan(BackendSessionContext sessionContext, DocumentCommitStrategy commitStrategy, DocumentRefreshStrategy refreshStrategy) {
        return this.backendContext.createIndexingPlan(this.shardHolder, this.indexEntryFactory, sessionContext, commitStrategy, refreshStrategy);
    }

    public IndexIndexer<LuceneRootDocumentBuilder> createIndexer(BackendSessionContext sessionContext, DocumentCommitStrategy commitStrategy) {
        return this.backendContext.createIndexer(this.shardHolder, this.indexEntryFactory, sessionContext, commitStrategy);
    }

    public IndexWorkspace createWorkspace(DetachedBackendSessionContext sessionContext) {
        return this.backendContext.createWorkspace(this.shardHolder, sessionContext);
    }

    public IndexScopeBuilder createScopeBuilder(BackendMappingContext mappingContext) {
        return new LuceneIndexScopeBuilder(this.backendContext, mappingContext, this);
    }

    public void addTo(IndexScopeBuilder builder) {
        if (!(builder instanceof LuceneIndexScopeBuilder)) {
            throw log.cannotMixLuceneScopeWithOtherType(builder, this, this.backendContext.getEventContext());
        }
        LuceneIndexScopeBuilder luceneBuilder = (LuceneIndexScopeBuilder)builder;
        luceneBuilder.add(this.backendContext, this);
    }

    @Override
    public void openIndexReaders(Set<String> routingKeys, Collection<IndexReaderHolder> readerCollector) throws IOException {
        this.shardHolder.openIndexReaders(routingKeys, readerCollector);
    }

    public IndexManager toAPI() {
        return this;
    }

    public <T> T unwrap(Class<T> clazz) {
        if (clazz.isAssignableFrom(LuceneIndexManager.class)) {
            return (T)this;
        }
        throw log.indexManagerUnwrappingWithUnknownType(clazz, LuceneIndexManager.class, this.getBackendAndIndexEventContext());
    }

    public final List<Shard> getShardsForTests() {
        return this.shardHolder.getShardsForTests();
    }

    LuceneIndexModel getModel() {
        return this.model;
    }

    private EventContext getBackendAndIndexEventContext() {
        return this.backendContext.getEventContext().append(EventContexts.fromIndexName((String)this.indexName));
    }
}

