/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.logging.impl;

import java.io.IOException;
import java.io.Serializable;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import org.apache.lucene.search.Query;
import org.apache.lucene.util.Version;
import org.hibernate.search.backend.lucene.index.LuceneIndexManager;
import org.hibernate.search.backend.lucene.logging.impl.Log;
import org.hibernate.search.backend.lucene.types.aggregation.impl.LuceneFieldAggregationBuilderFactory;
import org.hibernate.search.backend.lucene.types.predicate.impl.LuceneFieldPredicateBuilderFactory;
import org.hibernate.search.backend.lucene.types.projection.impl.LuceneFieldProjectionBuilderFactory;
import org.hibernate.search.backend.lucene.types.sort.impl.LuceneFieldSortBuilderFactory;
import org.hibernate.search.engine.backend.scope.spi.IndexScopeBuilder;
import org.hibernate.search.engine.backend.types.converter.spi.ToDocumentIdentifierValueConverter;
import org.hibernate.search.engine.logging.spi.AggregationKeyFormatter;
import org.hibernate.search.engine.search.aggregation.AggregationKey;
import org.hibernate.search.engine.search.aggregation.SearchAggregation;
import org.hibernate.search.engine.search.predicate.SearchPredicate;
import org.hibernate.search.engine.search.projection.SearchProjection;
import org.hibernate.search.engine.search.sort.SearchSort;
import org.hibernate.search.util.common.SearchException;
import org.hibernate.search.util.common.logging.impl.ClassFormatter;
import org.hibernate.search.util.common.logging.impl.EventContextFormatter;
import org.hibernate.search.util.common.reporting.EventContext;
import org.jboss.logging.BasicLogger;
import org.jboss.logging.DelegatingBasicLogger;
import org.jboss.logging.Logger;

public class Log_$logger
extends DelegatingBasicLogger
implements Log,
BasicLogger,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final String FQCN = Log_$logger.class.getName();
    private static final Locale LOCALE = Locale.ROOT;

    public Log_$logger(Logger log) {
        super(log);
    }

    protected Locale getLoggingLocale() {
        return LOCALE;
    }

    @Override
    public final void interruptedWhileWaitingForIndexActivity(String name, InterruptedException e) {
        this.log.logf(FQCN, Logger.Level.WARN, (Throwable)e, this.interruptedWhileWaitingForIndexActivity$str(), (Object)name);
    }

    protected String interruptedWhileWaitingForIndexActivity$str() {
        return "HSEARCH000049: '%s' was interrupted while waiting for index activity to finish. Index might be inconsistent or have a stale lock";
    }

    @Override
    public final void forcingReleaseIndexWriterLock(EventContext context) {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.forcingReleaseIndexWriterLock$str(), (Object)new EventContextFormatter(context));
    }

    protected String forcingReleaseIndexWriterLock$str() {
        return "HSEARCH000052: Going to force release of the IndexWriter lock. %1$s";
    }

    @Override
    public final void unableToCloseIndexReader(EventContext context, Exception e) {
        this.log.logf(FQCN, Logger.Level.WARN, (Throwable)e, this.unableToCloseIndexReader$str(), (Object)new EventContextFormatter(context));
    }

    protected String unableToCloseIndexReader$str() {
        return "HSEARCH000055: Unable to close the index reader. %1$s";
    }

    @Override
    public final void recommendConfiguringLuceneVersion(String key, Version latest, EventContext context) {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.recommendConfiguringLuceneVersion$str(), (Object)key, (Object)latest, (Object)new EventContextFormatter(context));
    }

    protected String recommendConfiguringLuceneVersion$str() {
        return "HSEARCH000075: Configuration setting '%1$s' was not specified: using LATEST (currently '%2$s'). %3$s";
    }

    protected String unableToLoadResource$str() {
        return "HSEARCH000114: Could not load resource: '%1$s'";
    }

    @Override
    public final SearchException unableToLoadResource(String fileName) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.unableToLoadResource$str(), fileName));
        Log_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    private static void _copyStackTraceMinusOne(Throwable e) {
        StackTraceElement[] st = e.getStackTrace();
        e.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
    }

    protected String indexMergeOperation$str() {
        return "HSEARCH000118: Index Merge operation";
    }

    @Override
    public final String indexMergeOperation() {
        return String.format(this.getLoggingLocale(), this.indexMergeOperation$str(), new Object[0]);
    }

    @Override
    public final void lockingFailureDuringInitialization(String directoryDescription, EventContext context) {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.lockingFailureDuringInitialization$str(), (Object)directoryDescription);
    }

    protected String lockingFailureDuringInitialization$str() {
        return "HSEARCH000225: An index locking error occurred during initialization of Directory '%s'. This might indicate a concurrent initialization; If you experience errors on this index you might need to remove the lock, or rebuild the index.";
    }

    protected String illegalLuceneVersionFormat$str() {
        return "HSEARCH000228: Value '%1$ss' is not in a valid format to express a Lucene version: %2$s";
    }

    @Override
    public final SearchException illegalLuceneVersionFormat(String property, String luceneErrorMessage, Exception e) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.illegalLuceneVersionFormat$str(), property, luceneErrorMessage), (Throwable)e);
        Log_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String errorDuringFacetingIndexing$str() {
        return "HSEARCH000265: Unable to build Lucene Document due to facet indexing error";
    }

    @Override
    public final SearchException errorDuringFacetingIndexing(Exception e) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.errorDuringFacetingIndexing$str(), new Object[0]), (Throwable)e);
        Log_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String failureOnMultiReaderRefresh$str() {
        return "HSEARCH000284: An exception occurred while opening multiple indexes.";
    }

    @Override
    public final SearchException failureOnMultiReaderRefresh(EventContext context, Exception e) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.failureOnMultiReaderRefresh$str(), new Object[0]), (Throwable)e, context);
        Log_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String couldNotNormalizeField$str() {
        return "HSEARCH000320: Could not normalize value for field '%1$s'.";
    }

    @Override
    public final SearchException couldNotNormalizeField(String absoluteFieldPath, Exception cause) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.couldNotNormalizeField$str(), absoluteFieldPath), (Throwable)cause);
        Log_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    @Override
    public final void multipleTermsDetectedDuringNormalization(String absoluteFieldPath) {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.multipleTermsDetectedDuringNormalization$str(), (Object)absoluteFieldPath);
    }

    protected String multipleTermsDetectedDuringNormalization$str() {
        return "HSEARCH000321: The analysis of field '%1$s' produced multiple tokens. Tokenization or term generation (synonyms) should not be used on sortable fields or range queries. Only the first token will be considered.";
    }

    protected String unableToApplyAnalysisConfiguration$str() {
        return "HSEARCH000329: Error while applying analysis configuration: %1$s";
    }

    @Override
    public final SearchException unableToApplyAnalysisConfiguration(String errorMessage, Exception e) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.unableToApplyAnalysisConfiguration$str(), errorMessage), (Throwable)e);
        Log_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String analyzerDefinitionNamingConflict$str() {
        return "HSEARCH000330: Multiple analyzer definitions with the same name: '%1$s'. The analyzer names must be unique.";
    }

    @Override
    public final SearchException analyzerDefinitionNamingConflict(String analyzerDefinitionName) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.analyzerDefinitionNamingConflict$str(), analyzerDefinitionName));
        Log_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String analysisComponentParameterConflict$str() {
        return "HSEARCH000337: Multiple parameters with the same name: '%1$s'. Can't assign both value '%2$s' and '%3$s'";
    }

    @Override
    public final SearchException analysisComponentParameterConflict(String name, String value1, String value2) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.analysisComponentParameterConflict$str(), name, value1, value2));
        Log_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String normalizerDefinitionNamingConflict$str() {
        return "HSEARCH000341: Multiple normalizer definitions with the same name: '%1$s'. The normalizer names must be unique.";
    }

    @Override
    public final SearchException normalizerDefinitionNamingConflict(String normalizerDefinitionName) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.normalizerDefinitionNamingConflict$str(), normalizerDefinitionName));
        Log_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String cannotApplyAnalyzerAndNormalizer$str() {
        return "HSEARCH000342: Cannot apply both an analyzer and a normalizer. Analyzer: '%1$s', normalizer: '%2$s'.";
    }

    @Override
    public final SearchException cannotApplyAnalyzerAndNormalizer(String analyzerName, String normalizerName, EventContext context) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.cannotApplyAnalyzerAndNormalizer$str(), analyzerName, normalizerName), context);
        Log_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    @Override
    public final void normalizerProducedMultipleTokens(String normalizerName, int token) {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.normalizerProducedMultipleTokens$str(), (Object)normalizerName, (Object)token);
    }

    protected String normalizerProducedMultipleTokens$str() {
        return "HSEARCH000344: The normalizer for definition '%s' produced %d tokens. Normalizers should never produce more than one token. The tokens have been concatenated by Hibernate Search, but you should fix your normalizer definition.";
    }

    protected String cannotUseAnalyzerOnSortableField$str() {
        return "HSEARCH000345: Cannot apply an analyzer on a sortable field. Use a normalizer instead. Analyzer: '%1$s'. If an actual analyzer (with tokenization) is necessary, define two separate fields: one with an analyzer that is not sortable, and one with a normalizer that is sortable.";
    }

    @Override
    public final SearchException cannotUseAnalyzerOnSortableField(String analyzerName, EventContext context) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.cannotUseAnalyzerOnSortableField$str(), analyzerName), context);
        Log_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String unknownAnalyzer$str() {
        return "HSEARCH000353: Unknown analyzer: '%1$s'. Make sure you defined this analyzer.";
    }

    @Override
    public final SearchException unknownAnalyzer(String analyzerName, EventContext context) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.unknownAnalyzer$str(), analyzerName), context);
        Log_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String unknownFieldForSearch$str() {
        return "HSEARCH600000: Unknown field '%1$s'.";
    }

    @Override
    public final SearchException unknownFieldForSearch(String absoluteFieldPath, EventContext context) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.unknownFieldForSearch$str(), absoluteFieldPath), context);
        Log_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String pathIsNotWriteableDirectory$str() {
        return "HSEARCH600001: Path '%1$s' exists but does not point to a writable directory.";
    }

    @Override
    public final SearchException pathIsNotWriteableDirectory(Path rootDirectory) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.pathIsNotWriteableDirectory$str(), rootDirectory));
        Log_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String unableToInitializeRootDirectory$str() {
        return "HSEARCH600002: Unable to initialize root directory '%1$s': %2$s";
    }

    @Override
    public final SearchException unableToInitializeRootDirectory(Path rootDirectory, String causeMessage, Exception cause) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.unableToInitializeRootDirectory$str(), rootDirectory, causeMessage), (Throwable)cause);
        Log_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String luceneExtensionOnUnknownType$str() {
        return "HSEARCH600005: The Lucene extension can only be applied to objects derived from the Lucene backend. Was applied to '%1$s' instead.";
    }

    @Override
    public final SearchException luceneExtensionOnUnknownType(Object context) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.luceneExtensionOnUnknownType$str(), context));
        Log_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String cannotMixLuceneSearchQueryWithOtherPredicates$str() {
        return "HSEARCH600010: A Lucene query cannot include search predicates built using a non-Lucene search scope. Given predicate was: '%1$s'";
    }

    @Override
    public final SearchException cannotMixLuceneSearchQueryWithOtherPredicates(SearchPredicate predicate) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.cannotMixLuceneSearchQueryWithOtherPredicates$str(), predicate));
        Log_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String nonObjectFieldForNestedQuery$str() {
        return "HSEARCH600012: Field '%1$s' is not an object field.";
    }

    @Override
    public final SearchException nonObjectFieldForNestedQuery(String absoluteFieldPath, EventContext context) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.nonObjectFieldForNestedQuery$str(), absoluteFieldPath), context);
        Log_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String nonNestedFieldForNestedQuery$str() {
        return "HSEARCH600013: Object field '%1$s' is not stored as nested.";
    }

    @Override
    public final SearchException nonNestedFieldForNestedQuery(String absoluteFieldPath, EventContext context) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.nonNestedFieldForNestedQuery$str(), absoluteFieldPath), context);
        Log_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String cannotMixLuceneSearchSortWithOtherSorts$str() {
        return "HSEARCH600014: A Lucene query cannot include search sorts built using a non-Lucene search scope. Given sort was: '%1$s'";
    }

    @Override
    public final SearchException cannotMixLuceneSearchSortWithOtherSorts(SearchSort sort) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.cannotMixLuceneSearchSortWithOtherSorts$str(), sort));
        Log_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String unableToInitializeIndexDirectory$str() {
        return "HSEARCH600015: Unable to initialize index directory: %1$s";
    }

    @Override
    public final SearchException unableToInitializeIndexDirectory(String causeMessage, EventContext context, Exception cause) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.unableToInitializeIndexDirectory$str(), causeMessage), (Throwable)cause, context);
        Log_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String unableToIndexEntry$str() {
        return "HSEARCH600016: Unable to index entry '%2$s' with tenant identifier '%1$s'.";
    }

    @Override
    public final SearchException unableToIndexEntry(String tenantId, String id, EventContext context, Exception e) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.unableToIndexEntry$str(), tenantId, id), (Throwable)e, context);
        Log_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String unableToDeleteEntryFromIndex$str() {
        return "HSEARCH600017: Unable to delete entry '%2$s' with tenant identifier '%1$s'.";
    }

    @Override
    public final SearchException unableToDeleteEntryFromIndex(String tenantId, String id, EventContext context, Exception e) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.unableToDeleteEntryFromIndex$str(), tenantId, id), (Throwable)e, context);
        Log_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String unableToFlushIndex$str() {
        return "HSEARCH600018: Unable to flush.";
    }

    @Override
    public final SearchException unableToFlushIndex(EventContext context, Exception e) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.unableToFlushIndex$str(), new Object[0]), (Throwable)e, context);
        Log_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String unableToCommitIndex$str() {
        return "HSEARCH600019: Unable to commit.";
    }

    @Override
    public final SearchException unableToCommitIndex(EventContext context, Exception e) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.unableToCommitIndex$str(), new Object[0]), (Throwable)e, context);
        Log_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String unableToCreateIndexReader$str() {
        return "HSEARCH600022: Could not open an index reader.";
    }

    @Override
    public final SearchException unableToCreateIndexReader(EventContext context, Exception e) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.unableToCreateIndexReader$str(), new Object[0]), (Throwable)e, context);
        Log_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String cannotMixLuceneScopeWithOtherType$str() {
        return "HSEARCH600024: A multi-index scope cannot include both a Lucene index and another type of index. Base scope was: '%1$s', Lucene index was: '%2$s'";
    }

    @Override
    public final SearchException cannotMixLuceneScopeWithOtherType(IndexScopeBuilder baseScope, LuceneIndexManager luceneIndex, EventContext context) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.cannotMixLuceneScopeWithOtherType$str(), baseScope, luceneIndex), context);
        Log_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String cannotMixLuceneScopeWithOtherBackend$str() {
        return "HSEARCH600025: A multi-index scope cannot span multiple Lucene backends. Base scope was: '%1$s', index from another backend was: '%2$s'";
    }

    @Override
    public final SearchException cannotMixLuceneScopeWithOtherBackend(IndexScopeBuilder baseScope, LuceneIndexManager indexFromOtherBackend, EventContext context) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.cannotMixLuceneScopeWithOtherBackend$str(), baseScope, indexFromOtherBackend), context);
        Log_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String ioExceptionOnQueryExecution$str() {
        return "HSEARCH600027: An IOException happened while executing the query '%1$s'.";
    }

    @Override
    public final SearchException ioExceptionOnQueryExecution(Query luceneQuery, EventContext context, IOException e) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.ioExceptionOnQueryExecution$str(), luceneQuery), (Throwable)e, context);
        Log_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String multiTenancyRequiredButNotSupportedByBackend$str() {
        return "HSEARCH600029: Index '%1$s' requires multi-tenancy but the backend does not support it in its current configuration.";
    }

    @Override
    public final SearchException multiTenancyRequiredButNotSupportedByBackend(String indexName, EventContext context) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.multiTenancyRequiredButNotSupportedByBackend$str(), indexName), context);
        Log_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String invalidMultiTenancyStrategyName$str() {
        return "HSEARCH600030: Invalid multi-tenancy strategy name: '%1$s'. Valid names are: %2$s.";
    }

    @Override
    public final SearchException invalidMultiTenancyStrategyName(String invalidRepresentation, List<String> validRepresentations) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.invalidMultiTenancyStrategyName$str(), invalidRepresentation, validRepresentations));
        Log_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String tenantIdProvidedButMultiTenancyDisabled$str() {
        return "HSEARCH600031: Tenant identifier '%1$s' is provided, but multi-tenancy is disabled for this backend.";
    }

    @Override
    public final SearchException tenantIdProvidedButMultiTenancyDisabled(String tenantId, EventContext context) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.tenantIdProvidedButMultiTenancyDisabled$str(), tenantId), context);
        Log_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String multiTenancyEnabledButNoTenantIdProvided$str() {
        return "HSEARCH600032: Backend has multi-tenancy enabled, but no tenant identifier is provided.";
    }

    @Override
    public final SearchException multiTenancyEnabledButNoTenantIdProvided(EventContext context) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.multiTenancyEnabledButNoTenantIdProvided$str(), new Object[0]), context);
        Log_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String backendUnwrappingWithUnknownType$str() {
        return "HSEARCH600033: Attempt to unwrap a Lucene backend to '%1$s', but this backend can only be unwrapped to '%2$s'.";
    }

    @Override
    public final SearchException backendUnwrappingWithUnknownType(Class<?> requestedClass, Class<?> actualClass, EventContext context) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.backendUnwrappingWithUnknownType$str(), new ClassFormatter(requestedClass), new ClassFormatter(actualClass)), context);
        Log_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String indexSchemaNodeNameConflict$str() {
        return "HSEARCH600034: The index schema node '%1$s' was added twice. Multiple bridges may be trying to access the same index field,  or two indexed-embeddeds may have prefixes that lead to conflicting field names, or you may have declared multiple conflicting mappings. In any case, there is something wrong with your mapping and you should fix it.";
    }

    @Override
    public final SearchException indexSchemaNodeNameConflict(String relativeFieldName, EventContext context) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.indexSchemaNodeNameConflict$str(), relativeFieldName), context);
        Log_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String rangesNotSupportedByGeoPoint$str() {
        return "HSEARCH600037: Range lookups (range predicates, range aggregations) are not supported by this field's type (GeoPoint). Use spatial features instead.";
    }

    @Override
    public final SearchException rangesNotSupportedByGeoPoint(EventContext context) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.rangesNotSupportedByGeoPoint$str(), new Object[0]), context);
        Log_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String directValueLookupNotSupportedByGeoPoint$str() {
        return "HSEARCH600038: Direct value lookups (match predicates, terms aggregations) are not supported by this field's type (GeoPoint). Use spatial features instead.";
    }

    @Override
    public final SearchException directValueLookupNotSupportedByGeoPoint(EventContext context) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.directValueLookupNotSupportedByGeoPoint$str(), new Object[0]), context);
        Log_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String invalidFieldForDocumentElement$str() {
        return "HSEARCH600039: Invalid field reference for this document element: this document element has path '%1$s', but the referenced field has a parent with path '%2$s'.";
    }

    @Override
    public final SearchException invalidFieldForDocumentElement(String expectedPath, String actualPath) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.invalidFieldForDocumentElement$str(), expectedPath, actualPath));
        Log_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String spatialPredicatesNotSupportedByFieldType$str() {
        return "HSEARCH600040: Spatial predicates are not supported by this field's type.";
    }

    @Override
    public final SearchException spatialPredicatesNotSupportedByFieldType(EventContext context) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.spatialPredicatesNotSupportedByFieldType$str(), new Object[0]), context);
        Log_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String distanceOperationsNotSupportedByFieldType$str() {
        return "HSEARCH600041: Distance related operations are not supported by this field's type.";
    }

    @Override
    public final SearchException distanceOperationsNotSupportedByFieldType(EventContext context) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.distanceOperationsNotSupportedByFieldType$str(), new Object[0]), context);
        Log_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String traditionalSortNotSupportedByGeoPoint$str() {
        return "HSEARCH600042: Traditional sorting operations are not supported by the GeoPoint field type, use distance sorting instead.";
    }

    @Override
    public final SearchException traditionalSortNotSupportedByGeoPoint(EventContext context) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.traditionalSortNotSupportedByGeoPoint$str(), new Object[0]), context);
        Log_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String minimumShouldMatchMinimumOutOfBounds$str() {
        return "HSEARCH600044: Computed minimum for minimumShouldMatch constraint is out of bounds: expected a number between '1' and '%1$s', got '%2$s'.";
    }

    @Override
    public final SearchException minimumShouldMatchMinimumOutOfBounds(int totalShouldClauseNumber, int minimum) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.minimumShouldMatchMinimumOutOfBounds$str(), totalShouldClauseNumber, minimum));
        Log_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String minimumShouldMatchConflictingConstraints$str() {
        return "HSEARCH600045: Multiple conflicting minimumShouldMatch constraints for ceiling '%1$s'";
    }

    @Override
    public final SearchException minimumShouldMatchConflictingConstraints(int ignoreConstraintCeiling) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.minimumShouldMatchConflictingConstraints$str(), ignoreConstraintCeiling));
        Log_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String unsupportedDSLPredicates$str() {
        return "HSEARCH600046: Native fields do not support defining predicates with the DSL: use the Lucene extension and a native query.";
    }

    @Override
    public final SearchException unsupportedDSLPredicates(EventContext context) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.unsupportedDSLPredicates$str(), new Object[0]), context);
        Log_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String unsupportedDSLSorts$str() {
        return "HSEARCH600047: Native fields do not support defining sorts with the DSL: use the Lucene extension and a native sort.";
    }

    @Override
    public final SearchException unsupportedDSLSorts(EventContext context) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.unsupportedDSLSorts$str(), new Object[0]), context);
        Log_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String unsupportedProjection$str() {
        return "HSEARCH600048: This native field does not support projection.";
    }

    @Override
    public final SearchException unsupportedProjection(EventContext context) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.unsupportedProjection$str(), new Object[0]), context);
        Log_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String invalidFieldPath$str() {
        return "HSEARCH600049: Invalid field path; expected path '%1$s', got '%2$s'.";
    }

    @Override
    public final SearchException invalidFieldPath(String expectedPath, String actualPath) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.invalidFieldPath$str(), expectedPath, actualPath));
        Log_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String cannotConvertDslParameter$str() {
        return "HSEARCH600050: Unable to convert DSL parameter: %1$s";
    }

    @Override
    public final SearchException cannotConvertDslParameter(String errorMessage, Exception cause, EventContext context) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.cannotConvertDslParameter$str(), errorMessage), (Throwable)cause, context);
        Log_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String indexManagerUnwrappingWithUnknownType$str() {
        return "HSEARCH600051: Attempt to unwrap a Lucene index manager to '%1$s', but this index manager can only be unwrapped to '%2$s'.";
    }

    @Override
    public final SearchException indexManagerUnwrappingWithUnknownType(Class<?> requestedClass, Class<?> actualClass, EventContext context) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.indexManagerUnwrappingWithUnknownType$str(), new ClassFormatter(requestedClass), new ClassFormatter(actualClass)), context);
        Log_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String unableToCreateAnalyzer$str() {
        return "HSEARCH600052: Unable to create analyzer for name '%1$s'.";
    }

    @Override
    public final SearchException unableToCreateAnalyzer(String name, Exception e) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.unableToCreateAnalyzer$str(), name), (Throwable)e);
        Log_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String unableToCreateNormalizer$str() {
        return "HSEARCH600053: Unable to create normalizer for name '%1$s'.";
    }

    @Override
    public final SearchException unableToCreateNormalizer(String name, Exception e) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.unableToCreateNormalizer$str(), name), (Throwable)e);
        Log_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String unknownNormalizer$str() {
        return "HSEARCH600054: Unknown normalizer: '%1$s'. Make sure you defined this normalizer.";
    }

    @Override
    public final SearchException unknownNormalizer(String normalizerName, EventContext context) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.unknownNormalizer$str(), normalizerName), context);
        Log_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String cannotMixLuceneSearchQueryWithOtherProjections$str() {
        return "HSEARCH600055: A Lucene query cannot include search projections built using a non-Lucene search scope. Given projection was: '%1$s'";
    }

    @Override
    public final SearchException cannotMixLuceneSearchQueryWithOtherProjections(SearchProjection<?> projection) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.cannotMixLuceneSearchQueryWithOtherProjections$str(), projection));
        Log_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String invalidProjectionInvalidType$str() {
        return "HSEARCH600056: Invalid type '%2$s' for projection on field '%1$s'.";
    }

    @Override
    public final SearchException invalidProjectionInvalidType(String absoluteFieldPath, Class<?> type, EventContext context) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.invalidProjectionInvalidType$str(), absoluteFieldPath, new ClassFormatter(type)), context);
        Log_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String unsupportedDSLProjections$str() {
        return "HSEARCH600057: This field does not support projections.";
    }

    @Override
    public final SearchException unsupportedDSLProjections(EventContext context) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.unsupportedDSLProjections$str(), new Object[0]), context);
        Log_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String conflictingFieldTypesForPredicate$str() {
        return "HSEARCH600058: Multiple conflicting types to build a predicate for field '%1$s': '%2$s' vs. '%3$s'.";
    }

    @Override
    public final SearchException conflictingFieldTypesForPredicate(String absoluteFieldPath, LuceneFieldPredicateBuilderFactory component1, LuceneFieldPredicateBuilderFactory component2, EventContext context) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.conflictingFieldTypesForPredicate$str(), absoluteFieldPath, component1, component2), context);
        Log_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String conflictingFieldTypesForSort$str() {
        return "HSEARCH600059: Multiple conflicting types to build a sort for field '%1$s': '%2$s' vs. '%3$s'.";
    }

    @Override
    public final SearchException conflictingFieldTypesForSort(String absoluteFieldPath, LuceneFieldSortBuilderFactory component1, LuceneFieldSortBuilderFactory component2, EventContext context) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.conflictingFieldTypesForSort$str(), absoluteFieldPath, component1, component2), context);
        Log_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String conflictingFieldTypesForProjection$str() {
        return "HSEARCH600060: Multiple conflicting types to build a projection for field '%1$s': '%2$s' vs. '%3$s'.";
    }

    @Override
    public final SearchException conflictingFieldTypesForProjection(String absoluteFieldPath, LuceneFieldProjectionBuilderFactory component1, LuceneFieldProjectionBuilderFactory component2, EventContext context) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.conflictingFieldTypesForProjection$str(), absoluteFieldPath, component1, component2), context);
        Log_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String failedToShutdownBackend$str() {
        return "HSEARCH600061: Failed to shut down the Lucene index manager.";
    }

    @Override
    public final SearchException failedToShutdownBackend(Exception cause, EventContext context) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.failedToShutdownBackend$str(), new Object[0]), (Throwable)cause, context);
        Log_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String cannotGuessFieldType$str() {
        return "HSEARCH600062: Cannot guess field type for input type: '%1$s'.";
    }

    @Override
    public final SearchException cannotGuessFieldType(Class<?> inputType, EventContext context) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.cannotGuessFieldType$str(), new ClassFormatter(inputType)), context);
        Log_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String documentIdNotCollected$str() {
        return "HSEARCH600064: Unexpected index: documentId '%1$s' was not collected.";
    }

    @Override
    public final SearchException documentIdNotCollected(Integer documentId) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.documentIdNotCollected$str(), documentId));
        Log_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String nonProjectableField$str() {
        return "HSEARCH600065: Projections are not enabled for field '%1$s'. Make sure the field is marked as projectable.";
    }

    @Override
    public final SearchException nonProjectableField(String absoluteFieldPath, EventContext context) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.nonProjectableField$str(), absoluteFieldPath), context);
        Log_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String unsortableField$str() {
        return "HSEARCH600066: Sorting is not enabled for field '%1$s'. Make sure the field is marked as sortable.";
    }

    @Override
    public final SearchException unsortableField(String absoluteFieldPath, EventContext context) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.unsortableField$str(), absoluteFieldPath), context);
        Log_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String unableToDeleteAllEntriesFromIndex$str() {
        return "HSEARCH600067: Unable to delete all entries with tenant identifier '%1$s'.";
    }

    @Override
    public final SearchException unableToDeleteAllEntriesFromIndex(String tenantId, EventContext context, Exception e) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.unableToDeleteAllEntriesFromIndex$str(), tenantId), (Throwable)e, context);
        Log_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String conflictingIdentifierTypesForPredicate$str() {
        return "HSEARCH600068: Multiple conflicting types for identifier: '%1$s' vs. '%2$s'.";
    }

    @Override
    public final SearchException conflictingIdentifierTypesForPredicate(ToDocumentIdentifierValueConverter<?> component1, ToDocumentIdentifierValueConverter<?> component2, EventContext context) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.conflictingIdentifierTypesForPredicate$str(), component1, component2), context);
        Log_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String ioExceptionOnExplain$str() {
        return "HSEARCH600069: An IOException occurred while generating an Explanation.";
    }

    @Override
    public final SearchException ioExceptionOnExplain(IOException e) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.ioExceptionOnExplain$str(), new Object[0]), (Throwable)e);
        Log_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String textPredicatesNotSupportedByFieldType$str() {
        return "HSEARCH600070: Text predicates (phrase, fuzzy, wildcard, simple query string) are not supported by this field's type.";
    }

    @Override
    public final SearchException textPredicatesNotSupportedByFieldType(EventContext context) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.textPredicatesNotSupportedByFieldType$str(), new Object[0]), context);
        Log_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String incompleteFieldDefinition$str() {
        return "HSEARCH600071: Incomplete field definition. You must call toReference() to complete the field definition.";
    }

    @Override
    public final SearchException incompleteFieldDefinition(EventContext context) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.incompleteFieldDefinition$str(), new Object[0]), context);
        Log_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String cannotCreateReferenceMultipleTimes$str() {
        return "HSEARCH600072: Multiple calls to toReference() for the same field definition. You must call toReference() exactly once.";
    }

    @Override
    public final SearchException cannotCreateReferenceMultipleTimes(EventContext context) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.cannotCreateReferenceMultipleTimes$str(), new Object[0]), context);
        Log_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String cannotUseIndexNullAsAndAnalyzer$str() {
        return "HSEARCH600073: Index-null-as option is not supported on analyzed field. Trying to define the analyzer: '%1$s' together with index null as: '%2$s'.";
    }

    @Override
    public final SearchException cannotUseIndexNullAsAndAnalyzer(String analyzerName, String indexNullAs, EventContext context) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.cannotUseIndexNullAsAndAnalyzer$str(), analyzerName, indexNullAs), context);
        Log_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String multipleValuesForSingleValuedField$str() {
        return "HSEARCH600074: Multiple values were added to single-valued field '%1$s'. Declare the field as multi-valued in order to allow this.";
    }

    @Override
    public final SearchException multipleValuesForSingleValuedField(String absoluteFieldPath) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.multipleValuesForSingleValuedField$str(), absoluteFieldPath));
        Log_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String explainRequiresIndexName$str() {
        return "HSEARCH600075: explain(String id) cannot be used when the query targets multiple indexes. Use explain(String indexName, String id) and pass one of %1$s as the index name.";
    }

    @Override
    public final SearchException explainRequiresIndexName(Set<String> targetedIndexNames) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.explainRequiresIndexName$str(), targetedIndexNames));
        Log_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String explainRequiresIndexTargetedByQuery$str() {
        return "HSEARCH600076: The given index name '%2$s' is not among the indexes targeted by this query: %1$s.";
    }

    @Override
    public final SearchException explainRequiresIndexTargetedByQuery(Set<String> targetedIndexNames, String indexName) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.explainRequiresIndexTargetedByQuery$str(), targetedIndexNames, indexName));
        Log_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String explainUnkownDocument$str() {
        return "HSEARCH600077: Document with id '%2$s' does not exist in index '%1$s' and thus its match cannot be explained.";
    }

    @Override
    public final SearchException explainUnkownDocument(String indexName, String d) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.explainUnkownDocument$str(), indexName, d));
        Log_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String unableToOptimizeIndex$str() {
        return "HSEARCH600078: Unable to optimize.";
    }

    @Override
    public final SearchException unableToOptimizeIndex(EventContext context, Exception e) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.unableToOptimizeIndex$str(), new Object[0]), (Throwable)e, context);
        Log_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String unableToCleanUpAfterError$str() {
        return "HSEARCH600079: Unable to clean up after write errors.";
    }

    @Override
    public final SearchException unableToCleanUpAfterError(EventContext context, Exception e) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.unableToCleanUpAfterError$str(), new Object[0]), (Throwable)e, context);
        Log_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String nullDecimalScale$str() {
        return "HSEARCH600080: Impossible to detect a decimal scale to use for this field. If the value is bridged, set '.asBigDecimal().decimalScale( int )' in the bind, else verify your mapping.";
    }

    @Override
    public final SearchException nullDecimalScale(EventContext eventContext) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.nullDecimalScale$str(), new Object[0]), eventContext);
        Log_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String scaledNumberTooLarge$str() {
        return "HSEARCH600081: The value '%1$s' cannot be indexed because its absolute value is too large.";
    }

    @Override
    public final SearchException scaledNumberTooLarge(Number value) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.scaledNumberTooLarge$str(), value));
        Log_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String invalidDecimalScale$str() {
        return "HSEARCH600082: Positive decimal scale ['%1$s'] is not allowed for BigInteger fields, since a BigInteger value cannot have any decimal digits.";
    }

    @Override
    public final SearchException invalidDecimalScale(Integer decimalScale, EventContext eventContext) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.invalidDecimalScale$str(), decimalScale), eventContext);
        Log_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String nonSearchableField$str() {
        return "HSEARCH600083: Field '%1$s' is not searchable. Make sure the field is marked as searchable.";
    }

    @Override
    public final SearchException nonSearchableField(String absoluteFieldPath, EventContext context) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.nonSearchableField$str(), absoluteFieldPath), context);
        Log_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String predicateDefinedOnDifferentIndexes$str() {
        return "HSEARCH600084: The predicate '%1$s' is defined on a scope targeting different indexes. Predicate is targeting: '%2$s'. Current scope is targeting: '%3$s'.";
    }

    @Override
    public final SearchException predicateDefinedOnDifferentIndexes(SearchPredicate predicate, Set<String> predicateIndexes, Set<String> scopeIndexes) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.predicateDefinedOnDifferentIndexes$str(), predicate, predicateIndexes, scopeIndexes));
        Log_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String sortDefinedOnDifferentIndexes$str() {
        return "HSEARCH600085: The sort '%1$s' is defined on a scope targeting different indexes. Sort is targeting: '%2$s'. Current scope is targeting: '%3$s'.";
    }

    @Override
    public final SearchException sortDefinedOnDifferentIndexes(SearchSort predicate, Set<String> predicateIndexes, Set<String> scopeIndexes) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.sortDefinedOnDifferentIndexes$str(), predicate, predicateIndexes, scopeIndexes));
        Log_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String projectionDefinedOnDifferentIndexes$str() {
        return "HSEARCH600086: The projection '%1$s' is defined on a scope targeting different indexes. Projection is targeting: '%2$s'. Current scope is targeting: '%3$s'.";
    }

    @Override
    public final SearchException projectionDefinedOnDifferentIndexes(SearchProjection<?> predicate, Set<String> predicateIndexes, Set<String> scopeIndexes) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.projectionDefinedOnDifferentIndexes$str(), predicate, predicateIndexes, scopeIndexes));
        Log_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String invalidFileSystemAccessStrategyName$str() {
        return "HSEARCH600087: Invalid filesystem access strategy name: '%1$s'. Valid names are: %2$s.";
    }

    @Override
    public final SearchException invalidFileSystemAccessStrategyName(String invalidRepresentation, List<String> validRepresentations) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.invalidFileSystemAccessStrategyName$str(), invalidRepresentation, validRepresentations));
        Log_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String invalidLockingStrategyName$str() {
        return "HSEARCH600088: Invalid locking strategy name: '%1$s'. Valid names are: %2$s.";
    }

    @Override
    public final SearchException invalidLockingStrategyName(String invalidRepresentation, List<String> validRepresentations) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.invalidLockingStrategyName$str(), invalidRepresentation, validRepresentations));
        Log_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String missingShardIdentifiersAfterShardingStrategyInitialization$str() {
        return "HSEARCH600089: The sharding strategy '%1$s' is not implemented properly: it must call either context.setShardIdentifiers() or context.setShardingDisabled() in its initialize() method, but it did not.";
    }

    @Override
    public final SearchException missingShardIdentifiersAfterShardingStrategyInitialization(Object strategy) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.missingShardIdentifiersAfterShardingStrategyInitialization$str(), strategy));
        Log_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String missingPropertyValueForShardingStrategy$str() {
        return "HSEARCH600090: Missing value for property '%2$s'. The sharding strategy '%1$s' requires this property to be set.";
    }

    @Override
    public final SearchException missingPropertyValueForShardingStrategy(String strategyName, String propertyKey) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.missingPropertyValueForShardingStrategy$str(), strategyName, propertyKey));
        Log_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String invalidRoutingKeyForExplicitShardingStrategy$str() {
        return "HSEARCH600091: Invalid routing key: '%1$s'. Valid keys are: %2$s.";
    }

    @Override
    public final SearchException invalidRoutingKeyForExplicitShardingStrategy(String invalidKey, Collection<String> validKeys) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.invalidRoutingKeyForExplicitShardingStrategy$str(), invalidKey, validKeys));
        Log_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String errorFetchingNestedDocuments$str() {
        return "HSEARCH600092: Error fetching nested documents. Native Lucene query: '%1$s'.";
    }

    @Override
    public final SearchException errorFetchingNestedDocuments(Query luceneQuery, Exception e) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.errorFetchingNestedDocuments$str(), luceneQuery), (Throwable)e);
        Log_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String conflictingNestedDocumentPathsForProjection$str() {
        return "HSEARCH600093: Multiple conflicting nested document paths to build a projection for field '%1$s'. '%2$s' vs. '%3$s'.";
    }

    @Override
    public final SearchException conflictingNestedDocumentPathsForProjection(String absoluteFieldPath, String nestedDocumentPath1, String nestedDocumentPath2, EventContext context) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.conflictingNestedDocumentPathsForProjection$str(), absoluteFieldPath, nestedDocumentPath1, nestedDocumentPath2), context);
        Log_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String cannotUseAnalyzerOnAggregableField$str() {
        return "HSEARCH600094: Cannot apply an analyzer on an aggregable field. Use a normalizer instead. Analyzer: '%1$s'. If an actual analyzer (with tokenization) is necessary, define two separate fields: one with an analyzer that is not aggregable, and one with a normalizer that is aggregable.";
    }

    @Override
    public final SearchException cannotUseAnalyzerOnAggregableField(String analyzerName, EventContext context) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.cannotUseAnalyzerOnAggregableField$str(), analyzerName), context);
        Log_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String nonAggregableField$str() {
        return "HSEARCH600095: Aggregations are not enabled for field '%1$s'. Make sure the field is marked as aggregable.";
    }

    @Override
    public final SearchException nonAggregableField(String absoluteFieldPath, EventContext context) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.nonAggregableField$str(), absoluteFieldPath), context);
        Log_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String invalidAggregationInvalidType$str() {
        return "HSEARCH600096: Invalid type '%2$s' for aggregation on field '%1$s'.";
    }

    @Override
    public final SearchException invalidAggregationInvalidType(String absoluteFieldPath, Class<?> type, EventContext context) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.invalidAggregationInvalidType$str(), absoluteFieldPath, new ClassFormatter(type)), context);
        Log_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String conflictingFieldTypesForAggregation$str() {
        return "HSEARCH600097: Multiple conflicting types to build an aggregation for field '%1$s': '%2$s' vs. '%3$s'.";
    }

    @Override
    public final SearchException conflictingFieldTypesForAggregation(String absoluteFieldPath, LuceneFieldAggregationBuilderFactory component1, LuceneFieldAggregationBuilderFactory component2, EventContext context) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.conflictingFieldTypesForAggregation$str(), absoluteFieldPath, component1, component2), context);
        Log_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String cannotMixLuceneSearchQueryWithOtherAggregations$str() {
        return "HSEARCH600098: An Lucene query cannot include search aggregations built using a non-Lucene search scope. Given aggregation was: '%1$s'";
    }

    @Override
    public final SearchException cannotMixLuceneSearchQueryWithOtherAggregations(SearchAggregation<?> aggregation) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.cannotMixLuceneSearchQueryWithOtherAggregations$str(), aggregation));
        Log_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String aggregationDefinedOnDifferentIndexes$str() {
        return "HSEARCH600099: The aggregation '%1$s' is defined on a scope targeting different indexes. Aggregation is targeting: '%2$s'. Current scope is targeting: '%3$s'.";
    }

    @Override
    public final SearchException aggregationDefinedOnDifferentIndexes(SearchAggregation<?> aggregation, Set<String> aggregationIndexes, Set<String> scopeIndexes) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.aggregationDefinedOnDifferentIndexes$str(), aggregation, aggregationIndexes, scopeIndexes));
        Log_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String termsAggregationsNotSupportedByAnalyzedTextFieldType$str() {
        return "HSEARCH600100: Terms aggregations are not supported by this field's type (string field with analyzed). Use a normalized field instead.";
    }

    @Override
    public final SearchException termsAggregationsNotSupportedByAnalyzedTextFieldType(EventContext context) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.termsAggregationsNotSupportedByAnalyzedTextFieldType$str(), new Object[0]), context);
        Log_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String rangeAggregationsNotSupportedByFieldType$str() {
        return "HSEARCH600101: Range aggregations are not supported by this field's type.";
    }

    @Override
    public final SearchException rangeAggregationsNotSupportedByFieldType(EventContext context) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.rangeAggregationsNotSupportedByFieldType$str(), new Object[0]), context);
        Log_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String duplicateAggregationKey$str() {
        return "HSEARCH600102: Multiple aggregations with the same key: '%1$s'";
    }

    @Override
    public final SearchException duplicateAggregationKey(AggregationKey key) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.duplicateAggregationKey$str(), new AggregationKeyFormatter(key)));
        Log_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String unsupportedDSLAggregations$str() {
        return "HSEARCH600103: This field does not support aggregations.";
    }

    @Override
    public final SearchException unsupportedDSLAggregations(EventContext context) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.unsupportedDSLAggregations$str(), new Object[0]), context);
        Log_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String searchAnalyzerWithoutAnalyzer$str() {
        return "HSEARCH600104: Cannot apply a search analyzer if an analyzer has not been defined on the same field. Search analyzer: '%1$s'.";
    }

    @Override
    public final SearchException searchAnalyzerWithoutAnalyzer(String searchAnalyzer, EventContext context) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.searchAnalyzerWithoutAnalyzer$str(), searchAnalyzer), context);
        Log_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }
}

