/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.lowlevel.directory.impl;

import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import org.hibernate.search.backend.lucene.logging.impl.Log;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;

final class FileSystemUtils {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());

    private FileSystemUtils() {
    }

    static void initializeWriteableDirectory(Path rootDirectory) throws IOException {
        if (Files.exists(rootDirectory, new LinkOption[0])) {
            if (!Files.isDirectory(rootDirectory, new LinkOption[0]) || !Files.isWritable(rootDirectory)) {
                throw log.pathIsNotWriteableDirectory(rootDirectory);
            }
        } else {
            Files.createDirectories(rootDirectory, new FileAttribute[0]);
        }
    }
}

