/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.lowlevel.directory.impl;

import org.apache.lucene.store.LockFactory;
import org.apache.lucene.store.SingleInstanceLockFactory;
import org.hibernate.search.backend.lucene.lowlevel.directory.impl.LocalHeapDirectoryHolder;
import org.hibernate.search.backend.lucene.lowlevel.directory.spi.DirectoryCreationContext;
import org.hibernate.search.backend.lucene.lowlevel.directory.spi.DirectoryHolder;
import org.hibernate.search.backend.lucene.lowlevel.directory.spi.DirectoryProvider;
import org.hibernate.search.backend.lucene.lowlevel.directory.spi.DirectoryProviderInitializationContext;

public class LocalHeapDirectoryProvider
implements DirectoryProvider {
    public static final String NAME = "local-heap";
    private LockFactory lockFactory;

    public String toString() {
        return this.getClass().getSimpleName();
    }

    @Override
    public void initialize(DirectoryProviderInitializationContext context) {
        this.lockFactory = context.createConfiguredLockFactory().orElseGet(SingleInstanceLockFactory::new);
    }

    @Override
    public DirectoryHolder createDirectoryHolder(DirectoryCreationContext context) {
        return new LocalHeapDirectoryHolder(this.lockFactory);
    }
}

