/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.multitenancy.impl;

import java.lang.invoke.MethodHandles;
import org.apache.lucene.document.Document;
import org.apache.lucene.search.Query;
import org.hibernate.search.backend.lucene.document.impl.LuceneIndexEntry;
import org.hibernate.search.backend.lucene.logging.impl.Log;
import org.hibernate.search.backend.lucene.multitenancy.impl.MultiTenancyStrategy;
import org.hibernate.search.backend.lucene.work.impl.LuceneDeleteAllEntriesWork;
import org.hibernate.search.backend.lucene.work.impl.LuceneTermBasedDeleteEntryWork;
import org.hibernate.search.backend.lucene.work.impl.LuceneTermBasedUpdateEntryWork;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;
import org.hibernate.search.util.common.reporting.EventContext;

public class NoMultiTenancyStrategy
implements MultiTenancyStrategy {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());

    @Override
    public boolean isMultiTenancySupported() {
        return false;
    }

    @Override
    public void contributeToIndexedDocument(Document document, String tenantId) {
    }

    @Override
    public Query decorateLuceneQuery(Query originalLuceneQuery, String tenantId) {
        return originalLuceneQuery;
    }

    @Override
    public LuceneTermBasedUpdateEntryWork createUpdateEntryLuceneWork(String tenantId, String id, LuceneIndexEntry indexEntry) {
        return new LuceneTermBasedUpdateEntryWork(tenantId, id, indexEntry);
    }

    @Override
    public LuceneTermBasedDeleteEntryWork createDeleteEntryLuceneWork(String tenantId, String id) {
        return new LuceneTermBasedDeleteEntryWork(tenantId, id);
    }

    @Override
    public LuceneDeleteAllEntriesWork createDeleteAllEntriesLuceneWork(String tenantId) {
        return new LuceneDeleteAllEntriesWork(tenantId);
    }

    @Override
    public void checkTenantId(String tenantId, EventContext backendContext) {
        if (tenantId != null) {
            throw log.tenantIdProvidedButMultiTenancyDisabled(tenantId, backendContext);
        }
    }
}

