/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.orchestration.impl;

import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import org.hibernate.search.backend.lucene.logging.impl.Log;
import org.hibernate.search.backend.lucene.lowlevel.writer.impl.IndexWriterDelegator;
import org.hibernate.search.backend.lucene.orchestration.impl.LuceneWriteWorkExecutionContextImpl;
import org.hibernate.search.backend.lucene.work.impl.LuceneWriteWork;
import org.hibernate.search.engine.backend.orchestration.spi.BatchingExecutor;
import org.hibernate.search.engine.backend.work.execution.DocumentCommitStrategy;
import org.hibernate.search.engine.backend.work.execution.DocumentRefreshStrategy;
import org.hibernate.search.engine.reporting.FailureHandler;
import org.hibernate.search.engine.reporting.IndexFailureContext;
import org.hibernate.search.util.common.AssertionFailure;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;
import org.hibernate.search.util.common.reporting.EventContext;

public class LuceneWriteWorkProcessor
implements BatchingExecutor.WorkProcessor {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    private final String indexName;
    private final EventContext indexEventContext;
    private final IndexWriterDelegator indexWriterDelegator;
    private final LuceneWriteWorkExecutionContextImpl context;
    private final FailureHandler failureHandler;
    private List<LuceneWriteWork<?>> previousWorkSetsUncommittedWorks = new ArrayList();
    private boolean workSetForcesCommit;
    private List<LuceneWriteWork<?>> workSetUncommittedWorks = new ArrayList();
    private boolean workSetHasFailure;

    public LuceneWriteWorkProcessor(String indexName, EventContext indexEventContext, IndexWriterDelegator indexWriterDelegator, FailureHandler failureHandler) {
        this.indexName = indexName;
        this.indexEventContext = indexEventContext;
        this.indexWriterDelegator = indexWriterDelegator;
        this.context = new LuceneWriteWorkExecutionContextImpl(indexEventContext, indexWriterDelegator);
        this.failureHandler = failureHandler;
    }

    public void beginBatch() {
    }

    public CompletableFuture<?> endBatch() {
        if (!this.previousWorkSetsUncommittedWorks.isEmpty()) {
            try {
                this.commit();
            }
            catch (RuntimeException e) {
                this.cleanUpAfterFailure(e, "Commit after a batch of index works");
            }
            finally {
                this.previousWorkSetsUncommittedWorks.clear();
            }
        }
        return CompletableFuture.completedFuture(null);
    }

    public void beforeWorkSet(DocumentCommitStrategy commitStrategy, DocumentRefreshStrategy refreshStrategy) {
        this.workSetForcesCommit = DocumentCommitStrategy.FORCE.equals((Object)commitStrategy) || DocumentRefreshStrategy.FORCE.equals((Object)refreshStrategy);
        this.workSetUncommittedWorks.clear();
        this.workSetHasFailure = false;
    }

    void ensureIndexExists() {
        try {
            this.indexWriterDelegator.ensureIndexExists();
        }
        catch (IOException | RuntimeException e) {
            throw log.unableToInitializeIndexDirectory(e.getMessage(), this.indexEventContext, e);
        }
    }

    public <T> T submit(LuceneWriteWork<T> work) {
        if (this.workSetHasFailure) {
            throw new AssertionFailure("A work was submitted to the processor after a failure occurred in the current workset. There is a bug in Hibernate Search, please report it.");
        }
        try {
            this.workSetUncommittedWorks.add(work);
            return work.execute(this.context);
        }
        catch (RuntimeException e) {
            this.cleanUpAfterFailure(e, work.getInfo());
            throw e;
        }
    }

    public void afterSuccessfulWorkSet() {
        if (this.workSetForcesCommit) {
            try {
                this.commit();
            }
            catch (RuntimeException e) {
                this.cleanUpAfterFailure(e, "Commit after a set of index works");
                throw e;
            }
            finally {
                this.previousWorkSetsUncommittedWorks.clear();
                this.workSetUncommittedWorks.clear();
            }
        } else {
            this.previousWorkSetsUncommittedWorks.addAll(this.workSetUncommittedWorks);
            this.workSetUncommittedWorks.clear();
        }
    }

    private void commit() {
        try {
            this.indexWriterDelegator.commit();
        }
        catch (IOException | RuntimeException e) {
            throw log.unableToCommitIndex(this.indexEventContext, e);
        }
    }

    private void cleanUpAfterFailure(Throwable throwable, Object failingOperation) {
        try {
            this.indexWriterDelegator.forceLockRelease();
        }
        catch (IOException | RuntimeException e) {
            throwable.addSuppressed((Throwable)log.unableToCleanUpAfterError(this.indexEventContext, e));
        }
        if (this.previousWorkSetsUncommittedWorks.isEmpty()) {
            return;
        }
        IndexFailureContext.Builder failureContextBuilder = IndexFailureContext.builder();
        failureContextBuilder.indexName(this.indexName);
        failureContextBuilder.throwable(throwable);
        failureContextBuilder.failingOperation(failingOperation);
        for (LuceneWriteWork<?> work : this.previousWorkSetsUncommittedWorks) {
            failureContextBuilder.uncommittedOperation(work.getInfo());
        }
        this.previousWorkSetsUncommittedWorks.clear();
        IndexFailureContext failureContext = failureContextBuilder.build();
        this.failureHandler.handle(failureContext);
    }
}

