/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.scope.model.impl;

import java.lang.invoke.MethodHandles;
import java.util.Iterator;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.hibernate.search.backend.lucene.document.model.impl.LuceneIndexModel;
import org.hibernate.search.backend.lucene.document.model.impl.LuceneIndexSchemaFieldNode;
import org.hibernate.search.backend.lucene.document.model.impl.LuceneIndexSchemaObjectNode;
import org.hibernate.search.backend.lucene.logging.impl.Log;
import org.hibernate.search.backend.lucene.scope.model.impl.IndexSchemaFieldNodeComponentRetrievalStrategy;
import org.hibernate.search.backend.lucene.scope.model.impl.LuceneFailingCompatibilityChecker;
import org.hibernate.search.backend.lucene.scope.model.impl.LuceneScopeIndexManagerContext;
import org.hibernate.search.backend.lucene.scope.model.impl.LuceneScopedIndexFieldComponent;
import org.hibernate.search.engine.backend.document.model.dsl.ObjectFieldStorage;
import org.hibernate.search.engine.backend.types.converter.spi.ToDocumentIdentifierValueConverter;
import org.hibernate.search.engine.reporting.spi.EventContexts;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;
import org.hibernate.search.util.common.reporting.EventContext;

public class LuceneScopeModel {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    private final Set<LuceneIndexModel> indexModels;
    private final Set<String> indexNames;
    private final Set<LuceneScopeIndexManagerContext> indexManagerContexts;

    public LuceneScopeModel(Set<LuceneIndexModel> indexModels, Set<LuceneScopeIndexManagerContext> indexManagerContexts) {
        this.indexModels = indexModels;
        this.indexNames = indexModels.stream().map(LuceneIndexModel::getIndexName).collect(Collectors.toSet());
        this.indexManagerContexts = indexManagerContexts;
    }

    public Set<String> getIndexNames() {
        return this.indexNames;
    }

    public EventContext getIndexesEventContext() {
        return EventContexts.fromIndexNames(this.indexNames);
    }

    public Set<LuceneScopeIndexManagerContext> getIndexManagerContexts() {
        return this.indexManagerContexts;
    }

    public ToDocumentIdentifierValueConverter<?> getIdDslConverter() {
        Iterator<LuceneIndexModel> iterator = this.indexModels.iterator();
        LuceneIndexModel indexModelForSelectedIdConverter = iterator.next();
        ToDocumentIdentifierValueConverter<?> selectedIdConverter = indexModelForSelectedIdConverter.getIdDslConverter();
        while (iterator.hasNext()) {
            LuceneIndexModel indexModel = iterator.next();
            ToDocumentIdentifierValueConverter<?> idConverter = indexModel.getIdDslConverter();
            if (selectedIdConverter.isCompatibleWith(idConverter)) continue;
            throw log.conflictingIdentifierTypesForPredicate(selectedIdConverter, idConverter, EventContexts.fromIndexNames((String[])new String[]{indexModelForSelectedIdConverter.getIndexName(), indexModel.getIndexName()}));
        }
        return selectedIdConverter;
    }

    public <T> LuceneScopedIndexFieldComponent<T> getSchemaNodeComponent(String absoluteFieldPath, IndexSchemaFieldNodeComponentRetrievalStrategy<T> componentRetrievalStrategy) {
        LuceneIndexModel indexModelForSelectedSchemaNode = null;
        LuceneIndexSchemaFieldNode<?> selectedSchemaNode = null;
        LuceneScopedIndexFieldComponent<T> scopedIndexFieldComponent = new LuceneScopedIndexFieldComponent<T>();
        for (LuceneIndexModel indexModel : this.indexModels) {
            LuceneIndexSchemaFieldNode<?> schemaNode = indexModel.getFieldNode(absoluteFieldPath);
            if (schemaNode == null) continue;
            T component = componentRetrievalStrategy.extractComponent(schemaNode);
            if (selectedSchemaNode == null) {
                selectedSchemaNode = schemaNode;
                indexModelForSelectedSchemaNode = indexModel;
                scopedIndexFieldComponent.setComponent(component);
                continue;
            }
            if (!componentRetrievalStrategy.hasCompatibleCodec(scopedIndexFieldComponent.getComponent(), component)) {
                throw componentRetrievalStrategy.createCompatibilityException(absoluteFieldPath, scopedIndexFieldComponent.getComponent(), component, EventContexts.fromIndexNames((String[])new String[]{indexModelForSelectedSchemaNode.getIndexName(), indexModel.getIndexName()}));
            }
            LuceneFailingCompatibilityChecker failingCompatibilityChecker = new LuceneFailingCompatibilityChecker(absoluteFieldPath, scopedIndexFieldComponent.getComponent(), component, EventContexts.fromIndexNames((String[])new String[]{indexModelForSelectedSchemaNode.getIndexName(), indexModel.getIndexName()}), componentRetrievalStrategy);
            if (!componentRetrievalStrategy.hasCompatibleConverter(scopedIndexFieldComponent.getComponent(), component)) {
                scopedIndexFieldComponent.setConverterCompatibilityChecker(failingCompatibilityChecker);
            }
            if (componentRetrievalStrategy.hasCompatibleAnalyzer(scopedIndexFieldComponent.getComponent(), component)) continue;
            scopedIndexFieldComponent.setAnalyzerCompatibilityChecker(failingCompatibilityChecker);
        }
        if (selectedSchemaNode == null) {
            throw log.unknownFieldForSearch(absoluteFieldPath, this.getIndexesEventContext());
        }
        return scopedIndexFieldComponent;
    }

    public void checkNestedField(String absoluteFieldPath) {
        LuceneIndexSchemaFieldNode<?> schemaNode;
        boolean found = false;
        for (LuceneIndexModel indexModel : this.indexModels) {
            schemaNode = indexModel.getObjectNode(absoluteFieldPath);
            if (schemaNode == null) continue;
            found = true;
            if (ObjectFieldStorage.NESTED.equals((Object)((LuceneIndexSchemaObjectNode)((Object)schemaNode)).getStorage())) continue;
            throw log.nonNestedFieldForNestedQuery(absoluteFieldPath, indexModel.getEventContext());
        }
        if (!found) {
            for (LuceneIndexModel indexModel : this.indexModels) {
                schemaNode = indexModel.getFieldNode(absoluteFieldPath);
                if (schemaNode == null) continue;
                throw log.nonObjectFieldForNestedQuery(absoluteFieldPath, indexModel.getEventContext());
            }
            throw log.unknownFieldForSearch(absoluteFieldPath, this.getIndexesEventContext());
        }
    }

    public String getNestedDocumentPath(String absoluteFieldPath) {
        Optional<Object> nestedDocumentPath = this.indexModels.stream().map(indexModel -> indexModel.getFieldNode(absoluteFieldPath)).filter(Objects::nonNull).map(fieldNode -> Optional.ofNullable(fieldNode.getNestedDocumentPath())).reduce((nestedDocumentPath1, nestedDocumentPath2) -> {
            if (Objects.equals(nestedDocumentPath1, nestedDocumentPath2)) {
                return nestedDocumentPath1;
            }
            throw log.conflictingNestedDocumentPathsForProjection(absoluteFieldPath, nestedDocumentPath1.orElse(null), nestedDocumentPath2.orElse(null), this.getIndexesEventContext());
        }).orElse(Optional.empty());
        return nestedDocumentPath.orElse(null);
    }
}

