/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.search.extraction.impl;

import org.hibernate.search.backend.lucene.search.extraction.impl.LuceneCollectorsBuilder;
import org.hibernate.search.backend.lucene.search.extraction.impl.LuceneDocumentStoredFieldVisitorBuilder;
import org.hibernate.search.backend.lucene.search.extraction.impl.LuceneResult;
import org.hibernate.search.backend.lucene.search.impl.LuceneDocumentReference;
import org.hibernate.search.backend.lucene.util.impl.LuceneFields;
import org.hibernate.search.engine.backend.common.DocumentReference;

public final class DocumentReferenceExtractorHelper {
    private DocumentReferenceExtractorHelper() {
    }

    public static void contributeCollectors(LuceneCollectorsBuilder luceneCollectorBuilder) {
        luceneCollectorBuilder.requireTopDocsCollector();
    }

    public static void contributeFields(LuceneDocumentStoredFieldVisitorBuilder builder) {
        builder.add(LuceneFields.indexFieldName());
        builder.add(LuceneFields.idFieldName());
    }

    public static DocumentReference extractDocumentReference(LuceneResult documentResult) {
        return new LuceneDocumentReference(documentResult.getStringValue(LuceneFields.indexFieldName()), documentResult.getStringValue(LuceneFields.idFieldName()));
    }
}

