/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.search.extraction.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.MultiCollector;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.SortField;
import org.apache.lucene.search.TopDocsCollector;
import org.apache.lucene.search.TopFieldCollector;
import org.apache.lucene.search.TopScoreDocCollector;
import org.apache.lucene.search.TotalHitCountCollector;
import org.hibernate.search.backend.lucene.search.extraction.impl.LuceneCollectorFactory;
import org.hibernate.search.backend.lucene.search.extraction.impl.LuceneCollectorKey;
import org.hibernate.search.backend.lucene.search.extraction.impl.LuceneCollectors;

public class LuceneCollectorsBuilder {
    private final Sort sort;
    private final int maxDocs;
    private final TotalHitCountCollector totalHitCountCollector;
    private boolean requireTopDocs;
    private boolean requireScore;
    private final Map<LuceneCollectorKey<?>, Collector> luceneCollectors = new LinkedHashMap();
    private final List<Collector> luceneCollectorsForNestedDocuments = new ArrayList<Collector>();

    public LuceneCollectorsBuilder(Sort sort, int maxDocs) {
        this.sort = sort;
        this.maxDocs = maxDocs;
        this.totalHitCountCollector = new TotalHitCountCollector();
        this.luceneCollectors.put(LuceneCollectorKey.TOTAL_HIT_COUNT, (Collector)this.totalHitCountCollector);
    }

    public void requireScore() {
        this.requireTopDocs = true;
        this.requireScore = true;
    }

    public void requireTopDocsCollector() {
        this.requireTopDocs = true;
    }

    public <C extends Collector> void addCollector(LuceneCollectorFactory<C> collectorFactory) {
        this.requireTopDocs = true;
        if (this.luceneCollectors.containsKey(collectorFactory)) {
            return;
        }
        C collector = collectorFactory.createCollector(this.maxDocs);
        this.luceneCollectors.put((LuceneCollectorKey<?>)collectorFactory, (Collector)collector);
        if (collectorFactory.applyToNestedDocuments()) {
            this.luceneCollectorsForNestedDocuments.add((Collector)collector);
        }
    }

    public LuceneCollectors build() {
        TopScoreDocCollector topDocsCollector = null;
        Integer scoreSortFieldIndexForRescoring = null;
        boolean requireFieldDocRescoring = false;
        if (this.requireTopDocs && this.maxDocs > 0) {
            if (this.sort == null) {
                topDocsCollector = TopScoreDocCollector.create((int)this.maxDocs, (int)Integer.MAX_VALUE);
            } else {
                if (this.requireScore) {
                    requireFieldDocRescoring = true;
                    SortField[] sortFields = this.sort.getSort();
                    for (int i = 0; i < sortFields.length; ++i) {
                        SortField sortField = sortFields[i];
                        if (sortField.getType() != SortField.Type.SCORE) continue;
                        scoreSortFieldIndexForRescoring = i;
                        break;
                    }
                }
                topDocsCollector = TopFieldCollector.create((Sort)this.sort, (int)this.maxDocs, (int)Integer.MAX_VALUE);
            }
            this.luceneCollectors.put(LuceneCollectorKey.TOP_DOCS, (Collector)topDocsCollector);
        }
        Collector compositeCollector = MultiCollector.wrap(this.luceneCollectors.values());
        return new LuceneCollectors((TopDocsCollector<?>)topDocsCollector, this.totalHitCountCollector, compositeCollector, (Collection<Collector>)this.luceneCollectorsForNestedDocuments, this.luceneCollectors, requireFieldDocRescoring, scoreSortFieldIndexForRescoring);
    }
}

