/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.search.impl;

import java.util.Set;
import org.apache.lucene.search.Query;
import org.hibernate.search.backend.lucene.analysis.model.impl.LuceneAnalysisDefinitionRegistry;
import org.hibernate.search.backend.lucene.lowlevel.reader.impl.ReadIndexManagerContext;
import org.hibernate.search.backend.lucene.multitenancy.impl.MultiTenancyStrategy;
import org.hibernate.search.backend.lucene.scope.model.impl.LuceneScopeModel;
import org.hibernate.search.engine.backend.mapping.spi.BackendMappingContext;
import org.hibernate.search.engine.backend.types.converter.runtime.ToDocumentFieldValueConvertContext;
import org.hibernate.search.engine.backend.types.converter.runtime.spi.ToDocumentFieldValueConvertContextImpl;
import org.hibernate.search.engine.backend.types.converter.runtime.spi.ToDocumentIdentifierValueConvertContext;
import org.hibernate.search.engine.backend.types.converter.runtime.spi.ToDocumentIdentifierValueConvertContextImpl;

public final class LuceneSearchContext {
    private final ToDocumentIdentifierValueConvertContext toDocumentIdentifierValueConvertContext;
    private final ToDocumentFieldValueConvertContext toDocumentFieldValueConvertContext;
    private final LuceneAnalysisDefinitionRegistry analysisDefinitionRegistry;
    private final MultiTenancyStrategy multiTenancyStrategy;
    private final LuceneScopeModel scopeModel;

    public LuceneSearchContext(BackendMappingContext mappingContext, LuceneAnalysisDefinitionRegistry analysisDefinitionRegistry, MultiTenancyStrategy multiTenancyStrategy, LuceneScopeModel scopeModel) {
        this.toDocumentIdentifierValueConvertContext = new ToDocumentIdentifierValueConvertContextImpl(mappingContext);
        this.toDocumentFieldValueConvertContext = new ToDocumentFieldValueConvertContextImpl(mappingContext);
        this.analysisDefinitionRegistry = analysisDefinitionRegistry;
        this.multiTenancyStrategy = multiTenancyStrategy;
        this.scopeModel = scopeModel;
    }

    public ToDocumentIdentifierValueConvertContext getToDocumentIdentifierValueConvertContext() {
        return this.toDocumentIdentifierValueConvertContext;
    }

    public ToDocumentFieldValueConvertContext getToDocumentFieldValueConvertContext() {
        return this.toDocumentFieldValueConvertContext;
    }

    public LuceneAnalysisDefinitionRegistry getAnalysisDefinitionRegistry() {
        return this.analysisDefinitionRegistry;
    }

    public Set<String> getIndexNames() {
        return this.scopeModel.getIndexNames();
    }

    public Set<? extends ReadIndexManagerContext> getIndexManagerContexts() {
        return this.scopeModel.getIndexManagerContexts();
    }

    public Query decorateLuceneQuery(Query originalLuceneQuery, String tenantId) {
        return this.multiTenancyStrategy.decorateLuceneQuery(originalLuceneQuery, tenantId);
    }
}

