/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.search.predicate.impl;

import java.lang.invoke.MethodHandles;
import java.util.Optional;
import org.hibernate.search.backend.lucene.logging.impl.Log;
import org.hibernate.search.backend.lucene.scope.model.impl.LuceneCompatibilityChecker;
import org.hibernate.search.backend.lucene.search.impl.LuceneSearchContext;
import org.hibernate.search.backend.lucene.search.predicate.impl.AbstractLuceneSearchPredicateBuilder;
import org.hibernate.search.backend.lucene.search.predicate.impl.LuceneSearchPredicateBuilder;
import org.hibernate.search.backend.lucene.types.codec.impl.LuceneStandardFieldCodec;
import org.hibernate.search.engine.backend.types.converter.ToDocumentFieldValueConverter;
import org.hibernate.search.engine.reporting.spi.EventContexts;
import org.hibernate.search.engine.search.common.ValueConvert;
import org.hibernate.search.engine.search.predicate.spi.RangePredicateBuilder;
import org.hibernate.search.util.common.data.Range;
import org.hibernate.search.util.common.data.RangeBoundInclusion;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;

public abstract class AbstractLuceneStandardRangePredicateBuilder<F, E, C extends LuceneStandardFieldCodec<F, E>>
extends AbstractLuceneSearchPredicateBuilder
implements RangePredicateBuilder<LuceneSearchPredicateBuilder> {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    private final LuceneSearchContext searchContext;
    protected final String absoluteFieldPath;
    private final ToDocumentFieldValueConverter<?, ? extends F> converter;
    private final ToDocumentFieldValueConverter<F, ? extends F> rawConverter;
    private final LuceneCompatibilityChecker converterChecker;
    protected final C codec;
    protected Range<E> range;

    protected AbstractLuceneStandardRangePredicateBuilder(LuceneSearchContext searchContext, String absoluteFieldPath, ToDocumentFieldValueConverter<?, ? extends F> converter, ToDocumentFieldValueConverter<F, ? extends F> rawConverter, LuceneCompatibilityChecker converterChecker, C codec) {
        this.searchContext = searchContext;
        this.absoluteFieldPath = absoluteFieldPath;
        this.converter = converter;
        this.rawConverter = rawConverter;
        this.converterChecker = converterChecker;
        this.codec = codec;
    }

    public void range(Range<?> range, ValueConvert convertLowerBound, ValueConvert convertUpperBound) {
        this.range = Range.between(this.convertAndEncode(range.getLowerBoundValue(), convertLowerBound), (RangeBoundInclusion)range.getLowerBoundInclusion(), this.convertAndEncode(range.getUpperBoundValue(), convertUpperBound), (RangeBoundInclusion)range.getUpperBoundInclusion());
    }

    private E convertAndEncode(Optional<?> valueOptional, ValueConvert convert) {
        if (!valueOptional.isPresent()) {
            return null;
        }
        Object value = valueOptional.get();
        ToDocumentFieldValueConverter<?, F> toFieldValueConverter = this.getDslToIndexConverter(convert);
        try {
            Object converted = toFieldValueConverter.convertUnknown(value, this.searchContext.getToDocumentFieldValueConvertContext());
            return this.codec.encode((Object)converted);
        }
        catch (RuntimeException e) {
            throw log.cannotConvertDslParameter(e.getMessage(), e, EventContexts.fromIndexFieldAbsolutePath((String)this.absoluteFieldPath));
        }
    }

    private ToDocumentFieldValueConverter<?, ? extends F> getDslToIndexConverter(ValueConvert convert) {
        switch (convert) {
            case NO: {
                return this.rawConverter;
            }
        }
        this.converterChecker.failIfNotCompatible();
        return this.converter;
    }
}

