/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.search.projection.impl;

import java.util.Objects;
import java.util.Set;
import org.hibernate.search.backend.lucene.search.extraction.impl.DistanceCollector;
import org.hibernate.search.backend.lucene.search.extraction.impl.LuceneCollectorFactory;
import org.hibernate.search.backend.lucene.search.extraction.impl.LuceneCollectorsBuilder;
import org.hibernate.search.backend.lucene.search.extraction.impl.LuceneDocumentStoredFieldVisitorBuilder;
import org.hibernate.search.backend.lucene.search.extraction.impl.LuceneResult;
import org.hibernate.search.backend.lucene.search.projection.impl.LuceneSearchProjection;
import org.hibernate.search.backend.lucene.search.projection.impl.SearchProjectionExtractContext;
import org.hibernate.search.backend.lucene.search.projection.impl.SearchProjectionTransformContext;
import org.hibernate.search.engine.search.loading.spi.LoadingResult;
import org.hibernate.search.engine.search.loading.spi.ProjectionHitMapper;
import org.hibernate.search.engine.spatial.DistanceUnit;
import org.hibernate.search.engine.spatial.GeoPoint;

class LuceneDistanceToFieldProjection
implements LuceneSearchProjection<Double, Double>,
LuceneCollectorFactory<DistanceCollector> {
    private final Set<String> indexNames;
    private final String absoluteFieldPath;
    private final String nestedDocumentPath;
    private final GeoPoint center;
    private final DistanceUnit unit;

    LuceneDistanceToFieldProjection(Set<String> indexNames, String absoluteFieldPath, String nestedDocumentPath, GeoPoint center, DistanceUnit unit) {
        this.indexNames = indexNames;
        this.absoluteFieldPath = absoluteFieldPath;
        this.nestedDocumentPath = nestedDocumentPath;
        this.center = center;
        this.unit = unit;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || !obj.getClass().equals(this.getClass())) {
            return false;
        }
        LuceneDistanceToFieldProjection other = (LuceneDistanceToFieldProjection)obj;
        return this.absoluteFieldPath.equals(other.absoluteFieldPath) && this.center.equals(other.center);
    }

    public int hashCode() {
        return Objects.hash(this.absoluteFieldPath, this.center);
    }

    @Override
    public void contributeCollectors(LuceneCollectorsBuilder luceneCollectorBuilder) {
        luceneCollectorBuilder.addCollector(this);
    }

    @Override
    public void contributeFields(LuceneDocumentStoredFieldVisitorBuilder builder) {
        builder.add(this.absoluteFieldPath);
        builder.addNestedDocumentPath(this.nestedDocumentPath);
    }

    @Override
    public Double extract(ProjectionHitMapper<?, ?> mapper, LuceneResult documentResult, SearchProjectionExtractContext context) {
        DistanceCollector distanceCollector = context.getCollector(this);
        return this.unit.fromMeters(distanceCollector.getDistance(documentResult.getDocId(), context));
    }

    @Override
    public Double transform(LoadingResult<?> loadingResult, Double extractedData, SearchProjectionTransformContext context) {
        return extractedData;
    }

    @Override
    public Set<String> getIndexNames() {
        return this.indexNames;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this.getClass().getSimpleName()).append("[").append("absoluteFieldPath=").append(this.absoluteFieldPath).append(", center=").append(this.center).append("]");
        return sb.toString();
    }

    @Override
    public DistanceCollector createCollector(int maxDocs) {
        return new DistanceCollector(this.absoluteFieldPath, this.center, maxDocs);
    }

    @Override
    public boolean applyToNestedDocuments() {
        return true;
    }
}

