/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.search.query.impl;

import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.lucene.index.BinaryDocValues;
import org.apache.lucene.index.DocValues;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.LeafCollector;
import org.apache.lucene.search.Scorable;
import org.apache.lucene.search.ScoreMode;
import org.hibernate.search.backend.lucene.util.impl.LuceneFields;

public class LuceneChildrenCollector
implements Collector {
    private final Map<String, Set<Integer>> children = new HashMap<String, Set<Integer>>();

    public LeafCollector getLeafCollector(LeafReaderContext context) throws IOException {
        return new FieldLeafCollector(context);
    }

    public ScoreMode scoreMode() {
        return ScoreMode.COMPLETE_NO_SCORES;
    }

    public Map<String, Set<Integer>> getChildren() {
        return this.children;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("LuceneChildrenCollector{");
        sb.append("children=").append(this.children);
        sb.append('}');
        return sb.toString();
    }

    private class FieldLeafCollector
    implements LeafCollector {
        private final LeafReader reader;
        private final BinaryDocValues docValues;

        public FieldLeafCollector(LeafReaderContext context) throws IOException {
            this.reader = context.reader();
            this.docValues = DocValues.getBinary((LeafReader)this.reader, (String)LuceneFields.rootIdFieldName());
        }

        public void setScorer(Scorable scorer) throws IOException {
        }

        public void collect(int doc) throws IOException {
            if (!this.docValues.advanceExact(doc)) {
                return;
            }
            String parentId = this.docValues.binaryValue().utf8ToString();
            if (!LuceneChildrenCollector.this.children.containsKey(parentId)) {
                LuceneChildrenCollector.this.children.put(parentId, new HashSet());
            }
            ((Set)LuceneChildrenCollector.this.children.get(parentId)).add(doc);
        }
    }
}

