/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.search.query.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import org.hibernate.search.backend.lucene.search.impl.LuceneSearchContext;
import org.hibernate.search.backend.lucene.search.impl.LuceneSearchQueryElementCollector;
import org.hibernate.search.backend.lucene.search.projection.impl.LuceneCompositeListProjection;
import org.hibernate.search.backend.lucene.search.projection.impl.LuceneEntityProjection;
import org.hibernate.search.backend.lucene.search.projection.impl.LuceneReferenceProjection;
import org.hibernate.search.backend.lucene.search.projection.impl.LuceneSearchProjection;
import org.hibernate.search.backend.lucene.search.projection.impl.LuceneSearchProjectionBuilderFactory;
import org.hibernate.search.backend.lucene.search.query.impl.LuceneSearchQueryBuilder;
import org.hibernate.search.backend.lucene.search.query.impl.SearchBackendContext;
import org.hibernate.search.engine.backend.session.spi.BackendSessionContext;
import org.hibernate.search.engine.search.loading.context.spi.LoadingContextBuilder;
import org.hibernate.search.engine.search.projection.SearchProjection;
import org.hibernate.search.engine.search.query.spi.SearchQueryBuilderFactory;

public class LuceneSearchQueryBuilderFactory
implements SearchQueryBuilderFactory<LuceneSearchQueryElementCollector> {
    private final SearchBackendContext searchBackendContext;
    private final LuceneSearchContext searchContext;
    private final LuceneSearchProjectionBuilderFactory searchProjectionFactory;

    public LuceneSearchQueryBuilderFactory(SearchBackendContext searchBackendContext, LuceneSearchContext searchContext, LuceneSearchProjectionBuilderFactory searchProjectionFactory) {
        this.searchBackendContext = searchBackendContext;
        this.searchContext = searchContext;
        this.searchProjectionFactory = searchProjectionFactory;
    }

    public <E> LuceneSearchQueryBuilder<E> asEntity(BackendSessionContext sessionContext, LoadingContextBuilder<?, E> loadingContextBuilder) {
        return this.createSearchQueryBuilder(sessionContext, loadingContextBuilder, new LuceneEntityProjection(this.searchContext.getIndexNames()));
    }

    public <R> LuceneSearchQueryBuilder<R> asReference(BackendSessionContext sessionContext, LoadingContextBuilder<R, ?> loadingContextBuilder) {
        return this.createSearchQueryBuilder(sessionContext, loadingContextBuilder, new LuceneReferenceProjection(this.searchContext.getIndexNames()));
    }

    public <P> LuceneSearchQueryBuilder<P> asProjection(BackendSessionContext sessionContext, LoadingContextBuilder<?, ?> loadingContextBuilder, SearchProjection<P> projection) {
        return this.createSearchQueryBuilder(sessionContext, loadingContextBuilder, this.searchProjectionFactory.toImplementation(projection));
    }

    public LuceneSearchQueryBuilder<List<?>> asProjections(BackendSessionContext sessionContext, LoadingContextBuilder<?, ?> loadingContextBuilder, SearchProjection<?> ... projections) {
        return this.createSearchQueryBuilder(sessionContext, loadingContextBuilder, this.createRootProjection(projections));
    }

    private LuceneSearchProjection<?, List<?>> createRootProjection(SearchProjection<?>[] projections) {
        ArrayList children = new ArrayList(projections.length);
        for (SearchProjection<?> projection : projections) {
            children.add(this.searchProjectionFactory.toImplementation(projection));
        }
        return new LuceneCompositeListProjection(this.searchContext.getIndexNames(), Function.identity(), children);
    }

    private <H> LuceneSearchQueryBuilder<H> createSearchQueryBuilder(BackendSessionContext sessionContext, LoadingContextBuilder<?, ?> loadingContextBuilder, LuceneSearchProjection<?, H> rootProjection) {
        return this.searchBackendContext.createSearchQueryBuilder(this.searchContext, sessionContext, loadingContextBuilder, rootProjection);
    }
}

