/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.types.aggregation.impl;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.lucene.facet.FacetResult;
import org.apache.lucene.facet.FacetsCollector;
import org.apache.lucene.facet.LabelAndValue;
import org.apache.lucene.index.IndexReader;
import org.hibernate.search.backend.lucene.search.aggregation.impl.AggregationExtractContext;
import org.hibernate.search.backend.lucene.search.extraction.impl.LuceneCollectorFactory;
import org.hibernate.search.backend.lucene.search.extraction.impl.LuceneCollectorsBuilder;
import org.hibernate.search.backend.lucene.search.impl.LuceneSearchContext;
import org.hibernate.search.backend.lucene.types.aggregation.impl.AbstractLuceneBucketAggregation;
import org.hibernate.search.backend.lucene.types.aggregation.impl.Bucket;
import org.hibernate.search.backend.lucene.types.aggregation.impl.BucketOrder;
import org.hibernate.search.engine.backend.types.converter.FromDocumentFieldValueConverter;
import org.hibernate.search.engine.backend.types.converter.runtime.FromDocumentFieldValueConvertContext;
import org.hibernate.search.engine.search.aggregation.spi.TermsAggregationBuilder;

abstract class AbstractLuceneFacetsBasedTermsAggregation<F, T, K>
extends AbstractLuceneBucketAggregation<K, Long> {
    protected final String absoluteFieldPath;
    private final FromDocumentFieldValueConverter<? super F, ? extends K> fromFieldValueConverter;
    private final BucketOrder order;
    private final int maxTermCount;
    private final int minDocCount;

    AbstractLuceneFacetsBasedTermsAggregation(AbstractBuilder<F, T, K> builder) {
        super(builder);
        this.absoluteFieldPath = ((AbstractBuilder)builder).absoluteFieldPath;
        this.fromFieldValueConverter = ((AbstractBuilder)builder).fromFieldValueConverter;
        this.order = ((AbstractBuilder)builder).order;
        this.maxTermCount = ((AbstractBuilder)builder).maxTermCount;
        this.minDocCount = ((AbstractBuilder)builder).minDocCount;
    }

    @Override
    public final void contributeCollectors(LuceneCollectorsBuilder luceneCollectorBuilder) {
        luceneCollectorBuilder.addCollector(LuceneCollectorFactory.FACETS);
    }

    @Override
    public final Map<K, Long> extract(AggregationExtractContext context) throws IOException {
        List<Bucket<T>> buckets;
        FromDocumentFieldValueConvertContext convertContext = context.getConvertContext();
        try {
            buckets = this.getTopBuckets(context);
        }
        catch (IllegalArgumentException e) {
            return this.toMap(convertContext, Collections.emptyList());
        }
        if (BucketOrder.COUNT_DESC.equals((Object)this.order) && (this.minDocCount > 0 || buckets.size() >= this.maxTermCount)) {
            return this.toMap(convertContext, buckets);
        }
        if (this.minDocCount <= 0) {
            Set<T> firstTerms = this.collectFirstTerms(context.getIndexReader(), this.order.isTermOrderDescending(), this.maxTermCount);
            for (Bucket<T> bucket : buckets) {
                firstTerms.remove(bucket.term);
            }
            for (Bucket<T> term : firstTerms) {
                buckets.add(new Bucket<Bucket<T>>(term, 0L));
            }
        }
        buckets.sort(this.order.toBucketComparator(this.getAscendingTermComparator()));
        if (buckets.size() > this.maxTermCount) {
            buckets.subList(this.maxTermCount, buckets.size()).clear();
        }
        return this.toMap(convertContext, buckets);
    }

    abstract FacetResult getTopChildren(IndexReader var1, FacetsCollector var2, int var3) throws IOException;

    abstract Set<T> collectFirstTerms(IndexReader var1, boolean var2, int var3) throws IOException;

    abstract Comparator<T> getAscendingTermComparator();

    abstract T labelToTerm(String var1);

    abstract F termToFieldValue(T var1);

    private List<Bucket<T>> getTopBuckets(AggregationExtractContext context) throws IOException {
        FacetsCollector facetsCollector = context.getCollector(LuceneCollectorFactory.FACETS);
        int limit = this.maxTermCount;
        FacetResult facetResult = this.getTopChildren(context.getIndexReader(), facetsCollector, limit);
        ArrayList<Bucket<T>> buckets = new ArrayList<Bucket<T>>();
        if (facetResult != null) {
            for (LabelAndValue labelAndValue : facetResult.labelValues) {
                long count = ((Integer)labelAndValue.value).intValue();
                if (count < (long)this.minDocCount) continue;
                buckets.add(new Bucket<T>(this.labelToTerm(labelAndValue.label), count));
            }
        }
        return buckets;
    }

    private Map<K, Long> toMap(FromDocumentFieldValueConvertContext convertContext, List<Bucket<T>> buckets) {
        LinkedHashMap<Object, Long> result = new LinkedHashMap<Object, Long>();
        for (Bucket<T> bucket : buckets) {
            F decoded = this.termToFieldValue(bucket.term);
            Object key = this.fromFieldValueConverter.convert(decoded, convertContext);
            result.put(key, bucket.count);
        }
        return result;
    }

    static abstract class AbstractBuilder<F, T, K>
    extends AbstractLuceneBucketAggregation.AbstractBuilder<K, Long>
    implements TermsAggregationBuilder<K> {
        private final String absoluteFieldPath;
        private final FromDocumentFieldValueConverter<? super F, ? extends K> fromFieldValueConverter;
        private BucketOrder order = BucketOrder.COUNT_DESC;
        private int minDocCount = 1;
        private int maxTermCount = 100;

        AbstractBuilder(LuceneSearchContext searchContext, String absoluteFieldPath, FromDocumentFieldValueConverter<? super F, ? extends K> fromFieldValueConverter) {
            super(searchContext);
            this.absoluteFieldPath = absoluteFieldPath;
            this.fromFieldValueConverter = fromFieldValueConverter;
        }

        public void orderByCountDescending() {
            this.order(BucketOrder.COUNT_DESC);
        }

        public void orderByCountAscending() {
            this.order(BucketOrder.COUNT_ASC);
        }

        public void orderByTermAscending() {
            this.order(BucketOrder.TERM_ASC);
        }

        public void orderByTermDescending() {
            this.order(BucketOrder.TERM_DESC);
        }

        public void minDocumentCount(int minDocumentCount) {
            this.minDocCount = minDocumentCount;
        }

        public void maxTermCount(int maxTermCount) {
            this.maxTermCount = maxTermCount;
        }

        @Override
        public abstract AbstractLuceneFacetsBasedTermsAggregation<F, T, K> build();

        protected final void order(BucketOrder order) {
            this.order = order;
        }
    }
}

