/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.types.aggregation.impl;

import java.lang.invoke.MethodHandles;
import org.hibernate.search.backend.lucene.logging.impl.Log;
import org.hibernate.search.backend.lucene.types.aggregation.impl.LuceneFieldAggregationBuilderFactory;
import org.hibernate.search.backend.lucene.types.codec.impl.LuceneFieldCodec;
import org.hibernate.search.engine.backend.types.converter.FromDocumentFieldValueConverter;
import org.hibernate.search.engine.backend.types.converter.ToDocumentFieldValueConverter;
import org.hibernate.search.engine.reporting.spi.EventContexts;
import org.hibernate.search.engine.search.common.ValueConvert;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;

abstract class AbstractLuceneStandardFieldAggregationBuilderFactory<F>
implements LuceneFieldAggregationBuilderFactory {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    private final boolean aggregable;
    private final ToDocumentFieldValueConverter<?, ? extends F> toFieldValueConverter;
    private final ToDocumentFieldValueConverter<? super F, ? extends F> rawToFieldValueConverter;
    private final FromDocumentFieldValueConverter<? super F, ?> fromFieldValueConverter;
    private final FromDocumentFieldValueConverter<? super F, F> rawFromFieldValueConverter;

    AbstractLuceneStandardFieldAggregationBuilderFactory(boolean aggregable, ToDocumentFieldValueConverter<?, ? extends F> toFieldValueConverter, ToDocumentFieldValueConverter<? super F, ? extends F> rawToFieldValueConverter, FromDocumentFieldValueConverter<? super F, ?> fromFieldValueConverter, FromDocumentFieldValueConverter<? super F, F> rawFromFieldValueConverter) {
        this.aggregable = aggregable;
        this.toFieldValueConverter = toFieldValueConverter;
        this.rawToFieldValueConverter = rawToFieldValueConverter;
        this.fromFieldValueConverter = fromFieldValueConverter;
        this.rawFromFieldValueConverter = rawFromFieldValueConverter;
    }

    @Override
    public boolean hasCompatibleCodec(LuceneFieldAggregationBuilderFactory other) {
        if (!this.getClass().equals(other.getClass())) {
            return false;
        }
        AbstractLuceneStandardFieldAggregationBuilderFactory castedOther = (AbstractLuceneStandardFieldAggregationBuilderFactory)other;
        return this.aggregable == castedOther.aggregable && this.getCodec().isCompatibleWith(castedOther.getCodec());
    }

    @Override
    public boolean hasCompatibleConverter(LuceneFieldAggregationBuilderFactory other) {
        if (!this.getClass().equals(other.getClass())) {
            return false;
        }
        AbstractLuceneStandardFieldAggregationBuilderFactory castedOther = (AbstractLuceneStandardFieldAggregationBuilderFactory)other;
        return this.toFieldValueConverter.isCompatibleWith(castedOther.toFieldValueConverter) && this.fromFieldValueConverter.isCompatibleWith(castedOther.fromFieldValueConverter);
    }

    protected abstract LuceneFieldCodec<F> getCodec();

    protected void checkAggregable(String absoluteFieldPath) {
        if (!this.aggregable) {
            throw log.nonAggregableField(absoluteFieldPath, EventContexts.fromIndexFieldAbsolutePath((String)absoluteFieldPath));
        }
    }

    protected <T> ToDocumentFieldValueConverter<?, ? extends F> getToFieldValueConverter(String absoluteFieldPath, Class<T> expectedType, ValueConvert convert) {
        Object result;
        switch (convert) {
            case NO: {
                result = this.rawToFieldValueConverter;
                break;
            }
            default: {
                result = this.toFieldValueConverter;
            }
        }
        if (!result.isValidInputType(expectedType)) {
            throw log.invalidAggregationInvalidType(absoluteFieldPath, expectedType, EventContexts.fromIndexFieldAbsolutePath((String)absoluteFieldPath));
        }
        return result;
    }

    protected <T> FromDocumentFieldValueConverter<? super F, ? extends T> getFromFieldValueConverter(String absoluteFieldPath, Class<T> expectedType, ValueConvert convert) {
        Object result;
        switch (convert) {
            case NO: {
                result = this.rawFromFieldValueConverter;
                break;
            }
            default: {
                result = this.fromFieldValueConverter;
            }
        }
        if (!result.isConvertedTypeAssignableTo(expectedType)) {
            throw log.invalidAggregationInvalidType(absoluteFieldPath, expectedType, EventContexts.fromIndexFieldAbsolutePath((String)absoluteFieldPath));
        }
        return result;
    }
}

