/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.types.aggregation.impl;

import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.apache.lucene.facet.FacetResult;
import org.apache.lucene.facet.Facets;
import org.apache.lucene.facet.FacetsCollector;
import org.hibernate.search.backend.lucene.logging.impl.Log;
import org.hibernate.search.backend.lucene.search.aggregation.impl.AggregationExtractContext;
import org.hibernate.search.backend.lucene.search.extraction.impl.LuceneCollectorFactory;
import org.hibernate.search.backend.lucene.search.extraction.impl.LuceneCollectorsBuilder;
import org.hibernate.search.backend.lucene.search.impl.LuceneSearchContext;
import org.hibernate.search.backend.lucene.types.aggregation.impl.AbstractLuceneBucketAggregation;
import org.hibernate.search.backend.lucene.types.codec.impl.AbstractLuceneNumericFieldCodec;
import org.hibernate.search.backend.lucene.types.lowlevel.impl.LuceneNumericDomain;
import org.hibernate.search.engine.backend.types.converter.ToDocumentFieldValueConverter;
import org.hibernate.search.engine.reporting.spi.EventContexts;
import org.hibernate.search.engine.search.aggregation.spi.RangeAggregationBuilder;
import org.hibernate.search.util.common.data.Range;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;

public class LuceneNumericRangeAggregation<F, E extends Number, K>
extends AbstractLuceneBucketAggregation<Range<K>, Long> {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    private final String absoluteFieldPath;
    private final AbstractLuceneNumericFieldCodec<F, E> codec;
    private final List<Range<K>> rangesInOrder;
    private final List<Range<E>> encodedRangesInOrder;

    private LuceneNumericRangeAggregation(Builder<F, E, K> builder) {
        super(builder);
        this.absoluteFieldPath = ((Builder)builder).absoluteFieldPath;
        this.codec = ((Builder)builder).codec;
        this.rangesInOrder = ((Builder)builder).rangesInOrder;
        this.encodedRangesInOrder = ((Builder)builder).encodedRangesInOrder;
    }

    @Override
    public void contributeCollectors(LuceneCollectorsBuilder luceneCollectorBuilder) {
        luceneCollectorBuilder.addCollector(LuceneCollectorFactory.FACETS);
    }

    @Override
    public Map<Range<K>, Long> extract(AggregationExtractContext context) throws IOException {
        LuceneNumericDomain<E> numericDomain = this.codec.getDomain();
        FacetsCollector facetsCollector = context.getCollector(LuceneCollectorFactory.FACETS);
        Facets facetsCount = numericDomain.createRangeFacetCounts(this.absoluteFieldPath, facetsCollector, this.encodedRangesInOrder);
        FacetResult facetResult = facetsCount.getTopChildren(this.rangesInOrder.size(), this.absoluteFieldPath, new String[0]);
        LinkedHashMap<Range<Range<K>>, Long> result = new LinkedHashMap<Range<Range<K>>, Long>();
        for (int i = 0; i < this.rangesInOrder.size(); ++i) {
            result.put(this.rangesInOrder.get(i), (long)((Integer)facetResult.labelValues[i].value));
        }
        return result;
    }

    public static class Builder<F, E extends Number, K>
    extends AbstractLuceneBucketAggregation.AbstractBuilder<Range<K>, Long>
    implements RangeAggregationBuilder<K> {
        private final String absoluteFieldPath;
        private final ToDocumentFieldValueConverter<?, ? extends F> toFieldValueConverter;
        private final AbstractLuceneNumericFieldCodec<F, E> codec;
        private final List<Range<K>> rangesInOrder = new ArrayList<Range<K>>();
        private final List<Range<E>> encodedRangesInOrder = new ArrayList<Range<E>>();

        public Builder(LuceneSearchContext searchContext, String absoluteFieldPath, ToDocumentFieldValueConverter<?, ? extends F> toFieldValueConverter, AbstractLuceneNumericFieldCodec<F, E> codec) {
            super(searchContext);
            this.absoluteFieldPath = absoluteFieldPath;
            this.toFieldValueConverter = toFieldValueConverter;
            this.codec = codec;
        }

        public void range(Range<? extends K> range) {
            this.rangesInOrder.add(range.map(Function.identity()));
            this.encodedRangesInOrder.add(range.map(this::convertAndEncode));
        }

        @Override
        public LuceneNumericRangeAggregation<F, E, K> build() {
            return new LuceneNumericRangeAggregation(this);
        }

        private E convertAndEncode(K value) {
            try {
                Object converted = this.toFieldValueConverter.convertUnknown(value, this.searchContext.getToDocumentFieldValueConvertContext());
                return (E)((Number)this.codec.encode(converted));
            }
            catch (RuntimeException e) {
                throw log.cannotConvertDslParameter(e.getMessage(), e, EventContexts.fromIndexFieldAbsolutePath((String)this.absoluteFieldPath));
            }
        }
    }
}

