/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.types.aggregation.impl;

import java.io.IOException;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.Set;
import org.apache.lucene.facet.FacetResult;
import org.apache.lucene.facet.FacetsCollector;
import org.apache.lucene.facet.FacetsConfig;
import org.apache.lucene.facet.sortedset.DefaultSortedSetDocValuesReaderState;
import org.apache.lucene.facet.sortedset.SortedSetDocValuesFacetCounts;
import org.apache.lucene.facet.sortedset.SortedSetDocValuesReaderState;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.SortedSetDocValues;
import org.hibernate.search.backend.lucene.search.impl.LuceneSearchContext;
import org.hibernate.search.backend.lucene.types.aggregation.impl.AbstractLuceneFacetsBasedTermsAggregation;
import org.hibernate.search.engine.backend.types.converter.FromDocumentFieldValueConverter;

public class LuceneTextTermsAggregation<K>
extends AbstractLuceneFacetsBasedTermsAggregation<String, String, K> {
    private static final Comparator<String> STRING_COMPARATOR = Comparator.naturalOrder();

    private LuceneTextTermsAggregation(Builder<K> builder) {
        super(builder);
    }

    @Override
    FacetResult getTopChildren(IndexReader reader, FacetsCollector facetsCollector, int limit) throws IOException {
        DefaultSortedSetDocValuesReaderState docValuesReaderState = new DefaultSortedSetDocValuesReaderState(reader);
        SortedSetDocValuesFacetCounts facetCounts = new SortedSetDocValuesFacetCounts((SortedSetDocValuesReaderState)docValuesReaderState, facetsCollector);
        return facetCounts.getTopChildren(limit, this.absoluteFieldPath, new String[0]);
    }

    @Override
    Set<String> collectFirstTerms(IndexReader reader, boolean descending, int limit) throws IOException {
        LinkedHashSet<String> collectedTerms = new LinkedHashSet<String>();
        DefaultSortedSetDocValuesReaderState docValuesReaderState = new DefaultSortedSetDocValuesReaderState(reader);
        SortedSetDocValuesReaderState.OrdRange ordRange = docValuesReaderState.getOrdRange(this.absoluteFieldPath);
        SortedSetDocValues docValues = docValuesReaderState.getDocValues();
        if (descending) {
            int start = Math.max(ordRange.start, ordRange.end - limit + 1);
            for (int i = ordRange.end; i >= start; --i) {
                collectedTerms.add(this.lookupOrd(docValues, i));
            }
        } else {
            int end = Math.min(ordRange.start + limit - 1, ordRange.end);
            for (int i = ordRange.start; i <= end; ++i) {
                collectedTerms.add(this.lookupOrd(docValues, i));
            }
        }
        return collectedTerms;
    }

    private String lookupOrd(SortedSetDocValues docValues, int ord) throws IOException {
        String pathAsString = docValues.lookupOrd((long)ord).utf8ToString();
        String[] pathAsComponents = FacetsConfig.stringToPath((String)pathAsString);
        return pathAsComponents[1];
    }

    @Override
    Comparator<String> getAscendingTermComparator() {
        return STRING_COMPARATOR;
    }

    @Override
    String labelToTerm(String label) {
        return label;
    }

    @Override
    String termToFieldValue(String key) {
        return key;
    }

    public static class Builder<K>
    extends AbstractLuceneFacetsBasedTermsAggregation.AbstractBuilder<String, String, K> {
        public Builder(LuceneSearchContext searchContext, String absoluteFieldPath, FromDocumentFieldValueConverter<? super String, ? extends K> fromFieldValueConverter) {
            super(searchContext, absoluteFieldPath, fromFieldValueConverter);
        }

        @Override
        public LuceneTextTermsAggregation<K> build() {
            return new LuceneTextTermsAggregation(this);
        }
    }
}

