/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.types.lowlevel.impl;

import java.util.Collection;
import org.apache.lucene.facet.range.DoubleRange;
import org.apache.lucene.facet.range.LongRange;
import org.hibernate.search.util.common.data.Range;
import org.hibernate.search.util.common.data.RangeBoundInclusion;

class FacetCountsUtils {
    private FacetCountsUtils() {
    }

    static LongRange[] createLongRanges(Collection<? extends Range<? extends Number>> ranges) {
        LongRange[] longRanges = new LongRange[ranges.size()];
        int i = 0;
        for (Range<? extends Number> range : ranges) {
            Number lowerBoundValue = range.getLowerBoundValue().orElse(null);
            Number upperBoundValue = range.getUpperBoundValue().orElse(null);
            longRanges[i] = new LongRange(String.valueOf(i), lowerBoundValue == null ? Long.MIN_VALUE : lowerBoundValue.longValue(), lowerBoundValue == null || RangeBoundInclusion.INCLUDED.equals((Object)range.getLowerBoundInclusion()), upperBoundValue == null ? Long.MAX_VALUE : upperBoundValue.longValue(), upperBoundValue == null || RangeBoundInclusion.INCLUDED.equals((Object)range.getUpperBoundInclusion()));
            ++i;
        }
        return longRanges;
    }

    static DoubleRange[] createDoubleRanges(Collection<? extends Range<? extends Number>> ranges) {
        DoubleRange[] doubleRanges = new DoubleRange[ranges.size()];
        int i = 0;
        for (Range<? extends Number> range : ranges) {
            Number lowerBoundValue = range.getLowerBoundValue().orElse(null);
            Number upperBoundValue = range.getUpperBoundValue().orElse(null);
            doubleRanges[i] = new DoubleRange(String.valueOf(i), lowerBoundValue == null ? Double.NEGATIVE_INFINITY : lowerBoundValue.doubleValue(), RangeBoundInclusion.INCLUDED.equals((Object)range.getLowerBoundInclusion()), upperBoundValue == null ? Double.POSITIVE_INFINITY : upperBoundValue.doubleValue(), RangeBoundInclusion.INCLUDED.equals((Object)range.getUpperBoundInclusion()));
            ++i;
        }
        return doubleRanges;
    }
}

