/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.types.lowlevel.impl;

import java.io.IOException;
import org.apache.lucene.index.NumericDocValues;
import org.hibernate.search.backend.lucene.types.lowlevel.impl.GeoPointDistanceDocValues;
import org.hibernate.search.backend.lucene.types.lowlevel.impl.SingleFloatValues;
import org.hibernate.search.backend.lucene.types.lowlevel.impl.SingletonSortedNumericDoubleValues;
import org.hibernate.search.backend.lucene.types.lowlevel.impl.SortableLongBitsToNumericDoubleValues;

public abstract class SortedNumericDoubleValues {
    protected SortedNumericDoubleValues() {
    }

    public abstract boolean advanceExact(int var1) throws IOException;

    public abstract double nextValue() throws IOException;

    public abstract int docValueCount();

    public static SortedNumericDoubleValues createDouble(NumericDocValues values) {
        return new SingletonSortedNumericDoubleValues(new SortableLongBitsToNumericDoubleValues(values));
    }

    public static SortedNumericDoubleValues createFloat(NumericDocValues values) {
        return new SingletonSortedNumericDoubleValues(new SingleFloatValues(values));
    }

    public static SortedNumericDoubleValues createDistance(GeoPointDistanceDocValues geoPointDistanceDocValues) {
        return new SingletonSortedNumericDoubleValues(geoPointDistanceDocValues);
    }
}

