/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.types.projection.impl;

import java.lang.invoke.MethodHandles;
import java.util.Set;
import org.hibernate.search.backend.lucene.logging.impl.Log;
import org.hibernate.search.backend.lucene.search.projection.impl.LuceneFieldProjectionBuilder;
import org.hibernate.search.backend.lucene.types.codec.impl.LuceneFieldCodec;
import org.hibernate.search.backend.lucene.types.projection.impl.LuceneFieldProjectionBuilderFactory;
import org.hibernate.search.engine.backend.types.converter.FromDocumentFieldValueConverter;
import org.hibernate.search.engine.reporting.spi.EventContexts;
import org.hibernate.search.engine.search.common.ValueConvert;
import org.hibernate.search.engine.search.projection.spi.DistanceToFieldProjectionBuilder;
import org.hibernate.search.engine.search.projection.spi.FieldProjectionBuilder;
import org.hibernate.search.engine.spatial.GeoPoint;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;

public class LuceneStandardFieldProjectionBuilderFactory<F>
implements LuceneFieldProjectionBuilderFactory {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    private final boolean projectable;
    private final FromDocumentFieldValueConverter<? super F, ?> converter;
    private final FromDocumentFieldValueConverter<? super F, F> rawConverter;
    private final LuceneFieldCodec<F> codec;

    public LuceneStandardFieldProjectionBuilderFactory(boolean projectable, FromDocumentFieldValueConverter<? super F, ?> converter, FromDocumentFieldValueConverter<? super F, F> rawConverter, LuceneFieldCodec<F> codec) {
        this.projectable = projectable;
        this.converter = converter;
        this.rawConverter = rawConverter;
        this.codec = codec;
    }

    public <T> FieldProjectionBuilder<T> createFieldValueProjectionBuilder(Set<String> indexNames, String absoluteFieldPath, String nestedDocumentPath, Class<T> expectedType, ValueConvert convert) {
        LuceneStandardFieldProjectionBuilderFactory.checkProjectable(absoluteFieldPath, this.projectable);
        FromDocumentFieldValueConverter<F, ?> requestConverter = this.getConverter(convert);
        if (!requestConverter.isConvertedTypeAssignableTo(expectedType)) {
            throw log.invalidProjectionInvalidType(absoluteFieldPath, expectedType, EventContexts.fromIndexFieldAbsolutePath((String)absoluteFieldPath));
        }
        return new LuceneFieldProjectionBuilder(indexNames, absoluteFieldPath, nestedDocumentPath, requestConverter, this.codec);
    }

    @Override
    public DistanceToFieldProjectionBuilder createDistanceProjectionBuilder(Set<String> indexNames, String absoluteFieldPath, String nestedDocumentPath, GeoPoint center) {
        throw log.distanceOperationsNotSupportedByFieldType(EventContexts.fromIndexFieldAbsolutePath((String)absoluteFieldPath));
    }

    @Override
    public boolean hasCompatibleCodec(LuceneFieldProjectionBuilderFactory other) {
        if (!this.getClass().equals(other.getClass())) {
            return false;
        }
        LuceneStandardFieldProjectionBuilderFactory castedOther = (LuceneStandardFieldProjectionBuilderFactory)other;
        return this.projectable == castedOther.projectable && this.codec.isCompatibleWith(castedOther.codec);
    }

    @Override
    public boolean hasCompatibleConverter(LuceneFieldProjectionBuilderFactory other) {
        if (!this.getClass().equals(other.getClass())) {
            return false;
        }
        LuceneStandardFieldProjectionBuilderFactory castedOther = (LuceneStandardFieldProjectionBuilderFactory)other;
        return this.converter.isCompatibleWith(castedOther.converter);
    }

    private static void checkProjectable(String absoluteFieldPath, boolean projectable) {
        if (!projectable) {
            throw log.nonProjectableField(absoluteFieldPath, EventContexts.fromIndexFieldAbsolutePath((String)absoluteFieldPath));
        }
    }

    private FromDocumentFieldValueConverter<? super F, ?> getConverter(ValueConvert convert) {
        switch (convert) {
            case NO: {
                return this.rawConverter;
            }
        }
        return this.converter;
    }
}

