/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.types.sort.comparatorsource.impl;

import java.io.IOException;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.NumericDocValues;
import org.apache.lucene.index.SortedNumericDocValues;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.FieldComparator;
import org.apache.lucene.util.BitSet;
import org.hibernate.search.backend.lucene.types.lowlevel.impl.GeoPointDistanceDocValues;
import org.hibernate.search.backend.lucene.types.lowlevel.impl.OnTheFlyNestedSorter;
import org.hibernate.search.backend.lucene.types.lowlevel.impl.SortedNumericDoubleValues;
import org.hibernate.search.backend.lucene.types.sort.comparatorsource.impl.LuceneFieldComparatorSource;

public class LuceneGeoPointDistanceComparatorSource
extends LuceneFieldComparatorSource {
    private static final double MISSING_VALUE_IMPLICIT_DISTANCE_VALUE = Double.POSITIVE_INFINITY;
    private final double latitude;
    private final double longitude;

    public LuceneGeoPointDistanceComparatorSource(String nestedDocumentPath, double latitude, double longitude) {
        super(nestedDocumentPath);
        this.latitude = latitude;
        this.longitude = longitude;
    }

    public FieldComparator<?> newComparator(String fieldname, int numHits, int sortPos, boolean reversed) {
        return new FieldComparator.DoubleComparator(numHits, fieldname, Double.POSITIVE_INFINITY){

            protected NumericDocValues getNumericDocValues(LeafReaderContext context, String field) throws IOException {
                SortedNumericDocValues sortedNumericDocValues = context.reader().getSortedNumericDocValues(field);
                GeoPointDistanceDocValues geoPointDistanceDocValues = new GeoPointDistanceDocValues(sortedNumericDocValues, LuceneGeoPointDistanceComparatorSource.this.latitude, LuceneGeoPointDistanceComparatorSource.this.longitude);
                if (LuceneGeoPointDistanceComparatorSource.this.nestedDocsProvider == null) {
                    return geoPointDistanceDocValues.getRawDoubleValues();
                }
                BitSet parentDocs = LuceneGeoPointDistanceComparatorSource.this.nestedDocsProvider.parentDocs(context);
                DocIdSetIterator childDocs = LuceneGeoPointDistanceComparatorSource.this.nestedDocsProvider.childDocs(context);
                if (parentDocs == null || childDocs == null) {
                    return geoPointDistanceDocValues.getRawDoubleValues();
                }
                SortedNumericDoubleValues sortedNumericDoubleValues = SortedNumericDoubleValues.createDistance(geoPointDistanceDocValues);
                return OnTheFlyNestedSorter.sort(sortedNumericDoubleValues, Double.POSITIVE_INFINITY, parentDocs, childDocs).getRawDoubleValues();
            }
        };
    }
}

